package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class FMG that implements the run() method of class thread.
 * <p>
 * Creating an object of this class means creating a new thread and immediately starting it. The run() method of this
 * thread than simply calls method FMG.fmgProper() of the FMG object that it is helping.
 */
final class FMGThread extends Thread {
     /**
      * construct from target FMG object and from the parameters that will be passed on to method FMG.fmgProper() and 
      * immediately start the thread, i.e. immediately start executing FMG.fmgProper().
      *
      * @param fmg             the target FMG object, i.e. the object whose fmgProper() method will be called from run()
      */
     public FMGThread(FMG fmg, int coarsestLevel, int finestLevel, int numPresmooth, int numPostsmooth, 
                      int cyclingStrategy, int numMultiGrid) {
          this.fmg              = fmg;
          this.coarsestLevel    = coarsestLevel;
          this.finestLevel      = finestLevel;
          this.numPresmooth     = numPresmooth;
          this.numPostsmooth    = numPostsmooth;
          this.cyclingStrategy  = cyclingStrategy;
          this.numMultiGrid     = numMultiGrid;
          
          start();
     }
     
     /**
      * re-routes to FMG.fmgProper()
      * <p>
      * implements method from Thread.
      *
      * @see Thread#run
      * @see FMG#fmgProper
      */
     public void run() {
          fmg.fmgProper(coarsestLevel,finestLevel,numPresmooth,numPostsmooth,cyclingStrategy,numMultiGrid);
     }
     
     private FMG fmg;
     private int coarsestLevel;
     private int finestLevel;
     private int numPresmooth;
     private int numPostsmooth;
     private int cyclingStrategy;
     private int numMultiGrid;
}
