package AT.Ac.univie.imp.loeffler.pde.threeD.fd;

/**
 * Interface to the constant methods of class Grid.
 *
 * @see Grid
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public interface ConstGrid extends Cloneable {
     /**
      * returns the element at the specified position.
      *
      * @param x the x index of the element (0 <= x < size())
      * @param y the y index of the element (0 <= y < size())
      * @param z the z index of the element (0 <= z < size())
      * @return  the element (a double value) at the specified position
      */
     double get(int x, int y, int z);

     /**
      * returns the size of the grid, i.e. the number of elements in each of the 3 directions of the grid.
      *
      * @return the size
      */
     int size();

     /**
      * determines if the specified element is in the interior of the grid.
      *
      * @param x the x index of the element
      * @param y the y index of the element
      * @param z the z index of the element
      * @return  true if the element is in the interior of the grid, false otherwise
      */
     boolean isInterior(int x, int y, int z);

     /**
      * determines if the specified element is at the boundary of the grid.
      *
      * @param x the x index of the element
      * @param y the y index of the element
      * @param z the z index of the element
      * @return  true if the element is at the boundary of the grid, false otherwise
      */
     boolean isBoundary(int x, int y, int z);

     /**
      * create a new grid with exactly the same handling of the boundary (i.e. of the same tzpe as this object) but of 
      * an arbitrary size and set all interior elements to a given value.
      *
      * @param size  the size of the grid which is to be created ( > 0)
      * @param value the value to which all interior grid elements are to be set
      * @return the newly constructed grid
      */
     Grid newInstance(int size, double value);
     
     /**
      * clone this grid
      */
     Object clone();

     /**
      * create a new grid that is the sum of this grid and the given grid.
      *
      * Only the interiors of the two grids are added. The types of the two grids must be identical and the handling of
      * the boundary is copied from this grid.
      *
      * @param grid the grid to add to this grid
      * @return the newly constructed grid that is the sum of the grids
      */
     Grid add(ConstGrid grid);
}
