package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.parallel.*;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class FMG that helps parallelizing method FMG.calcResidual().
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
final class CalcResidualParallelizer extends Parallelizer {
     /**
      * construct.
      *
      * @param fmg the FMG object with which this object co-operates
      */
     public CalcResidualParallelizer(FMG fmg, NoBoundaryGrid r, ConstBoundaryGrid u, ConstNoBoundaryGrid f) {
          this.fmg = fmg;
          this.r   = r;
          this.u   = u;
          this.f   = f;
          
          start();
     }
     
     /**
      * re-route.
      */
     public void runParallel(int myNum, int totalNum) {
          fmg.calcResidualProper(r,u,f,myNum,totalNum);
     }
     
     private FMG                 fmg;
     private NoBoundaryGrid      r;
     private ConstBoundaryGrid   u;
     private ConstNoBoundaryGrid f;
}
