package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * Solve a linear elliptic PDE at the coarsest level (level = 1), i.e. at grid size 3 through simple arithmetic.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class ArithmeticSolver implements Solver {
     /**
      * construct from the PDE
      *
      * @param pde the PDE to solve
      */
     public ArithmeticSolver(PDE pde) {
          Contract.pre(pde != null,"pde not null-object");
          
          this.pde = pde;
     }

     /**
      * implements method from Solver.
      * <p>
      * u and f must both have size 3 (corresponding to level 1) for this method to work!
      *
      * @see Solver#solve
      */
     public BoundaryGrid solve(ConstBoundaryGrid u, ConstNoBoundaryGrid f) {
          int size = u.size();
          
          Contract.pre(f.size() == size,"size of u equal size of f");
          Contract.pre(size == 3,"size of grids u and f must be 3x3x3");

          BoundaryGrid solution = (BoundaryGrid) u.newInstance(size,0);
          solution.set(1,1,1,pde.evaluate(u,f,1,1,1));
          return solution;
     }

     private PDE pde;
}
