/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;

public class Format {
    private static long instances;
    private int width;
    private int precision;
    private String pre;
    private String post;
    private boolean leading_zeroes;
    private boolean show_plus;
    private boolean alternate;
    private boolean show_space;
    private boolean left_align;
    private char fmt;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String string) {
        if (instances++ == 0L) {
            System.out.println(this.getClass().getName());
        }
        this.width = 0;
        this.precision = -1;
        this.pre = "";
        this.post = "";
        this.leading_zeroes = false;
        this.show_plus = false;
        this.alternate = false;
        this.show_space = false;
        this.left_align = false;
        this.fmt = (char)32;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string.charAt(n3 + 1) == '%') {
                    this.pre = String.valueOf(this.pre) + '%';
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = String.valueOf(this.pre) + string.charAt(n3);
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == ' ') {
                this.show_space = true;
            } else if (string.charAt(n3) == '-') {
                this.left_align = true;
            } else if (string.charAt(n3) == '+') {
                this.show_plus = true;
            } else if (string.charAt(n3) == '0') {
                this.leading_zeroes = true;
            } else if (string.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if (string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                this.width = this.width * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if (string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string.substring(n3, n);
    }

    public static void print(PrintStream printStream, String string, double d) {
        printStream.print(new Format(string).form(d));
    }

    public static void print(PrintStream printStream, String string, long l) {
        printStream.print(new Format(string).form(l));
    }

    public static void print(PrintStream printStream, String string, char c) {
        printStream.print(new Format(string).form(c));
    }

    public static void print(PrintStream printStream, String string, String string2) {
        printStream.print(new Format(string).form(string2));
    }

    public static int atoi(String string) {
        return (int)Format.atol(string);
    }

    public static long atol(String string) {
        int n = 0;
        while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '0') {
            if (n + 1 < string.length() && (string.charAt(n + 1) == 'x' || string.charAt(n + 1) == 'X')) {
                return Format.parseLong(string.substring(n + 2), 16);
            }
            return Format.parseLong(string, 8);
        }
        return Format.parseLong(string, 10);
    }

    private static long parseLong(String string, int n) {
        int n2 = 0;
        int n3 = 1;
        long l = 0L;
        while (n2 < string.length() && Character.isSpaceChar(string.charAt(n2))) {
            ++n2;
        }
        if (n2 < string.length() && string.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string.length() && string.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c >= '0' && c < 48 + n) {
                l = l * (long)n + (long)c - 48L;
            } else if (c >= 'A' && c < 65 + n - 10) {
                l = l * (long)n + (long)c - 65L + 10L;
            } else if (c >= 'a' && c < 97 + n - 10) {
                l = l * (long)n + (long)c - 97L + 10L;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String string) {
        int n = 0;
        int n2 = 1;
        double d = 0.0;
        double d2 = 1.0;
        boolean bl = false;
        while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
            ++n;
        }
        if (n < string.length() && string.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string.length() && string.charAt(n) == '+') {
            ++n;
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                if (!bl) {
                    d = d * 10.0 + (double)c - 48.0;
                } else if (bl) {
                    d += (d2 /= 10.0) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n2 * d;
                bl = true;
            } else {
                if (c != 'e' && c != 'E') return (double)n2 * d;
                long l = (int)Format.parseLong(string.substring(n + 1), 10);
                return (double)n2 * d * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d;
    }

    public String form(double d) {
        String string;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d < 0.0) {
            d = -d;
            n = -1;
        }
        if (this.fmt == 'f') {
            string = this.fixed_format(d);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string = this.exp_format(d);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String form(long l) {
        String string;
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            n = 1;
            if (l < 0L) {
                l = -l;
                n = -1;
            }
            string = String.valueOf(l);
        } else if (this.fmt == 'o') {
            string = Format.convert(l, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            string = Format.convert(l, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            string = Format.convert(l, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string = String.valueOf(c);
        return this.pad(string);
    }

    public String form(String string) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            string = string.substring(0, this.precision);
        }
        return this.pad(string);
    }

    public static void main(String[] stringArray) {
        double d = 1.23456789012;
        double d2 = 123.0;
        double d3 = 1.2345E30;
        double d4 = 1.02;
        double d5 = 1.234E-5;
        int n = 51966;
        Format.print(System.out, "x = |%f|\n", d);
        Format.print(System.out, "u = |%20f|\n", d5);
        Format.print(System.out, "x = |% .5f|\n", d);
        Format.print(System.out, "w = |%20.5f|\n", d4);
        Format.print(System.out, "x = |%020.5f|\n", d);
        Format.print(System.out, "x = |%+20.5f|\n", d);
        Format.print(System.out, "x = |%+020.5f|\n", d);
        Format.print(System.out, "x = |% 020.5f|\n", d);
        Format.print(System.out, "y = |%#+20.5f|\n", d2);
        Format.print(System.out, "y = |%-+20.5f|\n", d2);
        Format.print(System.out, "z = |%20.5f|\n", d3);
        Format.print(System.out, "x = |%e|\n", d);
        Format.print(System.out, "u = |%20e|\n", d5);
        Format.print(System.out, "x = |% .5e|\n", d);
        Format.print(System.out, "w = |%20.5e|\n", d4);
        Format.print(System.out, "x = |%020.5e|\n", d);
        Format.print(System.out, "x = |%+20.5e|\n", d);
        Format.print(System.out, "x = |%+020.5e|\n", d);
        Format.print(System.out, "x = |% 020.5e|\n", d);
        Format.print(System.out, "y = |%#+20.5e|\n", d2);
        Format.print(System.out, "y = |%-+20.5e|\n", d2);
        Format.print(System.out, "x = |%g|\n", d);
        Format.print(System.out, "z = |%g|\n", d3);
        Format.print(System.out, "w = |%g|\n", d4);
        Format.print(System.out, "u = |%g|\n", d5);
        Format.print(System.out, "y = |%.2g|\n", d2);
        Format.print(System.out, "y = |%#.2g|\n", d2);
        Format.print(System.out, "d = |%d|\n", n);
        Format.print(System.out, "d = |%20d|\n", n);
        Format.print(System.out, "d = |%020d|\n", n);
        Format.print(System.out, "d = |%+20d|\n", n);
        Format.print(System.out, "d = |% 020d|\n", n);
        Format.print(System.out, "d = |%-20d|\n", n);
        Format.print(System.out, "d = |%20.8d|\n", n);
        Format.print(System.out, "d = |%x|\n", n);
        Format.print(System.out, "d = |%20X|\n", n);
        Format.print(System.out, "d = |%#20x|\n", n);
        Format.print(System.out, "d = |%020X|\n", n);
        Format.print(System.out, "d = |%20.8x|\n", n);
        Format.print(System.out, "d = |%o|\n", n);
        Format.print(System.out, "d = |%020o|\n", n);
        Format.print(System.out, "d = |%#20o|\n", n);
        Format.print(System.out, "d = |%#020o|\n", n);
        Format.print(System.out, "d = |%20.12o|\n", n);
        Format.print(System.out, "s = |%-20s|\n", "Hello");
        Format.print(System.out, "s = |%-20c|\n", '!');
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String convert(long l, int n, int n2, String string) {
        if (l == 0L) {
            return "0";
        }
        String string2 = "";
        while (l != 0L) {
            string2 = String.valueOf(string.charAt((int)(l & (long)n2))) + string2;
            l >>>= n;
        }
        return string2;
    }

    private String pad(String string) {
        String string2 = Format.repeat(' ', this.width - string.length());
        if (this.left_align) {
            return String.valueOf(this.pre) + string + string2 + this.post;
        }
        return String.valueOf(this.pre) + string2 + string + this.post;
    }

    private String sign(int n, String string) {
        String string2 = "";
        if (n < 0) {
            string2 = "-";
        } else if (n > 0) {
            if (this.show_plus) {
                string2 = "+";
            } else if (this.show_space) {
                string2 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            string2 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string2 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string2 = "0X";
        }
        int n2 = 0;
        if (this.leading_zeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return String.valueOf(string2) + Format.repeat('0', n2 - string2.length() - string.length()) + string;
    }

    private String fixed_format(double d) {
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        double d2 = 0.5;
        int n = 1;
        while (n <= this.precision) {
            d2 /= 10.0;
            ++n;
        }
        long l = (long)(d + d2);
        String string = String.valueOf(l);
        double d3 = d - (double)l;
        if (d3 >= 1.0 + d2 || d3 < -d2) {
            return this.exp_format(d);
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 >= 1.0) {
            d3 -= d2;
        }
        return String.valueOf(string) + this.frac_part(d3);
    }

    private String frac_part(double d) {
        String string = "";
        if (this.precision > 0) {
            double d2 = 1.0;
            String string2 = "";
            int n = 1;
            while (n <= this.precision && d2 <= 9.223372036854776E18) {
                d2 *= 10.0;
                string2 = String.valueOf(string2) + "0";
                ++n;
            }
            long l = (long)(d2 * d + 0.5);
            string = String.valueOf(string2) + l;
            string = string.substring(string.length() - this.precision, string.length());
        }
        if (this.precision > 0 || this.alternate) {
            string = "." + string;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int n = string.length() - 1;
            while (n >= 0 && string.charAt(n) == '0') {
                --n;
            }
            if (n >= 0 && string.charAt(n) == '.') {
                --n;
            }
            string = string.substring(0, n + 1);
        }
        return string;
    }

    private String exp_format(double d) {
        String string = "";
        int n = 0;
        double d2 = d;
        double d3 = 1.0;
        while (d2 > 10.0) {
            ++n;
            d3 /= 10.0;
            d2 /= 10.0;
        }
        while (d2 < 1.0) {
            --n;
            d3 *= 10.0;
            d2 *= 10.0;
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixed_format(d);
        }
        string = String.valueOf(string) + this.fixed_format(d *= d3);
        string = this.fmt == 'e' || this.fmt == 'g' ? String.valueOf(string) + "e" : String.valueOf(string) + "E";
        String string2 = "000";
        if (n >= 0) {
            string = String.valueOf(string) + "+";
            string2 = String.valueOf(string2) + n;
        } else {
            string = String.valueOf(string) + "-";
            string2 = String.valueOf(string2) + -n;
        }
        return String.valueOf(string) + string2.substring(string2.length() - 3, string2.length());
    }
}

