/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;

public class DrawingRegion
extends Canvas {
    int op = 3;
    public static final int grid_count = 60;
    public static final int CATCH_RADIUS = 100;
    public int gridUnit;
    double gridUnitWorldValue = 0.2;
    double gridScale;
    double gridScaleInv;
    public int N_vectors;
    public boolean add_defined = false;
    int vert_unit;
    public int x0;
    public int y0;
    public int old_x;
    public int old_y;
    public VectorLine[] V = new VectorLine[]{new VectorLine(), new VectorLine(), new VectorLine()};
    public Color[] VectorColor = new Color[]{Defs.v0Colour, Defs.v1Colour, Defs.v2Colour};
    Font boldFont = new Font("Helvetica", 1, 14);
    Font plainFont = new Font("Helvetica", 0, 14);
    Font numericFont = new Font("Courier", 0, 12);
    Font labelFont = new Font("Helvetica", 0, 12);
    LineSegment[] L = new LineSegment[]{new LineSegment(), new LineSegment()};
    ComplexPanel z1;
    ComplexPanel z2;
    ComplexPanel z3;

    DrawingRegion(ComplexPanel complexPanel, ComplexPanel complexPanel2, ComplexPanel complexPanel3) {
        System.out.println(this.getClass().getName());
        this.z1 = complexPanel;
        this.z2 = complexPanel2;
        this.z3 = complexPanel3;
        this.x0 = this.size().width / 2;
        this.y0 = this.size().height / 2;
        this.old_y = 0;
        this.old_x = 0;
        this.gridUnit = Math.min(this.size().width, this.size().height) / 60;
        this.gridScale = this.gridUnitWorldValue / (double)this.gridUnit;
        this.gridScaleInv = 1.0 / this.gridScale;
        int n = 0;
        while (n < 3) {
            this.V[n].setColor(this.VectorColor[n]);
            ++n;
        }
        this.setBackground(Color.white);
    }

    public void addNotify() {
        super.addNotify();
        System.out.println("DrawingRegion peer exists");
        this.gridUnit = Math.min(this.size().width, this.size().height) / 60;
        this.gridScale = this.gridUnitWorldValue / (double)this.gridUnit;
        this.gridScaleInv = 1.0 / this.gridScale;
    }

    private void draw_XY_grid(Graphics graphics) {
        this.gridUnit = Math.min(this.size().width, this.size().height) / 60;
        this.gridScale = this.gridUnitWorldValue / (double)this.gridUnit;
        this.gridScaleInv = 1.0 / this.gridScale;
        this.x0 = this.size().width / 2;
        this.y0 = this.size().height / 2;
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = n / 2;
        int n4 = n2 / 2;
        graphics.setColor(Defs.axesColour);
        graphics.drawLine(n3, 0, n3, n2);
        graphics.drawLine(0, n4, n, n4);
        int n5 = (int)Math.round((double)this.gridUnit / this.gridUnitWorldValue);
        int n6 = (int)Math.round((double)this.gridUnit / this.gridUnitWorldValue * 0.707);
        int n7 = (int)Math.round((double)this.gridUnit / this.gridUnitWorldValue * Math.PI);
        int n8 = (int)Math.round((double)this.gridUnit / this.gridUnitWorldValue * Math.PI * 0.707);
        graphics.setFont(this.labelFont);
        graphics.setColor(Color.gray);
        graphics.drawOval(n3 - n5, n4 - n5, 2 * n5 - 1, 2 * n5 - 1);
        graphics.setColor(Color.gray);
        graphics.drawString("unit circle", n3 - n6 + 5, n4 + n6 - 5);
        graphics.setColor(Color.gray);
        graphics.drawOval(n3 - n7, n4 - n7, 2 * n7 - 1, 2 * n7 - 1);
        graphics.setColor(Color.gray);
        graphics.drawString("pi", n3 - n8 + 5, n4 + n8 - 5);
        graphics.drawString("imaginary", n3 + 2, 15);
        graphics.drawString("real", n - 28, n4 - 5);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        this.draw_XY_grid(graphics);
        int n = 0;
        while (n < this.N_vectors) {
            this.V[n].initColor(graphics);
            this.V[n].drawThick(graphics);
            ++n;
        }
    }

    public void clear_all() {
        Graphics graphics = this.getGraphics();
        this.add_defined = false;
        while (this.N_vectors > 0) {
            --this.N_vectors;
        }
        this.paint(graphics);
    }

    public void clear_last() {
        Graphics graphics = this.getGraphics();
        if (this.N_vectors == 3) {
            this.add_defined = false;
        }
        if (this.N_vectors > 0) {
            --this.N_vectors;
        }
        this.paint(graphics);
    }

    public void hide2ndVector() {
        this.V[1].visibility(false);
    }

    public void show2ndVector() {
        this.V[1].visibility(true);
    }

    private ALMA_Complex toWorld(VectorLine vectorLine) {
        return new ALMA_Complex((double)(vectorLine.x2 - this.x0) * this.gridScale, (double)(-(vectorLine.y2 - this.y0)) * this.gridScale);
    }

    private void toScreen(ALMA_Complex aLMA_Complex, VectorLine vectorLine) {
        if (aLMA_Complex.isInfinite() || aLMA_Complex.isNaN()) {
            vectorLine.set(this.x0, this.y0, this.x0, this.y0);
            return;
        }
        vectorLine.set(this.x0, this.y0, (int)Math.round(aLMA_Complex.re() * this.gridScaleInv) + this.x0, (int)Math.round(-aLMA_Complex.im() * this.gridScaleInv) + this.y0);
    }

    private void myOp(VectorLine vectorLine, VectorLine vectorLine2, int n, VectorLine vectorLine3) {
        ALMA_Complex aLMA_Complex;
        ALMA_Complex aLMA_Complex2 = this.toWorld(vectorLine);
        ALMA_Complex aLMA_Complex3 = this.toWorld(vectorLine2);
        switch (n) {
            case 21: {
                aLMA_Complex = ALMA_Complex.pow(aLMA_Complex2, aLMA_Complex3);
                break;
            }
            case 22: {
                aLMA_Complex = ALMA_Complex.cart(aLMA_Complex2.re(), 0.0);
                break;
            }
            case 16: {
                aLMA_Complex = ALMA_Complex.cart(0.0, aLMA_Complex2.im());
                break;
            }
            case 20: {
                aLMA_Complex = ALMA_Complex.cart(aLMA_Complex2.norm(), 0.0);
                break;
            }
            case 0: {
                aLMA_Complex = ALMA_Complex.cart(aLMA_Complex2.abs(), 0.0);
                break;
            }
            case 4: {
                aLMA_Complex = ALMA_Complex.cart(aLMA_Complex2.arg(), 0.0);
                break;
            }
            case 19: {
                aLMA_Complex = aLMA_Complex2.neg();
                break;
            }
            case 9: {
                aLMA_Complex = aLMA_Complex2.conj();
                break;
            }
            case 23: {
                aLMA_Complex = aLMA_Complex2.scale(aLMA_Complex3.re());
                break;
            }
            case 3: {
                aLMA_Complex = aLMA_Complex2.add(aLMA_Complex3);
                break;
            }
            case 28: {
                aLMA_Complex = aLMA_Complex2.sub(aLMA_Complex3);
                break;
            }
            case 18: {
                aLMA_Complex = aLMA_Complex2.mul(aLMA_Complex3);
                break;
            }
            case 14: {
                aLMA_Complex = aLMA_Complex2.div(aLMA_Complex3);
                break;
            }
            case 27: {
                aLMA_Complex = aLMA_Complex2.sqrt();
                break;
            }
            case 15: {
                aLMA_Complex = aLMA_Complex2.exp();
                break;
            }
            case 17: {
                aLMA_Complex = aLMA_Complex2.log();
                break;
            }
            case 25: {
                aLMA_Complex = aLMA_Complex2.sin();
                break;
            }
            case 10: {
                aLMA_Complex = aLMA_Complex2.cos();
                break;
            }
            case 29: {
                aLMA_Complex = aLMA_Complex2.tan();
                break;
            }
            case 11: {
                aLMA_Complex = aLMA_Complex2.cosec();
                break;
            }
            case 24: {
                aLMA_Complex = aLMA_Complex2.sec();
                break;
            }
            case 13: {
                aLMA_Complex = aLMA_Complex2.cot();
                break;
            }
            case 26: {
                aLMA_Complex = aLMA_Complex2.sinh();
                break;
            }
            case 12: {
                aLMA_Complex = aLMA_Complex2.cosh();
                break;
            }
            case 30: {
                aLMA_Complex = aLMA_Complex2.tanh();
                break;
            }
            case 5: {
                aLMA_Complex = aLMA_Complex2.asin();
                break;
            }
            case 1: {
                aLMA_Complex = aLMA_Complex2.acos();
                break;
            }
            case 7: {
                aLMA_Complex = aLMA_Complex2.atan();
                break;
            }
            case 6: {
                aLMA_Complex = aLMA_Complex2.asinh();
                break;
            }
            case 2: {
                aLMA_Complex = aLMA_Complex2.acosh();
                break;
            }
            case 8: {
                aLMA_Complex = aLMA_Complex2.atanh();
                break;
            }
            default: {
                aLMA_Complex = ALMA_Complex.i;
            }
        }
        this.z1.set(aLMA_Complex2);
        this.z2.set(aLMA_Complex3);
        this.z3.set(aLMA_Complex);
        this.toScreen(aLMA_Complex, vectorLine3);
    }

    public void setOp(String string) {
        if (string.equals(Defs.string[21])) {
            this.op = 21;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[22])) {
            this.op = 22;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[16])) {
            this.op = 16;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[20])) {
            this.op = 20;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[0])) {
            this.op = 0;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[4])) {
            this.op = 4;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[19])) {
            this.op = 19;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[9])) {
            this.op = 9;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[23])) {
            this.op = 23;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[3])) {
            this.op = 3;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[28])) {
            this.op = 28;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[18])) {
            this.op = 18;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[14])) {
            this.op = 14;
            this.z2.show();
            this.show2ndVector();
            return;
        }
        if (string.equals(Defs.string[27])) {
            this.op = 27;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[15])) {
            this.op = 15;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[17])) {
            this.op = 17;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[25])) {
            this.op = 25;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[10])) {
            this.op = 10;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[29])) {
            this.op = 29;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[11])) {
            this.op = 11;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[24])) {
            this.op = 24;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[13])) {
            this.op = 13;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[26])) {
            this.op = 26;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[12])) {
            this.op = 12;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[30])) {
            this.op = 30;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[5])) {
            this.op = 5;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[1])) {
            this.op = 1;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[7])) {
            this.op = 7;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[6])) {
            this.op = 6;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[2])) {
            this.op = 2;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        if (string.equals(Defs.string[8])) {
            this.op = 8;
            this.z2.hide();
            this.hide2ndVector();
            return;
        }
        this.op = -1;
        this.z1.hide();
        this.z2.hide();
        this.z3.hide();
    }

    public void set_sum_vector() {
        this.myOp(this.V[0], this.V[1], this.op, this.V[2]);
        this.V[2].setName("Hello World!");
        this.L[0].set(this.V[0].x2, this.V[0].y2, this.V[2].x2, this.V[2].y2, Color.black);
        this.L[1].set(this.V[1].x2, this.V[1].y2, this.V[2].x2, this.V[2].y2, Color.black);
    }

    public void draw_add(Graphics graphics) {
        this.V[2].initColor(graphics);
        this.V[2].drawThick(graphics);
    }

    public void add_vectors() {
        Graphics graphics = this.getGraphics();
        this.set_sum_vector();
        this.draw_add(graphics);
    }

    public String MyConversion(double d) {
        d = (double)Math.round(10.0 * d) / 10.0;
        return Double.toString(d);
    }

    public int whichMouseButton(Event event) {
        int n = 1;
        if ((event.modifiers & 4) != 0) {
            n = 2;
        } else if ((event.modifiers & 8) != 0) {
            n = 3;
        }
        return n;
    }

    private int clipCoord(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        System.out.println("DrawingRegion.mouseDown " + event + " x= " + n + " y= " + n2);
        int n3 = 1000;
        int n4 = 1000;
        int n5 = this.whichMouseButton(event);
        if (n5 != 1) {
            return true;
        }
        n = this.clipCoord(n, this.size().width);
        n2 = this.clipCoord(n2, this.size().height);
        if (this.N_vectors < 2) {
            Graphics graphics = this.getGraphics();
            this.V[this.N_vectors].set(this.x0, this.y0, n, n2);
            graphics.setColor(Color.black);
            this.V[this.N_vectors].draw(graphics);
        } else if (this.N_vectors == 2 || this.N_vectors == 3) {
            n3 = (event.x - this.V[0].x2) * (event.x - this.V[0].x2) + (event.y - this.V[0].y2) * (event.y - this.V[0].y2);
            n4 = (event.x - this.V[1].x2) * (event.x - this.V[1].x2) + (event.y - this.V[1].y2) * (event.y - this.V[1].y2);
            Graphics graphics = this.getGraphics();
            if (n3 <= n4 && n3 < 100) {
                this.V[0].make_alive();
                graphics.setColor(Color.white);
                this.V[0].drawThick(graphics);
                this.V[0].initColor(graphics);
                this.V[0].draw(graphics);
                if (this.N_vectors == 3) {
                    this.V[2].make_alive();
                    graphics.setColor(Color.white);
                    this.V[2].drawThick(graphics);
                    this.V[2].initColor(graphics);
                    this.V[2].draw(graphics);
                }
                this.old_x = this.V[0].x2;
                this.old_y = this.V[0].y2;
                this.draw_XY_grid(graphics);
            } else if (n4 < 100) {
                this.V[1].make_alive();
                graphics.setColor(Color.white);
                this.V[1].drawThick(graphics);
                this.V[1].initColor(graphics);
                this.V[1].draw(graphics);
                if (this.N_vectors == 3) {
                    this.V[2].make_alive();
                    graphics.setColor(Color.white);
                    this.V[2].drawThick(graphics);
                    this.V[2].initColor(graphics);
                    this.V[2].draw(graphics);
                }
                this.old_x = this.V[1].x2;
                this.old_y = this.V[1].y2;
                this.draw_XY_grid(graphics);
            }
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        System.out.println("DrawingRegion.mouseUp " + event + " x= " + n + " y= " + n2);
        int n3 = this.whichMouseButton(event);
        if (n3 != 1) {
            return true;
        }
        n = this.clipCoord(n, this.size().width);
        n2 = this.clipCoord(n2, this.size().height);
        if (this.N_vectors < 2) {
            Graphics graphics = this.getGraphics();
            this.V[this.N_vectors].set(this.x0, this.y0, n, n2);
            this.V[this.N_vectors].setColor(this.VectorColor[this.N_vectors]);
            this.V[this.N_vectors].initColor(graphics);
            this.V[this.N_vectors].drawThick(graphics);
            ++this.N_vectors;
        }
        if (this.N_vectors == 2 || this.N_vectors == 3) {
            int n4 = 0;
            while (n4 < 2) {
                if (this.V[n4].is_alive) {
                    this.getGraphics();
                    this.V[n4].make_dead();
                    if (this.N_vectors == 3) {
                        this.V[2].make_dead();
                    }
                    this.repaint();
                }
                ++n4;
            }
        }
        if (this.N_vectors == 2) {
            this.add_vectors();
            ++this.N_vectors;
            this.add_defined = true;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        int n3 = this.whichMouseButton(event);
        if (n3 != 1) {
            return true;
        }
        n = this.clipCoord(n, this.size().width);
        n2 = this.clipCoord(n2, this.size().height);
        if (this.N_vectors < 2) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            this.V[this.N_vectors].draw(graphics);
            graphics.setPaintMode();
            graphics.setColor(Color.white);
            this.V[this.N_vectors].set(this.x0, this.y0, n, n2);
            this.V[this.N_vectors].initColor(graphics);
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            this.V[this.N_vectors].draw(graphics);
        } else if (this.N_vectors == 2 || this.N_vectors == 3) {
            int n4 = 0;
            while (n4 < 2) {
                if (this.V[n4].is_alive) {
                    Graphics graphics = this.getGraphics();
                    graphics.setColor(Color.black);
                    graphics.setXORMode(Color.white);
                    this.V[n4].draw(graphics);
                    if (this.N_vectors == 3) {
                        this.V[2].draw(graphics);
                    }
                    graphics.setPaintMode();
                    graphics.setColor(Color.white);
                    this.V[n4].set(this.x0, this.y0, n, n2);
                    if (this.N_vectors == 3) {
                        this.myOp(this.V[0], this.V[1], this.op, this.V[2]);
                        this.L[0].set(this.V[0].x2, this.V[0].y2, this.V[2].x2, this.V[2].y2, Color.black);
                        this.L[1].set(this.V[1].x2, this.V[1].y2, this.V[2].x2, this.V[2].y2, Color.black);
                    }
                    this.V[n4].initColor(graphics);
                    graphics.setColor(Color.black);
                    graphics.setXORMode(Color.white);
                    this.V[n4].draw(graphics);
                    if (this.N_vectors == 3) {
                        this.V[2].draw(graphics);
                    }
                }
                ++n4;
            }
        }
        return true;
    }
}

