/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class ALMA_Complex
implements Cloneable,
Serializable {
    public static final String VERSION = "1.0 FINAL alm";
    public static final String DATE = "Thu 17-Jul-97";
    public static final String AUTHOR = "sandy@almide.demon.co.uk, pidge@eece.maine.edu";
    public static final String REMARK = "Class available from http://www.javashareware.com/";
    protected static final double TWO_PI = Math.PI * 2;
    public static final ALMA_Complex i = new ALMA_Complex(0.0, 1.0);
    private double re;
    private double im;
    static /* synthetic */ Class class$ALMA_Complex;

    public ALMA_Complex() {
        this(0.0, 0.0);
    }

    public ALMA_Complex(double d) {
        this(d, 0.0);
    }

    public ALMA_Complex(ALMA_Complex aLMA_Complex) {
        this(aLMA_Complex.re, aLMA_Complex.im);
    }

    public ALMA_Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public static void main(String[] stringArray) {
        System.out.println();
        System.out.println("Module : " + (class$ALMA_Complex != null ? class$ALMA_Complex : (class$ALMA_Complex = ALMA_Complex.class$("ALMA_Complex"))).getName());
        System.out.println("Version: 1.0 FINAL alm");
        System.out.println("Date   : Thu 17-Jul-97");
        System.out.println("Author : sandy@almide.demon.co.uk, pidge@eece.maine.edu");
        System.out.println("Remark : Class available from http://www.javashareware.com/");
        System.out.println();
        System.out.println("Hint:  use TestComplex to test the class.");
        System.out.println();
    }

    public static ALMA_Complex real(double d) {
        return new ALMA_Complex(d, 0.0);
    }

    public static ALMA_Complex cart(double d, double d2) {
        return new ALMA_Complex(d, d2);
    }

    public static ALMA_Complex polar(double d, double d2) {
        if (d < 0.0) {
            d2 += Math.PI;
            d = -d;
        }
        return ALMA_Complex.cart(d * Math.cos(d2 %= Math.PI * 2), d * Math.sin(d2));
    }

    public static ALMA_Complex pow(ALMA_Complex aLMA_Complex, double d) {
        double d2 = d * Math.log(aLMA_Complex.abs());
        double d3 = d * aLMA_Complex.arg();
        double d4 = Math.exp(d2);
        return ALMA_Complex.cart(d4 * Math.cos(d3), d4 * Math.sin(d3));
    }

    public static ALMA_Complex pow(double d, ALMA_Complex aLMA_Complex) {
        double d2 = Math.log(Math.abs(d));
        double d3 = Math.atan2(0.0, d);
        double d4 = d2 * aLMA_Complex.re - d3 * aLMA_Complex.im;
        double d5 = d2 * aLMA_Complex.im + d3 * aLMA_Complex.re;
        double d6 = Math.exp(d4);
        return ALMA_Complex.cart(d6 * Math.cos(d5), d6 * Math.sin(d5));
    }

    public static ALMA_Complex pow(ALMA_Complex aLMA_Complex, ALMA_Complex aLMA_Complex2) {
        double d = Math.log(aLMA_Complex.abs());
        double d2 = aLMA_Complex.arg();
        double d3 = d * aLMA_Complex2.re - d2 * aLMA_Complex2.im;
        double d4 = d * aLMA_Complex2.im + d2 * aLMA_Complex2.re;
        double d5 = Math.exp(d3);
        return ALMA_Complex.cart(d5 * Math.cos(d4), d5 * Math.sin(d4));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(ALMA_Complex aLMA_Complex, double d) {
        return ALMA_Complex.abs(this.re - aLMA_Complex.re, this.im - aLMA_Complex.im) <= d;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public double norm() {
        return this.re * this.re + this.im * this.im;
    }

    public double abs() {
        return ALMA_Complex.abs(this.re, this.im);
    }

    private static double abs(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 >= d4) {
            double d5 = d2 / d;
            return d3 * Math.sqrt(1.0 + d5 * d5);
        }
        double d6 = d / d2;
        return d4 * Math.sqrt(1.0 + d6 * d6);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public ALMA_Complex neg() {
        return this.scale(-1.0);
    }

    public ALMA_Complex conj() {
        return ALMA_Complex.cart(this.re, -this.im);
    }

    private static void inv(ALMA_Complex aLMA_Complex) {
        double d;
        double d2;
        if (Math.abs(aLMA_Complex.re) >= Math.abs(aLMA_Complex.im)) {
            double d3;
            d2 = d3 = 1.0 / (aLMA_Complex.re + aLMA_Complex.im * (aLMA_Complex.im / aLMA_Complex.re));
            d = d3 * (-aLMA_Complex.im / aLMA_Complex.re);
        } else {
            double d4 = 1.0 / (aLMA_Complex.re * (aLMA_Complex.re / aLMA_Complex.im) + aLMA_Complex.im);
            d2 = d4 * (aLMA_Complex.re / aLMA_Complex.im);
            d = -d4;
        }
        aLMA_Complex.re = d2;
        aLMA_Complex.im = d;
    }

    public ALMA_Complex scale(double d) {
        return ALMA_Complex.cart(d * this.re, d * this.im);
    }

    public ALMA_Complex add(ALMA_Complex aLMA_Complex) {
        return ALMA_Complex.cart(this.re + aLMA_Complex.re, this.im + aLMA_Complex.im);
    }

    public ALMA_Complex sub(ALMA_Complex aLMA_Complex) {
        return ALMA_Complex.cart(this.re - aLMA_Complex.re, this.im - aLMA_Complex.im);
    }

    public ALMA_Complex mul(ALMA_Complex aLMA_Complex) {
        return ALMA_Complex.cart(this.re * aLMA_Complex.re - this.im * aLMA_Complex.im, this.re * aLMA_Complex.im + this.im * aLMA_Complex.re);
    }

    public ALMA_Complex div(ALMA_Complex aLMA_Complex) {
        ALMA_Complex aLMA_Complex2 = new ALMA_Complex(this);
        ALMA_Complex.div(aLMA_Complex2, aLMA_Complex.re, aLMA_Complex.im);
        return aLMA_Complex2;
    }

    private static void div(ALMA_Complex aLMA_Complex, double d, double d2) {
        double d3;
        double d4;
        if (Math.abs(d) >= Math.abs(d2)) {
            double d5 = 1.0 / (d + d2 * (d2 / d));
            d4 = d5 * (aLMA_Complex.re + aLMA_Complex.im * (d2 / d));
            d3 = d5 * (aLMA_Complex.im - aLMA_Complex.re * (d2 / d));
        } else {
            double d6 = 1.0 / (d * (d / d2) + d2);
            d4 = d6 * (aLMA_Complex.re * (d / d2) + aLMA_Complex.im);
            d3 = d6 * (aLMA_Complex.im * (d / d2) - aLMA_Complex.re);
        }
        aLMA_Complex.re = d4;
        aLMA_Complex.im = d3;
    }

    public ALMA_Complex sqrt() {
        ALMA_Complex aLMA_Complex = new ALMA_Complex(this);
        ALMA_Complex.sqrt(aLMA_Complex);
        return aLMA_Complex;
    }

    private static void sqrt(ALMA_Complex aLMA_Complex) {
        double d = aLMA_Complex.abs();
        if (d > 0.0) {
            if (aLMA_Complex.re > 0.0) {
                double d2;
                aLMA_Complex.re = d2 = Math.sqrt(0.5 * (d + aLMA_Complex.re));
                aLMA_Complex.im = 0.5 * aLMA_Complex.im / d2;
                return;
            }
            double d3 = Math.sqrt(0.5 * (d - aLMA_Complex.re));
            if (aLMA_Complex.im < 0.0) {
                d3 = -d3;
            }
            aLMA_Complex.re = 0.5 * aLMA_Complex.im / d3;
            aLMA_Complex.im = d3;
            return;
        }
        aLMA_Complex.re = 0.0;
        aLMA_Complex.im = 0.0;
    }

    public ALMA_Complex pow(ALMA_Complex aLMA_Complex) {
        return ALMA_Complex.pow(this, aLMA_Complex);
    }

    public ALMA_Complex exp() {
        double d = Math.exp(this.re);
        return ALMA_Complex.cart(d * Math.cos(this.im), d * Math.sin(this.im));
    }

    public ALMA_Complex log() {
        return ALMA_Complex.cart(Math.log(this.abs()), this.arg());
    }

    public ALMA_Complex sin() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d5 -= d7), -0.5 * (d4 -= d6));
        return aLMA_Complex;
    }

    public ALMA_Complex cos() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d4 += d6), 0.5 * (d5 += d7));
        return aLMA_Complex;
    }

    public ALMA_Complex tan() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        double d8 = d4 - d6;
        double d9 = d5 - d7;
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * d9, -0.5 * d8);
        d8 = d4 + d6;
        d9 = d5 + d7;
        double d10 = 0.5 * d8;
        double d11 = 0.5 * d9;
        ALMA_Complex.div(aLMA_Complex, d10, d11);
        return aLMA_Complex;
    }

    public ALMA_Complex cosec() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d5 -= d7), -0.5 * (d4 -= d6));
        ALMA_Complex.inv(aLMA_Complex);
        return aLMA_Complex;
    }

    public ALMA_Complex sec() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d4 += d6), 0.5 * (d5 += d7));
        ALMA_Complex.inv(aLMA_Complex);
        return aLMA_Complex;
    }

    public ALMA_Complex cot() {
        double d = -this.im;
        double d2 = this.re;
        double d3 = Math.exp(d);
        double d4 = d3 * Math.cos(d2);
        double d5 = d3 * Math.sin(d2);
        d3 = Math.exp(-d);
        double d6 = d3 * Math.cos(-d2);
        double d7 = d3 * Math.sin(-d2);
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * d8, 0.5 * d9);
        d8 = d4 - d6;
        d9 = d5 - d7;
        double d10 = 0.5 * d9;
        double d11 = -0.5 * d8;
        ALMA_Complex.div(aLMA_Complex, d10, d11);
        return aLMA_Complex;
    }

    public ALMA_Complex sinh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d2 -= d4), 0.5 * (d3 -= d5));
        return aLMA_Complex;
    }

    public ALMA_Complex cosh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * (d2 += d4), 0.5 * (d3 += d5));
        return aLMA_Complex;
    }

    public ALMA_Complex tanh() {
        double d = Math.exp(this.re);
        double d2 = d * Math.cos(this.im);
        double d3 = d * Math.sin(this.im);
        d = Math.exp(-this.re);
        double d4 = d * Math.cos(-this.im);
        double d5 = d * Math.sin(-this.im);
        double d6 = d2 - d4;
        double d7 = d3 - d5;
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(0.5 * d6, 0.5 * d7);
        d6 = d2 + d4;
        d7 = d3 + d5;
        double d8 = 0.5 * d6;
        double d9 = 0.5 * d7;
        ALMA_Complex.div(aLMA_Complex, d8, d9);
        return aLMA_Complex;
    }

    public ALMA_Complex asin() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(d, d2);
        ALMA_Complex.sqrt(aLMA_Complex);
        d = -this.im;
        d2 = this.re;
        aLMA_Complex.re = d + aLMA_Complex.re;
        aLMA_Complex.im = d2 + aLMA_Complex.im;
        d = Math.log(aLMA_Complex.abs());
        aLMA_Complex.re = d2 = aLMA_Complex.arg();
        aLMA_Complex.im = -d;
        return aLMA_Complex;
    }

    public ALMA_Complex acos() {
        double d = 1.0 - (this.re * this.re - this.im * this.im);
        double d2 = 0.0 - (this.re * this.im + this.im * this.re);
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(d, d2);
        ALMA_Complex.sqrt(aLMA_Complex);
        d = -aLMA_Complex.im;
        d2 = aLMA_Complex.re;
        aLMA_Complex.re = this.re + d;
        aLMA_Complex.im = this.im + d2;
        d = Math.log(aLMA_Complex.abs());
        aLMA_Complex.re = d2 = aLMA_Complex.arg();
        aLMA_Complex.im = -d;
        return aLMA_Complex;
    }

    public ALMA_Complex atan() {
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(-this.re, 1.0 - this.im);
        double d = this.re;
        double d2 = 1.0 + this.im;
        ALMA_Complex.div(aLMA_Complex, d, d2);
        d = Math.log(aLMA_Complex.abs());
        d2 = aLMA_Complex.arg();
        aLMA_Complex.re = 0.5 * d2;
        aLMA_Complex.im = -0.5 * d;
        return aLMA_Complex;
    }

    public ALMA_Complex asinh() {
        double d = this.re * this.re - this.im * this.im + 1.0;
        double d2 = this.re * this.im + this.im * this.re + 0.0;
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(d, d2);
        ALMA_Complex.sqrt(aLMA_Complex);
        aLMA_Complex.re = this.re + aLMA_Complex.re;
        aLMA_Complex.im = this.im + aLMA_Complex.im;
        d = Math.log(aLMA_Complex.abs());
        d2 = aLMA_Complex.arg();
        aLMA_Complex.re = d;
        aLMA_Complex.im = d2;
        return aLMA_Complex;
    }

    public ALMA_Complex acosh() {
        double d = this.re * this.re - this.im * this.im - 1.0;
        double d2 = this.re * this.im + this.im * this.re - 0.0;
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(d, d2);
        ALMA_Complex.sqrt(aLMA_Complex);
        aLMA_Complex.re = this.re + aLMA_Complex.re;
        aLMA_Complex.im = this.im + aLMA_Complex.im;
        d = Math.log(aLMA_Complex.abs());
        d2 = aLMA_Complex.arg();
        aLMA_Complex.re = d;
        aLMA_Complex.im = d2;
        return aLMA_Complex;
    }

    public ALMA_Complex atanh() {
        ALMA_Complex aLMA_Complex = ALMA_Complex.cart(1.0 + this.re, this.im);
        double d = 1.0 - this.re;
        double d2 = -this.im;
        ALMA_Complex.div(aLMA_Complex, d, d2);
        d = Math.log(aLMA_Complex.abs());
        d2 = aLMA_Complex.arg();
        aLMA_Complex.re = 0.5 * d;
        aLMA_Complex.im = 0.5 * d2;
        return aLMA_Complex;
    }

    public String toString() {
        if (this.im < 0.0) {
            return "(" + this.re + " - " + -this.im + "i)";
        }
        if (1.0 / this.im == Double.NEGATIVE_INFINITY) {
            return "(" + this.re + " - " + 0.0 + "i)";
        }
        return "(" + this.re + " + " + this.im + "i)";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

