#
#	wrparse.l
#
#	Scanner for wrapper descriptions
#
#	3 Dec 1990  Manchek  manchek@CS.UTK.EDU.
#

D               [0-9]
L               [a-zA-Z_]
ID		{L}({L}|{D})*
TYPE		"int"|"float"|"double"|"char"

%%

"/*"			{
				loop:
					while (input() != '*');
					switch (input()) {
					case '/': break;
					case '*': unput('*');
					default: goto loop;
					}
				}
"void"			{ return TK_VOID; }
{TYPE}			{ int i;
                          for (i = 0; i < NTYPES; i++) {
                            if (strcmp(types[i], yytext) == 0) {
                              yy_last_type = i;
                              i = NTYPES;
                            }
                          }
                          return TK_type; 
                        }

{ID}			{ strcpy(yy_last_id, yytext); return TK_id; }
"\n"			;
[ \t]+			;
.				{ return (int)(*yytext); }

%%


