#include <stdio.h>
#include "std.h"
#include "list.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

/* See rbhelp.h for a description of this file's stuff */

/*----------------------------------------------------------------------*/
/* Rb_insert_b_i_n(r, i, n):
   Rb_inserti_n(tree, i, n)
   Key:		Int 	i
   Val: 	Node	n
 */

Rb_node rb_insert_b_i_n(r, i, n)
Rb_node r;
int i;
Node n;
{
  return rb_insert_b(r, (char *) i, (char *) n);
}

Rb_node rb_inserti_n(tree, i, n)
Rb_node tree;
int i;
Node n;
{
  return rb_inserti(tree, i, (char *) n);
}



/*----------------------------------------------------------------------*/
/* Rb_insert_b_nd(r, nd)
   Rb_insert_nd(tree, nd)
   Rb_find_ndkey(tree, nd)
	Key: 	Node	nd;
	Val:	Node	nd;
    The node is treated as an integer for comparison.
 */

Rb_node rb_insert_b_nd(r, nd)
Rb_node r;
Node nd;
{
  return rb_insert_b(r, (char *) nd, (char *) nd);
}

Rb_node rb_inserti_nd(tree, nd)
Rb_node tree;
Node nd;
{
  return rb_inserti(tree, (int) nd, (char *) nd);
}

Rb_node rb_find_ndkey(tree, nd)
Rb_node tree;
Node nd;
{
  return rb_find_ikey(tree, (int) nd);
}


/*----------------------------------------------------------------------*/
/* Rb_insert_b_i_r(r, i, r2)
	Key:	Int	i;
	Val:	Rb_node	r2;
 */

Rb_node rb_insert_b_i_r(r, i, r2)
Rb_node r, r2;
int i;
{
  return rb_insert_b(r, (char *) i, (char *) r2);
}


/*----------------------------------------------------------------------*/
/* Rb_insert_b_p1(r, p)
   Rb_insert_p1(tree, p)
	Key:	Char *	p->name;
	Val:	Param	p;
   This is for lists like n->params.
 */

Rb_node rb_insert_b_p1(r, p)
Rb_node r;
Param p;
{
  return rb_insert_b(r, p->name, (char *) p);
}

Rb_node rb_insert_p1(tree, p)
Rb_node tree;
Param p;
{
  return rb_insert(tree, p->name, (char *) p);
}


/*----------------------------------------------------------------------*/
/* Rb_insert_b_p2(r, p)
	Key:	Param	p;
	Val:	Param	p;
   Comparison is by param_comp.
   This is for lists like p->a->p.
 */

Rb_node rb_insert_b_p2(r, p)
Rb_node r;
Param p;
{
  return rb_insert_b(r, (char *) p, (char *) p);
}


/* The following are dlist helpers: */

dl_insert_b_nd(d, n)
Dlist d;
Node n;
{
  dl_insert_b(d, (char *) n);
}

dl_insert_a_aa(d, aa)
Dlist d;
Array_anc aa;
{
  dl_insert_a(d, (char *) aa);
}

dl_insert_b_aa(d, aa)
Dlist d;
Array_anc aa;
{
  dl_insert_b(d, (char *) aa);
}

dl_insert_a_exp(d, e)
Dlist d;
Exp e;
{
  dl_insert_a(d, (char *) e);
}

dl_insert_b_exp(d, e)
Dlist d;
Exp e;
{
  dl_insert_b(d, (char *) e);
}

