/*
 *	HeNCE Tool
 *
 *	execute.c - Execution related stuff.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log: execute.c,v $
 * Revision 1.1  1992/04/08  05:48:42  moore
 * initial RCS version
 *
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include "xincl.h"
#include "rb.h"
#include "param.h"
#include "exp.h"				/* XXX Yuk! */
#include "graph.h"
#include "costmat.h"
#include "xcomn.h"
#include "comn.h"
#include "pvmglue.h"
#include "subproc.h"

#ifndef errno
extern int errno;				/* 4.3bsd needs this */
#endif

#ifdef index
#undef index
#endif

/*
 * XXX these shouldn't be fixed names.  Some should be temp names;
 * others should be settable from the parent window, others should
 * be X resources.
 */

#define FN_GRAPH		"hence.gr"
/* #define FN_TRACE		"hence.trace" */
/* #define FN_COSTMATRIX	"cost.mat" */

/*******************
*  from elsewhere  *
*                  *
*******************/

int stop_compose();					/* from compose.c */
void compose_refresh();				/* from compose.c */

extern char directory[1024];		/* from widmain.c */
extern char costfile[1024];			/* from widmain.c */
extern Graph scratchgraph;			/* from widmain.c */
extern struct costm *costmatrix;	/* from widmain.c */

/*
 * callback for when executioner dies
 */

static void
execute_ChildDone (pid, exitArg, ptr, howDied)
int pid;
int exitArg;
char *ptr;
enum causeOfDeath howDied;
{
	if (howDied == SUBPROC_KILLED)
		msg_Format ("\"%s\" (pid %d) was killed with signal %d.\n",
					ptr, pid, exitArg & ~0200);
	else if (exitArg == 0)
		msg_Format ("\"%s\" completed.\n", ptr);
	else
		msg_Format ("\"%s\" exited abnormally with status %d.\n",
					ptr, exitArg);

	subproc_Pclose (pid);
}

/*
 * callback for when executioner has output data
 */

static void
execute_ChildSink (fd, name)
int fd;
char *name;
{
	char buf[5120];
	int nread;
	char *ptr1, *ptr2;
	char *index ();

	if ((nread = read (fd, buf, sizeof buf - 1)) <= 0)
		return;
	buf[nread] = '\0';

	/*
	 * print out one line at a time, so we can print the child process
	 * name before the line of output.
	 */
	ptr1 = buf;
	while (ptr2 = index (ptr1, '\n')) {
		*ptr2 = '\0';
		msg_Format ("%s: %s\n", name, ptr1);
		ptr1 = ptr2 + 1;
	}
	if (ptr1 < buf + nread)
		msg_Format ("%s: %s\n", name, ptr1);
}

/*	do_execute()
 *
 *	Execute the current graph, cost matrix.
 */

do_execute()
{
	FILE *ff;
	int error_count;
	char crud[1024];
	
	/* check HeNCE graph for errors */

	if (scratchgraph == (Graph) NULL) {
		message("no graph.");
		return;
	}
	if (gr_Critic (scratchgraph) != 0) {
		message("errors in graph.");
		if (stop_mode == stop_compose) /* Yuk! */
			compose_refresh();
		return;
	}

	/* write HeNCE graph to executioner input file */

	if (!(ff = fopen(FN_GRAPH, "w"))) {
		sprintf(crud, "\"%s\": can't write HeNCE graph file", FN_GRAPH);
		message(crud);
		return;
	}
	error_count = unparse_Program (scratchgraph, ff);
	(void)fclose(ff);

	if (error_count > 0) {
		msg_Format ("%d errors in HeNCE graph.", error_count);
		if (stop_mode == stop_compose)
			compose_refresh();	/* Yuk! */
		return;
	}

	/* turn the cost matrix into graph and PVM host files */

	if (!costmatrix) {
		message("no cost matrix specified.");
		return;
	}
	if (gr_Empty (scratchgraph)) {
		msg_Format ("Graph is empty.\n");
		return;
	}
	if (cm_CheckGraph (scratchgraph, costmatrix)) {
		message("graph nodes without host mappings.");
		return;
	}

	if (*costfile == '\0') {
		msg_Format ("No cost file specified in config.\n");
		return;
	}

	if (cm_WriteFile (costfile, costmatrix)) {
		sprintf(crud, "\"%s\": can't write cost matrix", costfile);
		message(crud);
		return;
	}

#if 1
	if (pvm_IsRunning ()) {
		/*
		 * XXX need to check to make sure hosts are registered
		 * with this pvmd
		 */
		msg_Format ("using existing pvm...\n");
		msg_Format ("(if you've added/deleted hosts you need to kill pvm and restart)\n");
	}
	else {
		/*
		 * build a "temporary" pvm hosts file, containing only those
		 * hosts necessary to run this HeNCE program, from the master
		 * pvm hosts file.
		 *
		 * XXX need to delete the temporary pvm hosts file after pvm has
		 * exited.
		 */
		char tmpPvmHostFile[255];
		FILE *srcfp, *dstfp;

		if ((srcfp = fopen (pvmHostFile, "r")) == NULL) {
			msg_Format ("warning: can't open %s (%s)\n", pvmHostFile,
						strerror (errno));
			srcfp = fopen ("/dev/null", "r");
		}
		strcpy (tmpPvmHostFile, "/tmp/htoolXXXXXX");
		mktemp (tmpPvmHostFile);
		strcat (tmpPvmHostFile, ".p");

		unlink (tmpPvmHostFile);
		if ((dstfp = fopen (tmpPvmHostFile, "w")) == NULL) {
			msg_Format ("Can't create temp pvm host file %s (%s)\n",
						tmpPvmHostFile, strerror (errno));
		}
		if (cm_BuildPvmHostFile (srcfp, dstfp, costmatrix) < 0) {
			fclose (srcfp);
			fclose (dstfp);
			unlink (tmpPvmHostFile);
			return;
		}
		fclose (srcfp);
		fclose (dstfp);

		msg_Format ("starting up pvm...\n");
		if (pvm_Start (tmpPvmHostFile) < 0)
			return;
		/* XXX need to wait until pvm is up and running ... */
	}

	sprintf (crud, "exec master %s -tf %s -cm %s",
			 FN_GRAPH, traceFileName, costfile);
	if (subproc_Popen (crud, execute_ChildDone, execute_ChildDone,
					   execute_ChildSink, "master") < 0) {
		msg_Format ("couldn't run the HeNCE executioner\n");
		return;
	}
	msg_Format ("running HeNCE executioner...\n");
	return;
#else
	/* XXX instead of writing pvm hosts file, feed pvm a hosts file
	 * supplied by the user, and make sure (perhaps by asking pvm?)
	 * that all of the required hosts are there
	 */

	if (cm_MakePvmHostFile (costmatrix, pvmHostFile)) {
		sprintf(crud, "\"%s\": can't write PVM host file", pvmHostFile);
		message(crud);
		return;
	}


	if (pvm_IsRunning ()) {
		/*
		 * XXX need to check to make sure hosts are registered
		 * with this pvmd
		 */
		msg_Format ("using existing pvm...\n");
		msg_Format ("(if you've added/deleted hosts you need to kill pvm and restart)\n");
	}
	else {
		msg_Format ("starting up pvm...\n");
		if (pvm_Start (pvmHostFile) < 0)
			return;
		/* XXXX wait until pvm is up and running ... */
		/*
		 * XXX need to check to make sure hosts are registered
		 * with this pvmd
		 */
	}

	sprintf (crud, "exec master %s -tf %s -cm %s",
			 FN_GRAPH, traceFileName, costfile);
	if (subproc_Popen (crud, execute_ChildDone, execute_ChildDone,
					   execute_ChildSink, "master") < 0) {
		msg_Format ("couldn't run the HeNCE executioner\n");
		return;
	}
	msg_Format ("running HeNCE executioner...\n");
	return;
#endif

#if 0
	message("starting up pvm...");
	sprintf(crud,
		"xterm -title 'HeNCE - PVM console' -e %s -i %s &",
		pvmdExecPath, pvmHostFile);
	if (system(crud) < 0) {
		msg_Format ("Error running \"%s\" - execution failed\n", pvmdExecPath);
		return;
	}

	/* XXX this needs to ask pvmd whether pvm is started or not... */

	if (!verify("is pvm started?  :-)")) {
		message("running executioner...");
		sprintf(crud, "master %s -tf %s -cm %s &",
				FN_GRAPH,
				traceFileName,
				costfile);
		system(crud);
	} else
		message("bailed on execution.");
#endif
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
