/*
 * File Select widget
 *
 * XXX need label on selection box
 *
 * XXX get rid of some of the bogus (internal) translations on text widgets
 *
 * XXX make file list use a resizable array.  (but when to free it?)
 * perhaps it should ask the text widget to add another entry, nuke
 * its own buffer, etc.
 *
 * XXX have text widgets use "in place" strings everywhere.
 */


#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#if defined(IMA_SYMM) || defined(IMA_RT) || defined(IMA_NEXT)
#include <sys/dir.h>
#define DIRECTORY struct direct
#else
#include <dirent.h>
#define DIRECTORY struct dirent
#endif
#include <errno.h>
#include <sys/stat.h>
#ifdef IMA_SYMM
#include <strings.h>
#else
#include <string.h>
#endif
/*
 * FIX for brain-damage induced by IBM and others who insist on
 * using #define to alias index to strchr, etc.
 */
#ifdef rindex
#undef rindex
#endif
#ifdef index
#undef index
#endif
#ifdef strchr
#undef strchr
#endif
#ifdef strrchr
#undef strrchr
#endif

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiTextP.h>
#include "FileSelectP.h"
#include "regexp.h"
#include "tilde.h"

#ifndef R_OK				/* get *_OK constants for access call */
#ifdef IMA_PMAX
#include <unistd.h>
#else
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define F_OK 0
#endif /*IMA_PMAX*/
#endif /*R_OK*/


#ifdef MAX
#undef MAX
#endif
#ifdef MIN
#undef MIN
#endif
#define MAX(a,b) (((int)(a) > (int)(b)) ? (a) : (b))
#define MIN(a,b) (((int)(a) < (int)(b)) ? (a) : (b))

/*
 * some systems don't define the S_ISxxx macros, while others
 * (POSIX compliant) define ONLY these macros.  This code is
 * supposed to define the macros if they are missing.
 * Some systems don't support FIFOs, SOCKETs, or SYMLINKs, so
 * we define a dummy S_ISxxx macro for these which is always false.
 */

#ifndef S_ISBLK
#define S_ISBLK(m) (((m) & S_IFMT) == S_IFBLK)
#endif

#ifndef S_ISCHR
#define S_ISCHR(m) (((m) & S_IFMT) == S_IFCHR)
#endif

#ifndef S_ISDIR
#define S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)
#endif

#ifndef S_ISFIFO
#ifdef S_IFIFO
#define S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#else
#define S_ISFIFO(m) 0			/* never true */
#endif
#endif

#ifndef S_ISLNK
#ifdef S_IFLNK
#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#else
#define S_ISLNK(m) 0			/* never true */
#endif
#endif

#ifndef S_ISREG
#define S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif

#ifndef S_ISSOCK
#ifdef S_IFSOCK
#define S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)
#else
#define S_ISSOCK(m) 0			/* never true */
#endif
#endif

#ifndef errno
extern int errno;				/* 4.3bsd needs this */
#endif

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */


static Dimension wideDim = 200;
static Dimension highDim = 300;
static Dimension padDim = 10;

#define offset(field) XtOffset(FileselectWidget, field)
static XtResource resources[] = {
	{ XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
		  offset(core.width), XtRDimension, (caddr_t)&wideDim },
	{ XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
		  offset(core.height), XtRDimension, (caddr_t)&highDim },
	{ XtNdir,  XtCDir, XtRString, sizeof(String),
		 offset(fileselect.directory), XtRString, NULL },
	{ XtNselection,	 XtCSelection, XtRString, sizeof(String),
		 offset(fileselect.selection), XtRString, NULL },
	{ XtNfilter,  XtCFilter, XtRString, sizeof(String),
		 offset(fileselect.filter), XtRString, NULL },
	{ XtNlabel1,  XtCLabel1, XtRString, sizeof(String),
		 offset(fileselect.label1), XtRString, NULL },
	{ XtNlabel2,  XtCLabel2, XtRString, sizeof(String),
		 offset(fileselect.label2), XtRString, NULL },
	{ XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
		 offset(fileselect.foreground), XtRString, "XtDefaultForeground"},
	{ XtNfont,	XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		 offset(fileselect.font),XtRString, "XtDefaultFont"},
	{ XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),
		 offset(fileselect.callbacks), XtRCallback, (XtPointer) NULL },
	{ XtNpad, XtCPad, XtRDimension, sizeof(Dimension),
		  offset(fileselect.pad), XtRDimension, (caddr_t)&padDim },
	{ XtNflags, XtCFlags, XtRInt, sizeof(int),
		  offset(fileselect.searchFlags), XtRInt, (XtPointer) NULL },
};


static void Initialize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
static void Destroy();

static XtGeometryResult GeometryManager();

static void new_filter();
static void do_fileselect();
static void set_select();

static XtActionsRec actions[] =
{
	{ "new_filter",		new_filter },
	{ "do_fileselect",	do_fileselect },
	{ "set_select",		set_select },
};


FileselectClassRec fileselectClassRec = {
	{
		/* core_class fields */ 
		(WidgetClass) &compositeClassRec, /* superclass */
		"Fileselect",			/* class_name			*/
		sizeof(FileselectRec),	/* widget_size			*/
		ClassInitialize,		/* class_initialize		*/
		NULL,					/* class_part_initialize*/
		FALSE,					/* class_inited			*/
		Initialize,				/* initialize			*/
		NULL,					/* initialize_hook		*/
		XtInheritRealize,		/* realize				*/
		actions,				/* actions				*/
		XtNumber(actions),		/* num_actions			*/
		resources,				/* resources			*/
		XtNumber(resources),	/* num_resources		*/
		NULLQUARK,				/* xrm_class			*/
		TRUE,					/* compress_motion		*/
		TRUE,					/* compress_exposure	*/
		TRUE,					/* compress_enterleave	*/
		FALSE,					/* visible_interest		*/
		Destroy,				/* destroy				*/
		Resize,					/* resize				*/
		Redisplay,				/* expose				*/
		SetValues,				/* set_values			*/
		NULL,					/* set_values_hook		*/
		XtInheritSetValuesAlmost, /* set_values_almost	*/
		NULL,					/* get_values_hook		*/
		NULL,					/* accept_focus			*/
		XtVersion,				/* version				*/
		NULL,					/* callback_private		*/
		NULL,					/* tm_table				*/
		XtInheritQueryGeometry, /* query_geometry		*/
		XtInheritDisplayAccelerator, /* display_accelerator		*/
		NULL,					/* extension			*/
	},{
		/* composite_class fields */
		GeometryManager,		/* geometry_manager		*/
		XtInheritChangeManaged,			/* change_managed		*/
		XtInheritInsertChild,	/* insert_child			*/
		XtInheritDeleteChild,	/* delete_child			*/
		NULL,					/* extension			*/
	},{
		/* fileselect class fields */
		0,						/* empty				*/
	}
};

WidgetClass fileselectWidgetClass = (WidgetClass)&fileselectClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static XtGeometryResult
GeometryManager (child, request, reply)
	Widget child;
	XtWidgetGeometry *request, *reply;
{
	FileselectWidget w = (FileselectWidget)XtParent(((child)));

	return (XtGeometryNo);
}


static void
ClassInitialize ()
{
	extern void XmuCvtStringToJustify();
	extern void XmuCvtStringToBitmap();
	static XtConvertArgRec screenConvertArg[] = {
		{ XtWidgetBaseOffset, (caddr_t) XtOffset(Widget, core.screen),
			  sizeof(Screen *) }
	};
	XawInitializeWidgetSet ();
	XtAddConverter ( XtRString, XtRJustify, XmuCvtStringToJustify, NULL, 0 );
	XtAddConverter ("String", "Bitmap", XmuCvtStringToBitmap,
					screenConvertArg, XtNumber(screenConvertArg));
} /* ClassInitialize */

static void
GetnormalGC (lw)
FileselectWidget lw;
{
	XGCValues	values;

	values.foreground	= lw->fileselect.foreground;
	values.background	= lw->core.background_pixel;
	values.font			= lw->fileselect.font->fid;

	lw->fileselect.normal_GC =
		XtGetGC((Widget)lw,
				(unsigned) GCForeground | GCBackground | GCFont,
				&values);
}

static void
GetgrayGC(lw)
FileselectWidget lw;
{
	XGCValues	values;

	values.foreground = lw->fileselect.foreground;
	values.background = lw->core.background_pixel;
	values.font		  = lw->fileselect.font->fid;
	values.fill_style = FillTiled;
	values.tile		  = XmuCreateStippledPixmap(XtScreen((Widget)lw),
												lw->fileselect.foreground, 
												lw->core.background_pixel,
												lw->core.depth);

	lw->fileselect.stipple = values.tile;
	lw->fileselect.gray_GC = XtGetGC((Widget)lw, 
									 (unsigned) GCForeground | GCBackground |
									 GCFont | GCTile | GCFillStyle,
									 &values);
}

/*
 * see if file name is valid given the flags supplied
 */

static int
match_flags (flags, name)
int flags;
char *name;
{
	struct stat buf;

	if (flags == 0)
		return 1;

#ifndef S_IFLNK
#define lstat stat				/* lstat exists if S_IFLNK is defined */
#endif

	if (flags & FS_NoticeSymlinks) {
		if (lstat (name, &buf) < 0)
			return 0;
	}
	else {
		if (stat (name, &buf) < 0)
			return 0;
	}

	if (S_ISREG (buf.st_mode))
		return (flags & FS_RegularFile) != 0;
	else if (S_ISDIR (buf.st_mode))
		return (flags & FS_Directory) != 0;
	else if (S_ISBLK (buf.st_mode))
		return (flags & FS_BlockSpecial) != 0;
	else if (S_ISCHR (buf.st_mode))
		return (flags & FS_CharSpecial) != 0;
	else if (S_ISSOCK (buf.st_mode))
		return (flags & FS_Socket) != 0;
	else if (S_ISFIFO (buf.st_mode))
		return (flags & FS_FIFO) != 0;
	else if (S_ISLNK (buf.st_mode))
		return (flags & FS_Symlink) != 0;
	else
		return (flags & FS_Other) != 0;
}


/*
 * if the filename portion of the "selection" appears in the "list of files"
 * window, and the directory portion matches the directory resource, 
 * select that filename.
 */

void
set_selection (w)
FileselectWidget w;
{
	if (w->fileselect.selection != NULL) {
		XawTextPosition pos;
		char *basename, *dirname;
		char *ptr;
		char *rindex ();
			
		dirname = XtNewString (w->fileselect.selection);
		ptr = rindex (w->fileselect.selection, '/');
		if (ptr == NULL) {
			basename = dirname;
			dirname = XtNewString (".");
		}
		else {
			*ptr++ = '\0';	/* truncate dirname to nuke last component */
			basename = XtNewString (ptr);
		}
		
		ptr = w->fileselect.directory ? w->fileselect.directory : ".";
		if (strcmp (ptr, dirname) == 0) {
			XawTextBlock foo;

			foo.firstPos = 0;
			foo.ptr = basename;
			foo.length = strlen (basename);
			foo.format = FMT8BIT;
			XawTextSetInsertionPoint (w->fileselect.selectText, 0);
			if ((pos = XawTextSearch (w->fileselect.selectText, XawsdRight,
									  &foo)) != XawTextSearchError) {
#if 0
				fprintf (stderr, "\"%s\" found\n", basename);
#endif
				XawTextSetInsertionPoint (w->fileselect.selectText, pos);
				XawTextSetSelection (w->fileselect.selectText, pos,
								 pos + foo.length);
			}
		}
		XtFree (basename);
		XtFree (dirname);
	}

}


/*
 * callback passed to qsort() for sorting filenames within a directory.
 *
 * XXX should this do case-insensitive string compare?
 */

static int
compareStrings (a, b)
char **a, **b;
{
	return (strcmp (*a, *b));
}


/*
 * get a new list of files.  called initially, and whenever the filter
 * or dir changes.
 *
 * XXX the returned string is in heap space.  we need to free this
 * after it is passed to the fileselect widget.  Either that or enable
 * the "in place" stuff.
 */

String
get_new_filter_val (w)
FileselectWidget w;
{
	DIRECTORY *dirent;
	String filter, dir;
	DIR *dp = NULL;
	regexp *re = NULL;
	regexp *compile_filter ();
	char *src, *dst;
	char *strerror ();
	char filename[1024];		/* buffer for temp file name */
	char *fptr;
	char *fileNameBuf= NULL;	/* malloc'ed buffer for file names */
	int fileNameBufSize = 0;	/* current size of malloc'ed buffer */
	char **fileListPtrs = NULL;
	int numFiles;				/* number of files in fileListPtrs */
	int maxFiles;				/* number of slots */
	int length;
	int i;

	XtVaGetValues (w->fileselect.filterText, XtNstring, &filter, NULL);
	XtVaGetValues (w->fileselect.dirText, XtNstring, &dir, NULL);

	strcpy (w->fileselect.dir, dir);

	if ((re = compile_filter (filter)) == NULL) {
		fprintf (stderr, "%s: regexp error\n", filter);
		goto abort;
	}

	/*
	 * open directory and build directory portion of filename buffer
	 */
	if (*dir == '\0')			/* fix for SysV brain-damage */
		dir = ".";

	if ((dp = (DIR *) topendir (dir)) == NULL) {
#if 0
		fprintf (stderr, "%s: %s\n", dir, strerror (errno));
#endif
		goto abort;
	}
	strcpy (filename, texpand (dir));
	fptr = filename + strlen (filename);
	*fptr++ = '/';

	/*
	 * collect file names from directory
	 */

	numFiles = 0;
	maxFiles = 256;
	fileListPtrs = (char **) malloc (maxFiles * sizeof (char *));
	fileNameBufSize = 0;

	errno = 0;
	while ((dirent = readdir (dp)) != NULL) {

		if (match_filter (re, dirent->d_name) == 0)
			continue;

#define BITS (FS_FileTypeBits | FS_NoticeSymlinks)

		strcpy (fptr, dirent->d_name); /* build full filename first! */
		if (match_flags (w->fileselect.searchFlags & BITS, filename) == 0)
			continue;

		/* add file to list */
		if (numFiles >= maxFiles) {
			maxFiles *= 2;
			fileListPtrs = (char **) realloc (fileListPtrs,
											  maxFiles * sizeof(char *));
			if (fileListPtrs == NULL) {
				fprintf (stderr, "realloc() failed\n");
				goto abort;
			}
		}
		length = strlen (dirent->d_name);
		dst = (char *) malloc (length + 1);
		strcpy (dst, dirent->d_name);
		fileNameBufSize += length + 1; /* add room for extra '\n' */
		fileListPtrs[numFiles++] = (char *) strsave (dirent->d_name);
		errno = 0;
	}
	if (errno != 0) {
		fprintf (stderr, "%s: readdir(): %s\n", dir, strerror (errno));
		goto abort;
	}
	closedir (dp);
	free (re);

	/* now sort file names */
	qsort (fileListPtrs, numFiles, sizeof (char *), compareStrings);

	fileNameBuf = (char *) malloc (fileNameBufSize + 2); /* room for '\0' at end */
	dst = fileNameBuf;

	for (i = 0; i < numFiles; ++i) {
		src = fileListPtrs[i];
		while (*src)
			*dst++ = *src++;
		*dst++ = '\n';
	}
	*dst++ = '\0';
	if (dst - fileNameBuf > fileNameBufSize + 2) {
		fprintf (stderr, "bug: %d > fileNameBufSize + 2 (%d)\n",
				 dst - fileNameBuf, fileNameBufSize + 2);
		goto abort;
	}

	for (i = 0; i < numFiles; ++i)
		free (fileListPtrs[i]);
	free (fileListPtrs);

	return fileNameBuf;

 abort:
	if (dp)
		closedir (dp);
	if (re)
		free (re);
	if (fileListPtrs) {
		for (i = 0; i < numFiles; ++i)
			free (fileListPtrs[i]);
		free (fileListPtrs);
	}
	if (fileNameBuf)
		free (fileNameBuf);
	return "";
}

int
xtw (w, s)
FileselectWidget w;
String s;
{
	return (XTextWidth (w->fileselect.font, s, strlen (s)));
}

static void
set_select (w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	String currentVal;
	XawTextPosition begin, end;
	char bigbuf[1024];
	char *src, *dst, *endbuf;
	FileselectWidget fw = (FileselectWidget) XtParent(w);


	XtVaGetValues (fw->fileselect.dirText,
				   XtNstring, &currentVal,
				   NULL);


	dst = &bigbuf[0];
	endbuf = &bigbuf[0] + sizeof(bigbuf) - 2;
	src = currentVal;
	if (*src) {
		while (*src) {
			if (dst < endbuf)
				*dst++ = *src;
			++src;
		}
		if (dst[-1] != '/')
			*dst++ = '/';
	}
	
	XawTextGetSelectionPos (fw->fileselect.selectText, &begin, &end);
	XtVaGetValues (fw->fileselect.selectText,
				   XtNstring, &currentVal,
				   NULL);

	src = currentVal + begin;
	while (src < currentVal + end) {
		if (dst < endbuf)
			*dst++ = *src;
		++src;
	}
	*dst = '\0';

	XtVaSetValues (fw->fileselect.currSelectText,
				   XtNstring, bigbuf,
				   NULL);
}

static void
cancel_fileselect(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FileselectWidget parent = (FileselectWidget) XtParent (w);
	/* Widget parent_popup = XtParent(XtParent(w)); */

	XtCallCallbackList ((Widget) parent, parent->fileselect.callbacks,
						(XtPointer) 1);
	/* XtDestroyWidget( parent_popup ); */
}

static char *
check_file_flags (flags, name)
int flags;
char *name;
{
	static char msgbuf[1100];

	if (flags & FS_MustBeReadable) {
		if (eaccess (name, R_OK) < 0)
			return "File %s is not readable";
	}
	if (flags & FS_MustBeExecutable) {
		if (eaccess (name, X_OK) < 0)
			return "File %s is not executable";
	}
	if (flags & FS_MustBeWritable) {
		if (eaccess (name, F_OK) == 0) {
			if (eaccess (name, W_OK) == 0)
				;				/* file exists and is writable */
			else
				return "File %s is read-only";
		}
		else {
			char dirname[1024];
			char *rindex ();
			char *ptr;

			strcpy (dirname, name);
			ptr = rindex (dirname, '/');
			if (ptr)
				*ptr = '\0';
			else
				strcpy (dirname, ".");

			if (eaccess (dirname, F_OK) == 0) {
				if (eaccess (dirname, W_OK) == 0)
					;			/* directory exists and is writable */
				else
					return "File %s does not exist and directory is read-only";
			}
			else {
				sprintf (msgbuf, "%s: No such directory", dirname);
				return msgbuf;
			}
		}
	}
	if (flags & FS_MustExist) {
		if (eaccess (name, F_OK) < 0)
			return "File %s does not exist.";
	}
	return NULL;
}

static void
do_fileselect (w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	String currentVal;
	FileselectWidget fw = (FileselectWidget) XtParent(w);
	char buf[1025];				/* XXX should be MAXPATHNAME or some such */
	char *ptr;
	char *index ();

	XtVaGetValues (fw->fileselect.currSelectText,
				   XtNstring, &currentVal,
				   NULL);

	if (*currentVal == '\n')
		++currentVal;
	strcpy (buf, currentVal);

	if (*buf == '\0' || *buf == '\n') /* don't select empty text */
		return;

	if (ptr = index (buf, '\n'))
		*ptr = '\0';

	ptr = check_file_flags (fw->fileselect.searchFlags, texpand(buf));
	if (ptr) {
		char buf2[2000];
		sprintf (buf2, ptr, buf);
		XtVaSetValues ((Widget) fw, XtNlabel2, buf2, NULL);
		return;
	}
	else
		XtVaSetValues ((Widget) fw, XtNlabel2, "", NULL);

	fw->fileselect.selection = XtNewString (buf);

	XtCallCallbackList ((Widget) fw, fw->fileselect.callbacks, (XtPointer) 0);
}

static void
new_filter (w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FileselectWidget fw = (FileselectWidget) XtParent(w);
	char *ptr = get_new_filter_val (fw);

	XtVaSetValues (fw->fileselect.selectText,
				   XtNstring, ptr,
				   NULL);
	if (*ptr == '\0')
		XtVaSetValues ((Widget) fw, XtNlabel2, "no matching files", NULL);
	else
		XtVaSetValues ((Widget) fw, XtNlabel2, "", NULL);
}

/* ARGSUSED */
static void 
Initialize (request, new)
Widget request, new;
{
	FileselectWidget w = (FileselectWidget) new;
	Arg args[20];
	register int n;
	int pad = w->fileselect.pad;
	int y_off;
	XtTranslations translations;
	char *filterLabelMsg;
	int filterLabelMsgWidth;
	char *dirLabelMsg;
	int dirLabelMsgWidth;
	char *currFileLabelMsg;
	int currFileLabelMsgWidth;

	static XawTextSelectType defaultSelectTypes[] = {
		XawselectWord, XawselectNull,
	};
	static char filter_translations[] = "<Key>Return: new_filter()";
	static char curr_select_translations[] = "<Key>Return: do_fileselect()";
	static char select_translations[] = "\
<BtnDown>: select-start()beginning-of-line()select-start()end-of-line()\
select-end(PRIMARY,CUTBUFFER0)set_select()\n\
<BtnDown>(2): do_fileselect() ";

	/*
	 * XXX currently this is replicated in Resize().  Would be
	 * better to make this part of the widget state and only compute
	 * it once.  Better yet, we should make these labels resources.
	 */

	if (w->fileselect.searchFlags & FS_Directory) {
		dirLabelMsg = "sub-directories of:";
		filterLabelMsg = "matching (pattern):";
		currFileLabelMsg = "directory:";
	}
	else {
		dirLabelMsg = "files in directory:";
		filterLabelMsg = "matching (pattern):";
		currFileLabelMsg = "filename:";
	}
	dirLabelMsgWidth = xtw (w, dirLabelMsg);
	filterLabelMsgWidth = xtw (w, filterLabelMsg);
	currFileLabelMsgWidth = xtw (w, currFileLabelMsg);

	if (w->fileselect.label1 == NULL)
		w->fileselect.label1 = XtNewString (w->core.name);
	else
		w->fileselect.label1 = XtNewString (w->fileselect.label1);

	if (w->fileselect.label2 == NULL)
		w->fileselect.label2 = XtNewString (" ");
	else
		w->fileselect.label2 = XtNewString (w->fileselect.label2);

	GetnormalGC (w);
	GetgrayGC (w);

	w->fileselect.text_height = 
		(w->fileselect.font)->max_bounds.ascent 
			+ (w->fileselect.font)->max_bounds.descent + 4;

	/*
	 * row 1: legend at top, centered
	 */
	n = 0;
	XtSetArg (args[n], XtNx,
			  MAX(10, (w->core.width/2) - (xtw (w,w->fileselect.label1)/2)));
																n++;
	XtSetArg (args[n], XtNy, pad);								n++;
	XtSetArg (args[n], XtNborderWidth, (XtPointer) 0);			n++;
	XtSetArg (args[n], XtNlabel, w->fileselect.label1);			n++;
	w->fileselect.nameLabel1 =
		XtCreateManagedWidget("nameLabel1", labelWidgetClass,
							  (Widget) w, args, n);

	y_off = pad + w->fileselect.text_height + pad;

	/*
	 * row 2: "files from directory : [      ]
	 */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNborderWidth, (XtPointer) 0);			n++;
	XtSetArg (args[n], XtNlabel, dirLabelMsg);					n++;
	w->fileselect.dirLabel =
		XtCreateManagedWidget("dirLabel", labelWidgetClass,
							  (Widget) w, args, n);

	n = 0;
	XtSetArg (args[n], XtNresize, XawtextResizeWidth); n++;
	XtSetArg (args[n], XtNx, dirLabelMsgWidth + 2*pad);		n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNwidth,
			 MAX(10, w->core.width - 3*pad - dirLabelMsgWidth));
																n++;
	XtSetArg (args[n], XtNheight, w->fileselect.text_height + 5);
																n++;
	XtSetArg (args[n], XtNeditType, "edit");					n++;
	XtSetArg (args[n], XtNstring, w->fileselect.directory);		n++;
	w->fileselect.dirText =
		XtCreateManagedWidget ("dirText", asciiTextWidgetClass,
							   (Widget) w, args, n);

	translations = XtParseTranslationTable (filter_translations);
	XtOverrideTranslations (w->fileselect.dirText, translations);

	y_off += w->fileselect.text_height + pad;

	/*
	 * row 3: "matching: [       ]
	 */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNborderWidth, (XtPointer) 0);			n++;
	XtSetArg (args[n], XtNlabel, filterLabelMsg);				n++;
	w->fileselect.filterLabel =
		XtCreateManagedWidget("filterLabel", labelWidgetClass,
							  (Widget) w, args, n);

	n = 0;
	XtSetArg (args[n], XtNx, filterLabelMsgWidth + 2*pad);		n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNresize, XawtextResizeWidth);			n++;
	XtSetArg (args[n], XtNwidth,
			  MAX (10, w->core.width - 3*pad - filterLabelMsgWidth));
																n++; 
	XtSetArg (args[n], XtNheight, w->fileselect.text_height + 5);
																n++; 
	XtSetArg (args[n], XtNeditType, "edit");					n++; 
	XtSetArg (args[n], XtNstring, w->fileselect.filter);		n++; 
	w->fileselect.filterText =
		XtCreateManagedWidget("filterText", asciiTextWidgetClass,
							  (Widget) w, args, n);

	translations = XtParseTranslationTable (filter_translations);
	XtOverrideTranslations (w->fileselect.filterText, translations);

	y_off += w->fileselect.text_height + pad;

	/*
	 * row 4: list of files to select from
	 */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNheight,
			 MAX (10, w->core.height - 8*pad - 6*w->fileselect.text_height));
																n++;
	XtSetArg (args[n], XtNwidth, MAX(10, w->core.width - 2*pad));n++;
	XtSetArg (args[n], XtNscrollVertical, XawtextScrollAlways); n++;
	XtSetArg (args[n], XtNeditType, XawtextRead);				n++;
	XtSetArg (args[n], XtNstring, get_new_filter_val (w));		n++; 
	XtSetArg (args[n], XtNselectTypes, defaultSelectTypes);		 n++;
	w->fileselect.selectText =
		XtCreateManagedWidget ("selectText", asciiTextWidgetClass,
							   (Widget) w, args, n);

	translations = XtParseTranslationTable (select_translations);
	XtOverrideTranslations (w->fileselect.selectText, translations);

	y_off += w->core.height - 8*pad - 6*w->fileselect.text_height + pad;

	/*
	 * row 5: filename: [      ]
	 */

#ifdef SELECTLABEL
#define XtVaCMW XtVaCreateManagedWidget

	w->fileselect.selectLabel =
		XtVaCMW ("selectLabel", labelWidgetClass, (Widget) w,
				 XtNx, pad,
				 XtNy, y_off,
				 XtNborderWidth, (XtPointer) 0,
				 XtNlabel, currFileLabelMsg,
				 NULL);
	w->fileselect.currSelectText =
		XtVaCMW ("currSelectText", asciiTextWidgetClass, (Widget) w,
				 XtNx, currFileLabelMsgWidth + 2*pad,
				 XtNy, y_off,
				 XtNwidth, MAX (10,
								w->core.width - 3*pad - currFileLabelMsgWidth),
				 XtNeditType, "edit",
				 XtNstring, w->fileselect.selection,
				 NULL);
#else /* SELECTLABEL */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNwidth,
			 MAX (10, w->core.width - 2*pad));					n++;
	XtSetArg (args[n], XtNeditType, "edit");					n++;
	XtSetArg (args[n], XtNstring, w->fileselect.selection);		n++;
	w->fileselect.currSelectText =
		XtCreateManagedWidget ("currSelectText", asciiTextWidgetClass, w,
							   args, n);
#endif /* SELECTLABEL */
		
	translations = XtParseTranslationTable (curr_select_translations);
	XtOverrideTranslations (w->fileselect.currSelectText, translations);

	y_off += w->fileselect.text_height + pad;

	/*
	 * row 6: label for error messages
	 */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNborderWidth, (XtPointer) 0);			n++;
	XtSetArg (args[n], XtNwidth, w->core.width - 2*pad);		n++;
	XtSetArg (args[n], XtNlabel, w->fileselect.label2);			n++;
	w->fileselect.nameLabel2 =
		XtCreateManagedWidget ("nameLabel2", labelWidgetClass,
							   (Widget) w, args, n);


	y_off += w->fileselect.text_height + pad;

	/*
	 * row 7: "ok" and "cancel" buttons
	 */

	n = 0;
	XtSetArg (args[n], XtNx, pad);								n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNlabel, "ok");						    n++;
	w->fileselect.okButton =
		XtCreateManagedWidget ("okButton", commandWidgetClass,
							   (Widget) w, args, n);

	XtAddCallback (w->fileselect.okButton, XtNcallback, 
				   (XtCallbackProc) do_fileselect, (XtPointer)NULL);

	n = 0;
	XtSetArg (args[n], XtNx, xtw (w, "	select	") + 2*pad);	n++;
	XtSetArg (args[n], XtNy, y_off);							n++;
	XtSetArg (args[n], XtNlabel, "cancel");						n++;
	w->fileselect.cancelButton =
		XtCreateManagedWidget ("cancelButton", commandWidgetClass,
							   (Widget) w, args, n);

	XtAddCallback (w->fileselect.cancelButton, XtNcallback, 
				   (XtCallbackProc) cancel_fileselect, (XtPointer)NULL);

} /* Initialize */


/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void 
Redisplay (w, event, region)
Widget w;
XEvent *event;
Region region;
{
	FileselectWidget lw = (FileselectWidget) w;
}


static void 
Resize (w)
FileselectWidget w;
{
	Arg args[20];
	register int n;
	int pad = w->fileselect.pad;
	int y_off;
	String name1 = w->fileselect.label1;
	String name2 = w->fileselect.label2;
	Dimension high;
	char *filterLabelMsg;
	int filterLabelMsgWidth;
	char *dirLabelMsg;
	int dirLabelMsgWidth;
	char *currFileLabelMsg;
	int currFileLabelMsgWidth;

	/*
	 * XXX currently this is replicated in Initialize().  Would be
	 * better to make this part of the widget state and only compute
	 * it once.  Better yet, we should make these labels resources.
	 */
	if (w->fileselect.searchFlags & FS_Directory) {
		dirLabelMsg = "sub-directories of:";
		filterLabelMsg = "matching (pattern):";
		currFileLabelMsg = "directory:";
	}
	else {
		dirLabelMsg = "files in directory:";
		filterLabelMsg = "matching (pattern):";
		currFileLabelMsg = "filename:";
	}
	dirLabelMsgWidth = xtw (w, dirLabelMsg);
	filterLabelMsgWidth = xtw (w, filterLabelMsg);
	currFileLabelMsgWidth = xtw (w, currFileLabelMsg);

	/*
	 * row 1.  title at top, centered
	 */
	XtMoveWidget (w->fileselect.nameLabel1,
				  (w->core.width - xtw (w, name1)) / 2, pad);

	y_off = pad + w->fileselect.text_height + pad;

	/* row 2. dir label and text widget */

	XtMoveWidget (w->fileselect.dirLabel, pad, y_off);

	n = 0;
	XtSetArg (args[n], XtNheight, &high);						n++;
	XtGetValues(w->fileselect.dirText, args, n);

	XtMoveWidget (w->fileselect.dirText, dirLabelMsgWidth + 2*pad, y_off);
	XtResizeWidget (w->fileselect.dirText,
					MAX (10, (w->core.width - 3*pad - dirLabelMsgWidth)),
					high, 1);

	y_off += w->fileselect.text_height + pad;

	/* row 3. filter label and text widget */

	XtMoveWidget (w->fileselect.filterLabel, pad, y_off);

	n = 0;
	XtSetArg (args[n], XtNheight, &high);						n++;
	XtGetValues (w->fileselect.filterText, args, n);

	XtMoveWidget (w->fileselect.filterText, filterLabelMsgWidth + 2*pad, y_off);
	XtResizeWidget (w->fileselect.filterText,
					MAX (10, (w->core.width - 3*pad - filterLabelMsgWidth)),
					high, 1);

	y_off += w->fileselect.text_height + pad;

	/* row 4. list of files text widget */

	XtMoveWidget (w->fileselect.selectText, pad, y_off);
	XtResizeWidget (w->fileselect.selectText,
					MAX (10, w->core.width - 2*pad), 
					MAX (10,
						 w->core.height - 8*pad - 6*w->fileselect.text_height),
					1);

	y_off += w->core.height - 8*pad - 6*w->fileselect.text_height + pad;

	/* row 5. currently selected file and label */

	n = 0;
	XtSetArg (args[n], XtNheight, &high);	  n++;
	XtGetValues (w->fileselect.currSelectText, args, n);

#ifdef SELECTLABEL
	XtMoveWidget (w->fileselect.selectLabel, pad, y_off);
	XtMoveWidget (w->fileselect.currSelectText,
				  currFileLabelMsgWidth + 2*pad, y_off);
	XtResizeWidget (w->fileselect.currSelectText,
					MAX (10, w->core.width - 3*pad - currFileLabelMsgWidth),
					high, 1);
#else
	XtMoveWidget (w->fileselect.currSelectText, pad, y_off);
	XtResizeWidget (w->fileselect.currSelectText, 
					MAX (10, w->core.width - 2*pad),
					high, 1);
#endif

	y_off += w->fileselect.text_height + pad;

	/* row 6.  error msg label */

	n = 0;
	XtSetArg (args[n], XtNheight, &high);	  n++;
	XtGetValues (w->fileselect.nameLabel2, args, n);

/*	XtMoveWidget (w->fileselect.nameLabel2,
				  (w->core.width - xtw (w, name2)) / 2, y_off); */
	XtMoveWidget (w->fileselect.nameLabel2, pad, y_off);
	XtResizeWidget (w->fileselect.nameLabel2,
					w->core.width - 2 * pad, high, 1);

	y_off += w->fileselect.text_height + pad;

	/* row 7.  "ok" and "select" buttons */

	XtMoveWidget (w->fileselect.okButton, pad, y_off);

	XtMoveWidget (w->fileselect.cancelButton,
				  xtw (w, "	 ok	 ") + 2*pad, y_off);

	XtSetArg(args[0], XtNwidth, w->core.width);
	XtSetValues((Widget) w, args, 1);
}

/*
 * Set specified arguments into widget
 */

static Boolean
SetValues (current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
	FileselectWidget curlw = (FileselectWidget) current;
	FileselectWidget reqlw = (FileselectWidget) request;
	FileselectWidget newlw = (FileselectWidget) new;
	int i;
	Boolean was_resized = False;
	Boolean redisplay = False;
	Arg aargs[2];


	for (i = 0; i < *num_args; ++i) {
		if (strcmp (args[i].name, XtNlabel1) == 0) {
			XtSetArg(aargs[0], XtNlabel, args[i].value);
			XtSetValues(newlw->fileselect.nameLabel1, aargs, 1);
			was_resized = True;
		}
		else if (strcmp (args[i].name, XtNlabel2) == 0) {
			XtSetArg(aargs[0], XtNlabel, args[i].value);
			XtSetValues(newlw->fileselect.nameLabel2, aargs, 1);
			was_resized = True;
		}
		else if (strcmp (args[i].name, XtNfilter) == 0) {
			XtSetArg(aargs[0], XtNstring, args[i].value);
			XtSetValues(newlw->fileselect.filterText, aargs, 1);
			get_new_filter_val ((FileselectWidget) new);
			was_resized = True;
		}
		else if (strcmp (args[i].name, XtNselection) == 0) {
			XtVaSetValues (newlw->fileselect.currSelectText,
						   XtNstring, args[i].value,
						   NULL);
			set_selection (newlw);
		}
	}

	return (was_resized || redisplay ||
			XtIsSensitive (current) != XtIsSensitive (new));
}

static void Destroy(w)
Widget w;
{
	FileselectWidget lw = (FileselectWidget) w;

	XtReleaseGC (w, lw->fileselect.normal_GC);
	XtReleaseGC (w, lw->fileselect.gray_GC);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
