#include <stdio.h>
#include <fcntl.h>

void
collect (array, xsize, ysize)
char *array;
int xsize;
int ysize;
{
	int fd;
	int bytes_to_write;

	fprintf (stderr, "xsize = %d ysize = %d\n", xsize, ysize);

	if ((fd = open ("mandel.out", O_WRONLY|O_CREAT|O_TRUNC, 0666)) < 0) {
		perror ("mandel.out");
		exit (1);
	}
	bytes_to_write = xsize * ysize;
	while (bytes_to_write > 0) {
		int bytes_written;
		bytes_written = write (fd, array, bytes_to_write);
		if (bytes_written < 0) {
			perror ("write");
			break;
		}
		bytes_to_write -= bytes_written;
		array += bytes_written;
	}
	fprintf (stderr, "%d bytes written\n", 
			xsize * ysize - bytes_to_write);

	close (fd);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
