static char USMID[] = "@(#)notify.c	1.1 10/16/90 11:03:52 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <suntool/scrollbar.h>
#include <suntool/textsw.h>

#include <sys/file.h>
#include <errno.h>
#include <math.h>
#include "externvars.h"

extern Textsw textsw;

extern int news_present;        /* Is NEWS file present for display ? */
extern Pr_texture texture;
extern Pr_brush brush;
extern Pixrect dashed;
extern task_actions_switch();

extern int mode;
extern double new_blank_interval;       /* New clock interval during blanks */
extern int blankx;
extern double str_blank_clock;         /* Start of a blank interval (histogram) */
extern Frame popup_frame,popup_key_frame,popup_news_frame, confirmer;
extern Scrollbar h_bar, pcv_bar;
extern Panel_item process_count, task_count;
extern Pixwin *pw, *pw2, *pwf;

/**********************************************************************
 * This file contains the routines which handle the notifica-
 * tions from the various buttons on the panel: 
 * go_notify_proc, load_notify_proc, connect_notify_proc, 
 * path_notify_proc, key_notfy_proc, quit_notify_proc,
 * step_notify_proc, stop_notify_proc,
 * recover_notify_proc,
 * and the routines which handle notifications from the sliders
 * on the panel:  e_speed_notify_proc and clock_interval_notify_proc,
 * and the support function
 * do_wait that causes a wait of the specified amount of time.
 * Also file_notify_proc, directory_notify_proc.
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,    */
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.     */
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

int first_time;

void scroll_update()
{
    if (ypos > 600)
      scrollbar_scroll_to(pcv_bar,ypos - 600);
    if (ypos > PCY) {
        clearscreen(pw,PCX,PCY);
        scrollbar_scroll_to(pcv_bar,0);
        ypos = 0;
    }
}

void load_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    int err;

    err = open_tracefile(file_table[ft_index+ft_val]);
#ifdef DEBUG
        printf("load_notify_proc: tracefile to load is %s\n", file_table[ft_index+ft_val]);
#endif
    if (err != 0) display_message("Select another tracefile\n");
    first_time = 1;
    window_return( NOTIFY_DONE );
}

void go_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    extern Frame frame;
    extern Panel_item event_count;
    char str[40];
    double ending_clock;
    int y;

#ifdef CRAYTRACE
    jumpingFLAG = 0;
#endif CRAYTRACE
    
    go = 1;
    if (done) {
        window_bell(frame);
        display_message("Have processed all events - GO\n");
    }
    else if (!filepresent) {
        window_bell( frame );
        display_message("ERROR: No tracefile specified\n");
    } 
    else { 
        display_message("\nTo stop, hold down left mouse button in panel\n");
        /* Looping around screen updates */
        while (!button_hit() && !done && go) {      
            /* do_wait(); */
            scroll_update();
            if  ((real_clock-clock_interval) > program_clock) { 
                if (blank_intervals  == 0) {                    
                    draw_timestamp(1,ypos);
                    pw_vector(pw,0,ypos,PCX,ypos,PIX_SET,1);            
                    ypos += NODEHEIGHT;
                    blankx = 200;
                    new_blank_interval = clock_interval;
                    str_blank_clock = program_clock;    /* For histogram */
                    pw_vector(pw,
                              blankx, ypos-NODEHEIGHT+1,
                              blankx, ypos,
                              PIX_SET ^ PIX_DST,
                              1);
                    blank_intervals++;
                    display_time_warp(program_clock  - last_real_clock);
                    last_real_clock = program_clock;
                    program_clock += clock_interval;            }

                else {
                    ending_clock=initial_clock + 
                      (clock_interval*floor((real_clock-initial_clock)/clock_interval));
                    draw_blank_intervals(ending_clock);
                }
            }
            else if (program_clock > real_clock) {              
                process_event();
                display_time_warp(real_clock - last_real_clock);
                significant_input(0);
            }
            else {
                if (blank_intervals != 0) {                             /* Finish off blank?  */
                    draw_timestamp(100,ypos-NODEHEIGHT);        /* Finish off timestamp */
                    plot_histogram(1);                  /* Finish off histogram */
                    blank_intervals = 0;
                }                   
                draw_timestamp(1,ypos);                         
                pw_vector(pw,0,ypos,PCX,ypos,PIX_SET | PIX_DST,1);
                plot_histogram(2);
                blank_intervals = 0;
                program_clock += clock_interval;                
                process_event();
                display_time_warp(real_clock - last_real_clock);
                significant_input(0);
            }
        } /* End while */
    }  /* End else */                                           
    /* fix -1 entries from being printed while jumping*/
    sprintf(str,"Events Processed: %d",((curr_events-1)<0)?0:(curr_events-1));
    panel_set(event_count,PANEL_LABEL_STRING,str,0);
    sprintf(str,"Number of  Tasks: %d",curr_tasks);
    panel_set(task_count,PANEL_LABEL_STRING,str,0);        
        
    window_return( NOTIFY_DONE );
}

draw_blank_intervals(ending_clock)
    double ending_clock;    
{
/*************************************
 * Recursive fun... 
 *************************************/
    int y, endy;

    if (button_hit()) {
        blank_intervals = 0;
        draw_timestamp(100,ypos-NODEHEIGHT);
    }
    else {
        if (program_clock < ending_clock) {
            draw_timestamp(100,ypos-NODEHEIGHT);
            blankx = blankx + ((log10(new_blank_interval) - log10(clock_interval)) + 1);
            y = ypos - NODEHEIGHT+1;
            endy = ypos;
            if (blankx < PCX)
              pw_vector(pw,blankx,y,blankx,endy,PIX_SET ^ PIX_DST,1);
            else
              blankx = 200;
            blank_intervals++;
            if (blank_intervals % 100 == 0) {
                new_blank_interval *= 10;
                display_time_warp(new_blank_interval);
            }
            last_real_clock = program_clock;
            program_clock += new_blank_interval;
            draw_blank_intervals(ending_clock);
        }
        if (program_clock > ending_clock) {
            program_clock = ending_clock;
            display_time_warp(program_clock - last_real_clock); 
            last_real_clock = ending_clock;
            draw_timestamp(100,ypos-NODEHEIGHT);
        }
    }
}

    
void step_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    extern Frame frame;
    char str[40];

#ifdef CRAYTRACE
    jumpingFLAG = 0;
#endif CRAYTRACE

    if (done) {
        window_bell(frame);
        display_message("Have processed all events - STEP\n");
    }
    else if (!filepresent) {
        window_bell( frame );
        display_message("ERROR: No tracefile specified\n");
    } 
    else {      /* Events to be processed */    
        scroll_update();
        if  ((real_clock-clock_interval) > program_clock) {             /* Interval within a break.. */
            if (blank_intervals  == 0) {                                /* ..update prgm_clock    */
                draw_timestamp(1,ypos);
                pw_vector(pw,0,ypos,PCX,ypos,PIX_SET | PIX_DST,1);              
                ypos += NODEHEIGHT;
                blankx = 200;
                new_blank_interval = clock_interval;
                pw_vector(pw,blankx,ypos-NODEHEIGHT+1,blankx,ypos,PIX_SET ^ PIX_DST,1);
            }
            else {
                draw_timestamp(100,ypos-NODEHEIGHT);
                ++blankx;
                if (blankx < PCX)
                  pw_vector(pw,blankx,ypos-NODEHEIGHT+1,blankx,ypos,PIX_SET ^ PIX_DST,1);
                else
                  blankx = 200;
            }   
            plot_histogram(2);
            str_blank_clock = program_clock;    /* For histogram */
            blank_intervals++;
            display_time_warp(program_clock-last_real_clock);
            last_real_clock = program_clock;
            program_clock += clock_interval;
        }
        else if (program_clock > real_clock) {          
            process_event();
            display_time_warp(real_clock - last_real_clock);
            significant_input(1);
        }
        else {                                                 
            if (blank_intervals != 0) { /* Finish off blank */
                draw_timestamp(100,ypos-NODEHEIGHT); /* Finish off timestamp */
                plot_histogram(1);      /* Finish off histogram */
                blank_intervals = 0;
            }
            draw_timestamp(1,ypos);                             
            pw_vector(pw,0,ypos,PCX,ypos,PIX_SET | PIX_DST,1);
            plot_histogram(2);
            program_clock += clock_interval;            
            process_event();
            display_time_warp(real_clock - last_real_clock);
            significant_input(1);
        } /* end new else */
    } /* end process else */
    window_return( NOTIFY_DONE );
}

button_hit()
/* This function returns zero if the LEFT mouse button has not been hit
 * and non-zero if it has. */
{
    extern Panel panel;
    return( (int)window_get( panel, WIN_EVENT_STATE, MS_LEFT ) );
}

void quit_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
        window_set(confirmer,WIN_SHOW,TRUE,0);
        window_return(NOTIFY_DONE);
        exit(0);
}


void display_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
/*************************************************
 * sets the value of the global variable display_
 * type.  A value of 0 indicates that the list of 
 * locks should be displayed, 1 for events, and 
 * 2 for barriers.
 ************************************************/

    display_type = value;
    window_return( NOTIFY_DONE );    
}

void 
machine_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    switch(value) {
      case 0:           /* Cray XMP */
        clock_cycle = (8.5 * pow(10.0,-9.0));           
        break;
#ifdef CTSSTRACE
      case 1:           /* Alliant */
        clock_cycle = (65 * pow(10.0,-9.0));            
        break;
#endif
#ifdef CRAYTRACE
      case 1:           /* Cray-2 */
        clock_cycle = (4.1 * pow(10.0,-9.0));           
        break;
      case 2:           /* Cray Y-MP */
        clock_cycle = (6.0 * pow(10.0,-9.0));           
        break;
#endif
    }
    window_return( NOTIFY_DONE );    
}

void 
interval_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    clock_interval = pow(10.0,(double)value);
    program_clock=initial_clock +                       /* Adjust the program clock */
      (clock_interval*floor((real_clock-initial_clock)/clock_interval));

    window_return( NOTIFY_DONE );    
}

void
idle_notify_proc(item,value,event)
Panel_item item;
int value;
Event *event;
{
        switch ((int)value)
        {
                case 0:
                        idle_interval = 100000;
                        break;
                case 1:
                        idle_interval = 500000;
                        break;
                case 2:
                        idle_interval = 1000000;
                        break;
                case 3:
                        idle_interval = 5000000;
                        break;
                case 4:
                        idle_interval = 10000000;
                        break;
                case 5:
                        idle_interval = 50000000;
                        break;
                case 6:
                        idle_interval = 100000000;
                        break;
                case 7:
                        idle_interval = 500000000;
                        break;
        }
        window_return( NOTIFY_DONE );
}



void 
connect_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
    display_message("Will handle socket input\n");
    key_enable = 0;
    window_return( NOTIFY_DONE );
}



key_notify_proc(item,event)
Panel_item item;
Event *event;
{

    if ((mode == 1) && (!key_enable)) {
        window_bell(frame);
        display_message("Cannot display key until input completed\n");
    }
    else
      if (window_get(popup_key_frame,WIN_SHOW))
        window_set(popup_key_frame,WIN_SHOW,FALSE,0);
    else
      window_set(popup_key_frame,WIN_SHOW,TRUE,0);

    window_return( NOTIFY_DONE );
}

news_notify_proc(item,event)
Panel_item item;
Event *event;
{
        if ((mode == 1) && (!key_enable))
        {
                window_bell(frame);
                display_message("Cannot display news until input completed\n");
        } else
        {
                if (news_present == 0)
                {
                        window_bell(frame);
                        display_message("No NEWS file is present for display\n");
                } else
                {
                        if (window_get(popup_news_frame,WIN_SHOW))
                        {
                                window_set(popup_news_frame,WIN_SHOW,FALSE,0);
                        } else
                        {
                                window_set(popup_news_frame,WIN_SHOW,TRUE,0);
                        }
                }
        }
        window_return( NOTIFY_DONE );
}

void hist_notify_proc(item,event)
     Panel_item item;
     Event *event;
{
/*******************************************
 * Will cause histogram to be displayed if 
 * it is not displayed already - else will
 * remove the histogram display.
 ******************************************/
    int x;   /* where to scroll to */


    if (window_get(popup_frame,WIN_SHOW))
      window_set(popup_frame,WIN_SHOW,FALSE,0);
    else {
        window_set(popup_frame,WIN_SHOW,TRUE,0);
        if (histx >= 700)
          scrollbar_scroll_to(h_bar,histx-700);
    }
    window_return(NOTIFY_DONE);
}

void e_speed_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    e_speed = value;
    window_return( NOTIFY_DONE );
}

void clock_interval_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    window_return( NOTIFY_DONE );
}


do_wait()
{
/***********************************************
 * handles the wait - the maximum wait is
 * MAXWAIT microseconds, and the minimum wait is
 * zero.  The wait will not be exactly MAXWAIT
 * microseconds - rather MAXWAIT is used to 
 * control the spin-wait.   We would have 
 * preferred to avoid a spin-wait - yet wanted
 * to check for mouse input to stop the wait.
 * The Event Speed Slider represents
 * the percentage of maximum speed - thus 
 * 100 means to run as fast as possible.
 **********************************************/
    int num,i;                  

    num = ((100 - e_speed) * .01 * MAXWAIT);

    for (i=0; i != num && !button_hit(); i++);
    if( button_hit() ) go = 0;
}
    

    

void file_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
      ft_val = value;
#ifdef DEBUG
        printf("ft_val = (%d)\n", ft_val);
#endif
      if( value >= 31 )
        load_file_table(".");
      
    window_return( NOTIFY_DONE );
}

int dirflag = 0;
void directory_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    char str[56];


        dirflag = 1;
    dt_index += value;
    if ((value+1) % 32) {
        if (chdir(directory_table[dt_index]) == -1) {
                sprintf(str,"WARNING: chdir failed, errno = %d\n", errno);
                display_message(str);
        } else {
                dt_index = 0;
                load_directory_table();
        }
    } else {
        load_directory_table();
    }
        dirflag = 0;
    window_return( NOTIFY_DONE );
}

/* POPUP PANEL STUFF */

void 
events_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    extern Frame popup_panel_frame;

    window_set(popup_panel_frame,WIN_SHOW,TRUE,0);
    window_return( NOTIFY_DONE );
}

void 
execute_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    char str[40];
    extern Panel_item jump_text,jump_choice,jump_direction,filter_choice;
    extern Panel_item event_count,process_count,task_count,clock_count;
    double save_init_clock;
    int text;
    int choice;
    int i;
    int temp_curr_process;
#ifdef CRAYTRACE
    int nb;
#include "log_entry.h"
    char junkbuf[NB_THEADER];
#endif

    strcpy(str, (char *)panel_get_value(jump_text)); 
    sscanf(str, "%d", &text);
    choice = (int)panel_get_value(jump_choice);
#ifdef LLNL     /* CTSSTRACE */
    direction = (int)panel_get_value(jump_direction);
#else            /* LLNL */     /* CTSSTRACE */
    direction == 0;
#endif LLNL     /* CTSSTRACE */

    if (done) {
        window_bell(frame);
        display_message("Have processed all events - JUMP\n");
    }
    else if (!filepresent) {
        window_bell( frame );
        display_message("ERROR: No tracefile specified\n");
    } 
    else {      
#ifdef DEBUG
        printf("execute_notify_procs processing %d  %d\n", curr_action,
                curr_id);
#endif
        /* It is given that the tracefile line to be process is already
         * looked up.   Therefore process the line just as it is.  There
         * may be a problem eventually since the if a jump is done 
         * initially the current action and id are initialized to zero.
         * This should make a difference since 0 tid's are typically 
         * ignored and the 0th element of the process[tid(0)] are 
         * ignored. */
#ifdef CRAYTRACE
      jumpingFLAG = 0;  /* log all forward events */
#endif CRAYTRACE
      switch (direction) {      /* forward or back */
       case 0:  /* seek forward */
        switch (choice) {
          case 2:  /* Find by Action Number */
            do {                /* force one iteration. */
                update_nonpost_events();
                update_task();
                if (curr_action == RECOVER ) {
                    screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
                    tasks[curr_id].x = 0;           
                }
                tasks[curr_id].post_event = -1;
                tasks[curr_id].aux_item = 0;
                if ((curr_events%50) == 0) {
                        /* fix -1 entries from being printed while
                         * jumping*/
                        sprintf(str,"Events Processed: %d",
                                ((curr_events-1)<0)?0:(curr_events-1));
                        panel_set(event_count,PANEL_LABEL_STRING,str,0);
                }
                data_input(0);          /* read the next data line. */
                /* This is a special case.   When the user jumps to start
                 * of tasks the LIGHT (32766) is not recognized.  This
                 * will make it recognized. */
                if( curr_action == LIGHT && text == START )
                        break;
            } while(!done && (curr_action != text));
            break;
          case 1:  /*  Find by Task Number */
            jump_to_task(text);
            break;
          case 0:  /*  Find by Event Count */
            jump_to_event(text);
            break;
        }
        break;
      case 1: /* seek backward */
#ifdef CRAYTRACE
        jumpingFLAG = 1;        /* set for data_seek to log new jumps */
#endif CRAYTRACE
        data_seek(choice,text);
        if( go < 0 )
        {
                clearscreen(pw, PCX, PCY);
                scrollbar_scroll_to(pcv_bar,0);
                clearscreen(pwf,PRCX,PRCY);
                go = 0;
        }
        last_real_clock= initial_clock;
        initflag = 0;
        filter_display = 0;
        panel_set(filter_choice, PANEL_VALUE,filter_display,0);
        textsw_reset(textsw,0,0);
        data_input();
        break;
      case 2:   /* rewind log */
        rewind_file();
        break;
      }
        
        clearscreen(pw,PCX,PCY);
        scrollbar_scroll_to(pcv_bar,0);
        ypos = 0;
        
        clearscreen(pwf,PRCX,PRCY);
        temp_curr_process = curr_process;
        for (i = 0; i < MAXPROCS; i++) {
            curr_process = i;
            draw_process();
        }
        curr_process= temp_curr_process;

        program_clock=initial_clock + 
          (clock_interval*floor((real_clock-initial_clock)/clock_interval));
        
        sprintf(str,"Active Processes: %d",curr_procs);         
        panel_set(process_count,PANEL_LABEL_STRING,str,0);
        sprintf(str,"Number of  Tasks: %d",curr_tasks);
        panel_set(task_count,PANEL_LABEL_STRING,str,0);    
        /* fix -1 entries from being printed while jumping, */
        sprintf(str,"Events Processed: %d",
                ((curr_events-1)<0)?0:(curr_events-1));
        panel_set(event_count,PANEL_LABEL_STRING,str,0);

        /********/
        step_notify_proc();     /* this is different */
        /* reset jump choice to default so that the user must always
         * toggle into action # choice */
        panel_set(jump_choice,PANEL_VALUE,0,0);
        /********/
        window_set(popup_panel_frame,WIN_SHOW,FALSE,0);
        window_return( NOTIFY_DONE );
    }
}

jump_to_task(text)
int text;
{
    char str[20];
    do {                /* force one iteration. */
        update_nonpost_events();
        update_task();
        if (curr_action == RECOVER ) {
            screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
            tasks[curr_id].x = 0;           
        }
        tasks[curr_id].post_event = -1;
        tasks[curr_id].aux_item = 0;
        if ((curr_events%50) == 0) {
            /* fix -1 entries from being printed while
            * jumping, */
            sprintf(str,"Events Processed: %d",
                ((curr_events-1)<0)?0:(curr_events-1));
            panel_set(event_count,PANEL_LABEL_STRING,str,0);
        }
        data_input(0);          /* read the next data line. */
    } while(!done && (curr_id != text));
}

jump_to_event(text) 
int text;
{ 
    char str[30];

    if( text == 0 )
        return;
    /* now loop forward until the correct event is reached */
    do {                /* force one iteration. */
        update_nonpost_events();
        update_task();
        if (curr_action == RECOVER ) {
            screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;  
            tasks[curr_id].x = 0;
        }
        tasks[curr_id].post_event = -1;
        tasks[curr_id].aux_item = 0;

        if ((curr_events%50) == 0) {
            /* fix -1 entries from being printed while
             * jumping, */
            sprintf(str,"Events Processed: %d",
                ((curr_events-1)<0)?0:(curr_events-1));       
            panel_set(event_count,PANEL_LABEL_STRING,str,0);      
        }
        data_input(0);          /* read the next data line. */
    } while(!done && (curr_events < text));
} 

int rewind_file()
{
#ifdef CRAYTRACE
        int nb;
#include "log_entry.h"
        char junkbuf[NB_THEADER];
#endif
        double save_init_clock;

        lseek(fp,0,L_SET);
#ifdef CRAYTRACE
        nb = read(fp,junkbuf,NB_THEADER); /* bypass CRAY header */
        if(nb <= 0)
        {
                printf("Read error after rewinding CRAY log file");
                close(fp);
                done = 1;
                go = 0;
        }
#endif
        save_init_clock = initial_clock;
        initialize();
        initial_clock = save_init_clock;
        last_real_clock=initial_clock;
        first_time = 1;
        data_input();
}


void 
cancel_notify_proc(item,value,event)
     Panel_item item;
     int value;
     Event *event;
{
    extern Frame popup_panel_frame;

    window_set(popup_panel_frame,WIN_SHOW,FALSE,0);
    window_return( NOTIFY_DONE );
}

update_nonpost_events()
{
/*********************************************************
 * check_nonpost_events filters out all of the events
 * which do not correspond to specific tasks. Returns 1
 * if the event was a nontask event, else returns 0.
 *********************************************************/

    switch (curr_action) {
      case ACQUIRE :
        procs[curr_process].state = 4;   /* now acquired but unbound */
        break;
      case IDLE :
        procs[curr_process].state = 0;
        break;
      case SUSPEND :
        procs[curr_process].state = 1;
        break;
      case REACQUIRE :
      case REQSUS:
        procs[curr_process].state = 2;
        break;
      case LOST :
        display_message("Logged events lost - view is invalid\n");
        break;
      default :
        if (curr_id == 0)               /* Check for and ignore killer actions */
          return(1);
        else
          return(0);
    }
    return(1);
}         

void
action_notify_proc(item,value,event)
    Panel_item item;
    int value;
    Event *event;

/* if action number is jump option, display a menu of action choices */

{


    extern Window action_window;
    extern Menu action_menu;
    int text, choice;
    char str[40];
    extern Panel_item jump_text,jump_choice,jump_direction;

    choice = (int)panel_get_value(jump_choice);
    switch(choice) {
        case 2: /* action choice */
            display_message("Select Action for Search\n");
#ifdef LLNL     /* CTSSTRACE */
            text = (int) menu_show(action_menu,action_window,event,0);
            sprintf(str,"%d",text);
            panel_set (jump_text,PANEL_VALUE,str,0);
            panel_paint (jump_text, PANEL_NO_CLEAR);
#endif LLNL     /* CTSSTRACE */
            break;
        case 1: /* Task number choice */
            display_message("Type Task Number for Search\n");
            break;
        case 0: /* Event count choice */
            display_message("Type Event Count for Search\n");
            break;
    }

    window_return( NOTIFY_DONE );

}

void
filter_notify_proc(item,value,event)
    Panel_item item;
    int value;
    Event *event;

/* toggle for filtering events */

{
        filter_display = value;
 
        window_return( NOTIFY_DONE );

}
#endif
