static char USMID[] = "@(#)news.c	1.2 10/22/90 13:15:48 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif sunview
#include <string.h>
#include <stdio.h>

#define RMODE	0	/* read mode */

/**********************************************************************
 * Opens the NEWS  file and deals with errors.
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Frame popup_news_frame;
struct pixfont *font;
extern Pixwin *npw;
#endif sunview
char news_line[128][81];	/* news */
int news_present;




void load_news()
{
    FILE *stream;		/* stream for NEWS file */
    char cc,name[81];
    char *ufilename ="NEWS";
    char *dirname=TIME_SRC;
    char work_dir[133]; 
    int nc, fb, i, numb;

    news_present = 0;
    getwd(work_dir);
    if ((chdir(dirname) )== -1) return;
    if ((stream =fopen(ufilename,"r") )== NULL) return;
    else {  /* have a NEWS file */

	for (i=0;i < 128; i++) {
	    nc = fscanf(stream,"%80c",name);
	    if(nc <=0) break;
	    news_line[i][80] = '\0';
	    strncpy(news_line[i],name,80); /* use only first 80 chars */
	    news_present = i+1;
	}
	fclose(stream);
	chdir(work_dir);	/* change back to working directory */
#ifdef sunview
	window_set(popup_news_frame,WIN_SHOW,FALSE,0);
	for (i=0;i<news_present;i++) {
	   pw_text(npw,15,15+20*i,PIX_SRC,0,news_line[i]);
	}
#endif sunview
#ifdef X11
	create_news();
    for (i=0;i<news_present;i++)
	{
		put_news(news_line[i]);
	}



#endif X11
    } /* end else */

    return;
}    /* end load_news */
#ifdef X11
#include "externvars.h"
#include "xexterns.h"

Widget news_button;




create_news()
{
	Arg args[10];
	extern XtActionProc news_notify_proc();
	unsigned long event_mask;

	XtSetArg(args[0],XtNx,210);
	XtSetArg(args[1],XtNy,250);
	news_shell = XtCreatePopupShell("NEWS",overrideShellWidgetClass,
		frame,args,2);
	news_pop = XtCreateManagedWidget("NEWS", boxWidgetClass,news_shell,
		NULL,0);
	

	XtSetArg(args[0],XtNheight, 400);
	XtSetArg(args[1],XtNwidth, 585);
	XtSetArg(args[2],XtNtextOptions,
		(scrollVertical|scrollVertical|wordBreak));
	XtSetArg(args[3],XtNlength,4096);
	XtSetArg(args[4],XtNborderWidth,4);
	XtSetArg(args[5],XtNeditType,XttextAppend);
#ifdef X11R3
	news_widget = XtCreateManagedWidget("NEWS",asciiStringWidgetClass,
		news_pop,args,6);
#else
	news_widget = XtCreateManagedWidget("NEWS",
		asciiTextWidgetClass, news_pop,
		args, 6);
#endif
	

	XtSetArg(args[0],XtNhorizDistance,530);
	XtSetArg(args[1],XtNvertDistance,15);
	XtSetArg(args[2],XtNborderWidth,2);
	news_button = XtCreateManagedWidget("NEWS", commandWidgetClass,
		control_widget, args, 3);
	XtAddCallback(news_button,XtNcallback,news_notify_proc);
}

XtTextPosition news_pos = 0;
put_news(s)
char *s;
{
/*********************************************
 * Display a message in the text subwindow
  **********************************************/
	XtTextBlock *TextBlockPtr;
	XtTextBlock text;
	text.firstPos = 0;
	text.ptr = s;
	text.length = strlen(text.ptr);
#ifdef X11R3
	XtTextReplace( news_widget, news_pos, news_pos, &text);
#else
    XawTextReplace(news_widget, news_pos, news_pos, &text);
	XawTextSetInsertionPoint(news_widget,news_pos);
#endif

	news_pos = news_pos + text.length;

}
#endif X11

