static char sccs_log_entry_h[] = "@(#)log_entry.h	1.1 10/16/90 11:03:06 LLNL ";

/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

/***********************************************************************
 * This file defines the what an entry in the trace file should look like
 **********************************************************************/
#ifdef CTSSTRACE
struct log_entry_templet {
    unsigned foo : 2;		/* Bits	 0: 1 ignore */
    unsigned len : 4;		/* Bits	 3: 6 number of words in the ADD */
    unsigned actno : 10;	/* Bits	 7:16 Action Number */
    unsigned pid : 6;		/* Bits 17:22 Process ID */
    unsigned clock_hi : 10;	/* Bits 23:32 Hi 10 bits of real time clock */
    unsigned clock;		/* Bits	 0:32 Lo word of RTC  */
    unsigned tdaddr;		/* Bits	 0:32 MemLoc of task Ident */
    unsigned tid;		/* Bits	 0:32 Task ID */
} log_entry;
#endif
#ifdef	CRAYTRACE
#if sun
struct log_entry_templet {
    unsigned gink1;		/* Bits	 0:32 ignored */
    unsigned tid;		/* Bits	 0:32 Task ID */

    unsigned clock_hi;		/* Bits	 0:32 High 32 bits of real time clock */
    unsigned clock;		/* Bits	 0:32 Low 32 bits of real time clock */

    unsigned gink2;		/* Bits	 0:32 ignored */
    unsigned actno;		/* Bits	 0:32 Action Number */

    unsigned hi_user;		/* Bits	 0:32 High 32 bits of user data */
    unsigned lo_user;		/* Bits	 0:32 Low 32 bits of user data */
} log_entry;
#endif
#if CRAY2 || CRAY
struct log_entry_templet {
    unsigned tid;		/* Bits	 0:32 ignored */
    unsigned clock;		/* Bits	 0:32 ignored */

    unsigned actno;		/* Bits	 0:32 Action Number */
    unsigned lo_user;		/* Bits	 0:32 Low 32 bits of user data */
} log_entry;
#endif
	/* number of Cray words in a log_entry structure*/
#define LOG_ENT_LEN	(sizeof(struct log_entry_templet)/8)
	/* number of bytes in the "user-definable" trace file header*/
#define NB_THEADER	192*8	
#endif
