static char USMID[] = "@(#)initialize.c	1.1 10/16/90 11:03:42 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>
#endif
#include <math.h>
#include "externvars.h"
#ifdef X11
#include "xexterns.h"
#endif

/**********************************************************************
 * Initilizes the various variables
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,    */
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.     */
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Pixwin *pw, *pw2, *pwf;
extern Panel_item e_speed_slider,speedometer,interval_choice,machine_choice;
extern Panel_item event_count,process_count,task_count,clock_count;
extern Panel_item filter_choice, idle_choice;
extern Scrollbar h_bar, pcv_bar;
extern Frame popup_frame;
extern Pixrect zerospeed;

/* GMAT is core dumping, segmentation violations.  It seems a SunView problem.
 * I'm just trapping the message and printing a help message. */
int *mysig()
{
    extern int dirflag;

    if(dirflag == 1 )
    {
        fprintf(stderr,"\n\ttimeline: unable to manage window.\n");
        fprintf(stderr,"\tIf you were changing directories.  Please initialize\n");
        fprintf(stderr,"\ttimeline from directory trace files reside.\n");
    }
        exit(1);
}
#endif


initialize()
{
    int i,j;
    char str[10];
#ifdef CRAYTRACE
    SNAP node;
    SNAP old_node;
    extern int biggest_snap;
#endif CRAYTRACE

#ifdef sunview
    int *mysig();

    signal(SIGSEGV,mysig);      /* initialize the signal hander */
#endif sunview

#ifdef X11
        extern XImage *speed_image[];
    extern int jumpto_direction;
    Arg args[maxArgs];

    move_height = 600;
    move_hist   = 700;
    clearscreen(canvas_display,can_win);
    clearscreen(hidden_display,hidden_win);
    jumpto_direction = 0;
#endif
#ifdef sunview
    clearscreen(pwf,PRCX,PRCY); 
    clearscreen(pw,PCX,PCY);
#endif
    initflag = 0;
    curr_events = 0;
    curr_procs = 0;
    curr_id = 0;
    curr_action = 0;
    curr_process = 0;
    filter_display = 0;
    curr_tasks = 0;
    initial_clock = 0;           /* And then there was light */
    real_clock = 0;              /* Event clock */
    last_real_clock = 0;        /* Last Event Clock */
    program_clock = 0;           /* Clock as to GMAT */
    clock_error = 0;             /* diagnostic flag for out of order clock */

    e_speed = 75;
    first_box = 1;
    ypos = 30;
    done = 0;
    leftid = -1;                        /* currently unbound SS */

#ifdef sunview
    panel_set(process_count,PANEL_LABEL_STRING,"Active Processes: 0",0);
    panel_set(event_count,  PANEL_LABEL_STRING,"Events Processed: 0",0);
    panel_set(task_count,   PANEL_LABEL_STRING,"Number of  Tasks: 0",0);
    panel_set(speedometer,PANEL_LABEL_IMAGE, &zerospeed,0);
    panel_set (filter_choice,PANEL_VALUE,filter_display,0);
#endif
#ifdef X11
    XClearWindow(control_display,control_win);
    XDrawString(control_display,control_win,control_gc,424,70,
        "Active Processes: 0",19);
    XDrawString(control_display,control_win,control_gc,424,85,
        "Events Processed: 0",19);
    XDrawString(control_display,control_win,control_gc,424,100,
        "Number of  Tasks: 0",19);
        XPutImage(display_control,control_win,control_gc,speed_image[11],
                0,0,300,75,64,64);
    XFlush(control_display);
    XtSetArg(args[0],XtNlabel,interval_table[(int)4]);
    XtSetValues(interval_choice,args,1);
    XtSetArg(args[0],XtNlabel,filter_table[(int)0]);
    XtSetValues(filter_button,args,1);
    XtSetArg(args[0],XtNlabel,idle_table[(int)2]);
    XtSetValues(idle_choice,args,1);
    XtMoveWidget(inner_canvas,-CENTER,0);
#endif
    
    clock_interval = 10000;
    idle_interval = 1000000;
#ifdef sunview
    panel_set(interval_choice,PANEL_VALUE,4,0);
    panel_set(idle_choice,PANEL_VALUE,2,0);

    scrollbar_scroll_to(h_bar,0);
    scrollbar_scroll_to(pcv_bar,0);
    window_set(popup_frame,WIN_SHOW,FALSE,0);    /* hide histogram */
#endif
    
    /* initialize locks/events/barriers array */
    for (i=0;i < MAXVALUES;i++) {
        locks[i] = -1;
        events[i] = -1;
        barriers[i] = -1;
    }

    /* initialize screen  */ 
    for (i=0;i<MAXCOLUMNS;i++) 
        screen[i].taskid = 0;

    /* ...and task structures */
    for (i=0;i<MAXTASKS;i++) {
        tasks[i].x = 0;
        tasks[i].parent = 0;
        tasks[i].wait_state = 0;
        tasks[i].process_state = -1;
#ifdef CRAYTRACE
        tasks[i].post_event = -1;
#endif CRAYTRACE
#ifdef CTSSTRACE
        tasks[i].post_event = 0;
#endif CTSSTRACE
        tasks[i].last_time_log = 0;
    }

    /* initialize process structures */
    for (i=0;i<MAXPROCS;i++) {
        procs[i].state = -1;   /* not yet acquired */
        procs[i].task = -1;    /* not bound */
        procs[i].pid = 0;      /* no process id yet */
        procs[i].x = 5;        /* all in same column */
        if( i > 7 )
                procs[i].x += 100;
    }
    /* assign the y coordinates individually */
    procs[0].y = 85*0 + 5;
    procs[1].y = 85*1 + 5;
    procs[2].y = 85*2 + 5;
    procs[3].y = 85*3 + 5;
    procs[4].y = 85*4 + 5;
    procs[5].y = 85*5 + 5;
    procs[6].y = 85*6 + 5;
    procs[7].y = 85*7 + 5;

    procs[8].y =  85*0 + 5;
    procs[9].y =  85*1 + 5;
    procs[10].y = 85*2 + 5;
    procs[11].y = 85*3 + 5;
    procs[12].y = 85*4 + 5;
    procs[13].y = 85*5 + 5;
    procs[14].y = 85*6 + 5;
    procs[15].y = 85*7 + 5;

#ifdef CRAYTRACE
    if( node_root != NULL )/* let's free the old stuff */
    {
        node=node_root;
        while(node->next != NULL)
        {
            old_node = node;
            node = node->next;
            free(old_node);
        }
        free(node);
    }

    node_root = NULL;
    biggest_snap = -1;
    jumpingFLAG = 0;    /* we're not jumping yet */
    snap_shot();        /* initialize the first record for a jump back */
#endif
    initialize_histogram();
}
