h31551
s 00732/00000/00000
d D 1.1 90/10/16 11:04:06 werner 1 0
c date and time created 90/10/16 11:04:06 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef X11
#include "externvars.h"
#include "xexterns.h"

#define LINEHEIGHT 13
#define ICONHEIGHT 47
#define ICONWIDTH  47
#include "xicons/dotted.line"		/* dotted_bits[] */
#include "xicons/light.box"		/* light_bits[] */
#include "xicons/start.box"		/* start_bits[]	 */
#include "xicons/recover.box"		/* recover_bits[] */
#include "xicons/blank.icon"		/* blank_bits[] */
#include "xicons/ready.line"		/* ready_bits[] */
#include "xicons/running.line"		/* running_bits[] */
#include "xicons/waitbnd.line"	      /* waitbound_bits[] */
#include "xicons/complete.box"		/* complete_bits[]  */
#include "xicons/pidle.icon"		/* pidle[] */
#include "xicons/psuspnd.icon"		/* psuspend[] */
#include "xicons/preacq.icon"		/* preacq[] */
#include "xicons/punbind.icon"		/* punbind_bits[] */
#include "xicons/pbind.icon"		/* pbind_bits[] */
#include "xicons/blank.box"		/* blank_box_bits[] */

/***********************************************************
 * This file contains the routines to handle the drawing
 * of the various nodes of the graph, the process icons,
 * and the view box. 
 *
 * Five types of process icons exist:
 *	B process icon - Bound process
 *	U process icon - Unbound process
 *	I process icon - Idle process
 *	S process icon - Suspended process
 *	R process icon - Reacquired process
 * The process icons were defined in the Icon Editor as
 * 64x64 pixrects.  The visible portion of the icon is
 * 48x48.  Icons are displayed via the raster operations
 * from a pixrect to a pixwin.
 *
 **********************************************************/


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

Pixmap pixmap;
extern Pixmap CreatePixmap();
XImage *idle_image;
static int idle_FLAG = 0;
XImage *suspend_image;
static int suspend_FLAG = 0;
XImage *reacq_image;
static int reacq_FLAG = 0;
XImage *bind_image;
static int bind_FLAG = 0;
XImage *unbind_image;
static int unbind_FLAG = 0;
XImage *light_image;
static int light_FLAG = 0;
XImage *start_image;
static int start_FLAG = 0;
XImage *complete_image;
static int complete_FLAG = 0;
XImage *recover_image;
static int recover_FLAG = 0;
XImage *blank_image;
static int blank_FLAG = 0;
XImage *user_image;
static int user_FLAG = 0;
Pixmap tpixmap;

extern int act_file_present;
extern void lookup();

draw_bound_state(id)
int id;
{
/**********************************
 * indicates that a 
 * process has been assigned to the
 * task by enclosing the line with
 * a double line.
 **********************************/

	int x1,x2,y; 
	int endy;
	Pixmap pixmap;
	Widget *widget_ptr;

	x1 = tasks[id].x + (COLUMNWIDTH/2) - LINESEP;
	y = ypos;
	endy = y + NODEHEIGHT;

	if(( real_clock - tasks[id].last_time_log) > idle_interval)
	{
		XDrawLine(canvas_display,can_win,dotted_gc,
			x1,y,x1,y+NODEHEIGHT);
		XDrawLine(canvas_display,can_win,dotted_gc,
			x1+10,y,x1+10,y+NODEHEIGHT);
	} else
	{
		XDrawLine(canvas_display,can_win,canvas_gc,x1,y,
			x1, y+NODEHEIGHT);
		XDrawLine(canvas_display,can_win,canvas_gc,x1+10,y,
			x1+10, y+NODEHEIGHT);
	}
}

	      
draw_wait_state(id)
int id;
{
/****************************************
 * displays a dotted or
 * solid line depending on whether or
 * not the task is waiting (dotted) or
 * ready to run (solid).
 ***************************************/
	int x,y, endy;
	Pixmap pixmap;
	Widget *widget_ptr;

	x = tasks[id].x + (COLUMNWIDTH/2);
	y = ypos;
	endy = y + NODEHEIGHT;
	if (tasks[id].wait_state != 0)
	{
		XDrawLine(canvas_display,can_win,dotted_gc,
			x,y+1,x,y+NODEHEIGHT);
	} else 
	{
		XDrawLine(canvas_display,can_win,canvas_gc,x,y,x,y+NODEHEIGHT);
	}
}



draw_process()
{
/*****************************************
 * draw_process draws or updates the 
 * process icon for the current process.
 * Process icons are displayed only in
 * the Primary Canvas - and always on 
 * the first row.
 ****************************************/
	int x,y;
	char str[10];
	Pixmap pixmap;
	Pixmap tpixmap;

	x = procs[curr_process].x;
	y = procs[curr_process].y;
	switch(procs[curr_process].state)
	{
	case -1:   /* process is not yet acquired */
	break;
	case 0 :  /* process is idle */
		if( idle_FLAG == 0 )
		{
			tpixmap = CreatePixmap(hidden_display,pidle_bits,
				pidle_width, pidle_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				pidle_width,pidle_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				pidle_width, pidle_height, 0,0,1);
			idle_image = XGetImage(hidden_display,pixmap,0,0,
				pidle_width, pidle_height, AllPlanes, XYPixmap);
			idle_FLAG = 1;
		}
		XClearArea(hidden_display,hidden_win,
			x, y, PROCDIM+36, 50, True); /* clear old task id */
		XPutImage(hidden_display,hidden_win,hidden_gc,idle_image,0,0,
			x,y, ICONWIDTH, ICONHEIGHT);
#ifdef CTSSTRACE
		sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
		sprintf(str,"proc %d",procs[curr_process].pid);
#endif
		XDrawString(hidden_display,hidden_win,hidden_gc,x,y+60,
				str,strlen(str));
		XFlush(hidden_display);
	break;
	case 1 : /* process is suspended */
		if( suspend_FLAG == 0 )
		{
			tpixmap = CreatePixmap(hidden_display,psuspend_bits,
				psuspend_width, psuspend_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				psuspend_width,psuspend_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				psuspend_width, psuspend_height, 0,0,1);
			suspend_image = XGetImage(hidden_display,pixmap,0,0,
				psuspend_width, psuspend_height, AllPlanes, XYPixmap);
			suspend_FLAG = 1;
		}
		/* clear old task id */
		XClearArea(hidden_display,hidden_win,
			x, y, PROCDIM+36, 50, True); /* clear old task id */
		XPutImage(hidden_display,hidden_win,hidden_gc,suspend_image,0,0,
			x,y, ICONWIDTH, ICONHEIGHT);
#ifdef CTSSTRACE
		sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
		sprintf(str,"proc %d",procs[curr_process].pid);
#endif
		XDrawString(hidden_display,hidden_win,hidden_gc,x,y+60,
				str,strlen(str));
		XFlush(canvas_display);
	break;
	case 2 : /* process is reaquired */
		if( reacq_FLAG == 0 )
		{
			tpixmap = CreatePixmap(hidden_display,preacq_bits,
				preacq_width, preacq_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				preacq_width,preacq_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				preacq_width, preacq_height, 0,0,1);
			reacq_image = XGetImage(hidden_display,pixmap,0,0,
				preacq_width, preacq_height, AllPlanes, XYPixmap);
			reacq_FLAG = 1;
		}
		/* clear old task id */
		XClearArea(hidden_display,hidden_win,
			x, y, PROCDIM+36, 50, True); /* clear old task id */
		XPutImage(hidden_display,hidden_win,hidden_gc,reacq_image,0,0,
			x,y, ICONWIDTH, ICONHEIGHT);
#ifdef CTSSTRACE
		sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
		sprintf(str,"proc %d",procs[curr_process].pid);
#endif
		XDrawString(hidden_display,hidden_win,hidden_gc,x,y+60,
				str,strlen(str));
		XFlush(canvas_display);
	break;
	case 3 : /* process is bound */
		/* clear old task id */
		if( bind_FLAG == 0 )
		{
			tpixmap = CreatePixmap(hidden_display,pbind_bits,
				pbind_width, pbind_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				pbind_width,pbind_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				pbind_width, pbind_height, 0,0,1);
			bind_image = XGetImage(hidden_display,pixmap,0,0,
				pbind_width, pbind_height, AllPlanes, XYPixmap);
			bind_FLAG = 1;
		}
		XClearArea(hidden_display,hidden_win,
			x, y, PROCDIM+36, 50, True); /* clear old task id */
		XPutImage(hidden_display,hidden_win,hidden_gc,bind_image,0,0,
			x,y, ICONWIDTH, ICONHEIGHT);
		sprintf(str,"<-- %d", procs[curr_process].task);
		XDrawString(hidden_display,hidden_win,hidden_gc,x+50,y+24,
				str,strlen(str));
#ifdef CTSSTRACE
		sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
		sprintf(str,"proc %d",procs[curr_process].pid);
#endif
		XDrawString(hidden_display,hidden_win,hidden_gc,x,y+60,
				str,strlen(str));
		XFlush(canvas_display);
	break;
	case 4 : /* process is unbound */
		/* clear old task id */
		if( unbind_FLAG == 0 )
		{
			tpixmap = CreatePixmap(hidden_display,punbind_bits,
				punbind_width, punbind_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				punbind_width,punbind_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				punbind_width, punbind_height, 0,0,1);
			unbind_image = XGetImage(hidden_display,pixmap,0,0,
				punbind_width, punbind_height, AllPlanes, XYPixmap);
			unbind_FLAG = 1;
		}
		XClearArea(hidden_display,hidden_win,
			x, y, PROCDIM+36, 50, True); /* clear old task id */
		XPutImage(hidden_display,hidden_win,hidden_gc,unbind_image,0,0,
			x,y, ICONWIDTH, ICONHEIGHT);
#ifdef CTSSTRACE
		sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
		sprintf(str,"proc %d",procs[curr_process].pid);
#endif
		XDrawString(hidden_display,hidden_win,hidden_gc,x,y+60,
				str,strlen(str));
		XFlush(canvas_display);
	break;
	default : display_message("Unknown process state\n");
	}
}


draw_event(id)
int id;
{
/******************************************
 * draw_event draws a node appropriate to
 * the posted event of the task.
 *****************************************/
	int x,y,endx;
	int action_no;
	char str[20];
	Pixmap pixmap;
	Pixmap tpixmap;

	x = tasks[id].x - 10;
	y = ypos;	
	action_no = tasks[id].post_event;

	/* filter to the appropriate switches for the drawing */
	switch (action_no)
	{
	case LIGHT:	case START:
	case COMPLETED:		case RECOVER:
	case BIND:		case UNBIND:
	case TWAIT:
		special_draw_switch(id);
	break;
	case LASSIGN:	case LRELEASE:		case LWAIT:
	case LNWAIT:	case LRESUME:		case LCLEAR:
	case LTEST:
	case EWAIT:		case ENWAIT:		case ERESUME:
	case ECLEAR:	case EPOST:		case EASSIGN:
	case ERELEASE:	case ETEST:
	case TTEST:	case TNWAIT:		case TRESUME:
	case BASSIGN:	case BRELEASE:		case BWAIT:
	case BNWAIT:	case BRESUME:
	case GNWAIT:	case GNRESUME:		case GWAIT:
	case GRESUME:
	case SINIT:

	/*  The following case variables are current reserved for user
	 *  buffers in CRAY dumps.   In the future they may be used for
	 *  microtasing.   Until then they should be treated as user buffer
	 *  variables when coming from CRAY tracefiles. */
#ifdef CTSSTRACE
	case MSTARTF:	case MWAITF:	case MRESUMEF:	 case SSTARTF:
	case SEXIT:	case CSWAIT:	case CSRESUME:
#endif
	case CSNWAIT:	case SWAITW:	case REQUEST:
#ifdef CRAYTRACE	/* COS only */
	case REQUEST_NA:
#endif CRAYTRACE
	if( blank_FLAG == 0 )
	{
		tpixmap = CreatePixmap(canvas_display,blank_box_bits,
			blank_box_width-4, blank_box_height);
		pixmap = XCreatePixmap(canvas_display,
			DefaultRootWindow(canvas_display),
			blank_box_width-4,blank_box_height,depth);
		/* copy exactly one plane from pointer to pixmap */
		XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
			blank_box_width-4, blank_box_height, 0,0,1);
		blank_image = XGetImage(canvas_display,pixmap,0,0,
			blank_width-4, blank_height, AllPlanes, XYPixmap);
		blank_FLAG = 1;
	}
	if(filter_display == 0 )
	{
		XPutImage(canvas_display,can_win,canvas_gc,blank_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,event_gc,x+5,y+12,
			node_str,strlen(node_str));
		XFlush(canvas_display);
	} else if(filter_display == 1 && action_no <GNWAIT )
	{
		XPutImage(canvas_display,can_win,canvas_gc,blank_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,event_gc,x+5,y+12,
			node_str,strlen(node_str));
		XFlush(canvas_display);
	} else if( event_error > 0 )
	{
		sprintf(str,"X:%d",error_count);
		XPutImage(canvas_display,can_win,canvas_gc,blank_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,event_gc,x+20,
			y+NODEHEIGHT-3,node_str,strlen(node_str));
		XFlush(canvas_display);
	} else
	{
		draw_wait_state(id);
		if(tasks[id].process_state != -1)  /* bound */
			draw_bound_state(id);
		switch(action_no)
		{
		case BWAIT: case LWAIT: case GWAIT: case MWAITF: case SWAITW:
		case CSWAIT: case EWAIT:
		XPutImage(canvas_display,can_win,canvas_gc,blank_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,event_gc,x+5,y+12,
			node_str,strlen(node_str));
		XFlush(canvas_display);
		}
	}
	break;
	default:
		if(action_no != -1)
		{
		if(act_file_present > 0)
		{
			lookup(action_no,str);

		}else
		{
			sprintf(str,"%d",action_no);
		}
		if( user_FLAG == 0 )
		{
			tpixmap = CreatePixmap(canvas_display,blank_bits,
				blank_width, blank_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				blank_width,blank_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				blank_width, blank_height, 0,0,1);
			user_image = XGetImage(canvas_display,pixmap,0,0,
				blank_width, blank_height, AllPlanes, XYPixmap);
			user_FLAG = 1;
		}
		XPutImage(canvas_display,can_win,canvas_gc,user_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,event_gc,x+20,
				y+NODEHEIGHT - 3, str,strlen(str));
		XFlush(canvas_display);
		} 
	break;
	}
#ifdef CRAYTRACE
	tasks[id].post_event = -1;
#endif CRAYTRACE
#ifdef CTSSTRACE
	tasks[id].post_event = 0;
#endif CTSSTRACE
	tasks[id].aux_item = 0;
	sprintf(node_str,"");
}


special_draw_switch(id)
int id;
{
/******************************************************
 * special_draw_switch draws the nodes which require
 * special pixrects, or additional lines to be drawn.
 * These include task actions such as Light, Start,
 * Complete, Recover, Bind, Unbind, and Wait Task
 *****************************************************/
	int x,y,endx;
	int action_no;
	char str[30];

	x = tasks[id].x - 10;
	y = ypos;	

	action_no = tasks[id].post_event;
	switch (action_no)
	{
	case LIGHT :
		if( light_FLAG == 0 )
		{
			tpixmap = XCreateBitmapFromData(display_control,
				DefaultRootWindow(display_control),light_bits,
				light_width, light_height); /* width - 4 */
			pixmap = XCreatePixmap(display_control,
				DefaultRootWindow(canvas_display),
				light_width,light_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
				light_width, light_height, 0,0,1);
			light_image = XGetImage(display_control,pixmap,0,0,
				light_width, light_height, AllPlanes, XYPixmap);
			light_FLAG = 1;
		}
		XPutImage(display_control,can_win,canvas_gc,light_image,0,0,
			x,y, RECTX, RECTY);
		draw_process();
	break; 
	case START : 
		sprintf(str,"%d",id);
/* This isn't working on the cray2 
		if( start_FLAG == 0 )
		{ */
			tpixmap = CreatePixmap(canvas_display,start_bits,
				start_width-4, start_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				start_width,start_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				start_width, start_height, 0,0,1);
			start_image = XGetImage(canvas_display,pixmap,0,0,
				start_width-4, start_height, AllPlanes, XYPixmap);
			start_FLAG = 1;
/*		} */
		XPutImage(canvas_display,can_win,canvas_gc,start_image,0,0,
			x,y, RECTX, RECTY);
		XDrawString(canvas_display,can_win,canvas_gc,x+43,
				y+11, str,strlen(str));
		XFlush(canvas_display);
		/* draw line to task waiting on */
		endx = tasks[tasks[id].parent].x + (COLUMNWIDTH/2);
		if (endx > x)
		{
			XDrawLine(canvas_display,can_win,canvas_gc,x+60,y+7,
				endx, y+7);
			XDrawLine(canvas_display,can_win,canvas_gc,x+60,y+8,
				endx, y+8);
		} else
		{
			XDrawLine(canvas_display,can_win,canvas_gc,x,y+7,
				endx, y+7);
			XDrawLine(canvas_display,can_win,canvas_gc,x,y+8,
				endx, y+8);
		}
		XFlush(canvas_display);
	break;
	case COMPLETED :
		draw_process();
		if( complete_FLAG == 0 )
		{
			tpixmap = CreatePixmap(canvas_display,complete_bits,
				complete_width-4, complete_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				complete_width-4,complete_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				complete_width-4, complete_height, 0,0,1);
			complete_image = XGetImage(canvas_display,pixmap,0,0,
				complete_width-4, complete_height, AllPlanes, XYPixmap);
			complete_FLAG = 1;
		}
		XPutImage(canvas_display,can_win,canvas_gc,complete_image,0,0,
			x,y, RECTX, RECTY);
#ifdef CRAYTRACE /* we don't have RECOVERS the COMPLETE is the end */ 
		screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
		tasks[curr_id].x = 0;
#endif CRAYTRACE
	break;
	case RECOVER : 
		if( recover_FLAG == 0 )
		{
			tpixmap = CreatePixmap(canvas_display,recover_bits,
				recover_width, recover_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				recover_width,recover_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				recover_width, recover_height, 0,0,1);
			recover_image = XGetImage(canvas_display,pixmap,0,0,
				recover_width, recover_height, AllPlanes, XYPixmap);
		}
		XPutImage(canvas_display,can_win,canvas_gc,recover_image,0,0,
			x,y, RECTX, RECTY);
		screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
		tasks[curr_id].x = 0;
	break;
	case BIND :
		draw_wait_state(id);
		draw_bound_state(id);
		draw_process();
	break;
	case UNBIND :
		draw_wait_state(id);
		draw_process();
	break;
	case TWAIT :
		if( blank_FLAG == 0 )
		{
			tpixmap = CreatePixmap(canvas_display,blank_box_bits,
				blank_box_width-4, blank_box_height);
			pixmap = XCreatePixmap(canvas_display,
				DefaultRootWindow(canvas_display),
				blank_box_width,blank_box_height,depth);
			/* copy exactly one plane from pointer to pixmap */
			XCopyPlane(canvas_display,tpixmap,pixmap,hidden_gc,0,0,
				blank_box_width, blank_box_height, 0,0,1);
			blank_image = XGetImage(canvas_display,pixmap,0,0,
				blank_width-4, blank_height, AllPlanes, XYPixmap);
			blank_FLAG = 1;
		}
		if(filter_display < 2 )
		{
			sprintf(str,"WT :%2d",tasks[id].wait_state);
			XPutImage(canvas_display,can_win,canvas_gc,blank_image,0,0,
				x,y, RECTX, RECTY);
			XDrawString(canvas_display,can_win,canvas_gc,x+5,
					y+12, str,strlen(str));
			XFlush(canvas_display);
		} else if( event_error > 0 )
		{
			sprintf(str,"X:%d",error_count);
			XDrawString(canvas_display,can_win,canvas_gc,x+20,
				y+NODEHEIGHT-3, str,strlen(str));
			XPutImage(canvas_display,can_win,canvas_gc,blank_image,
				0,0,x,y,RECTX,RECTY);
		} else
		{
			draw_wait_state(id);
			if(tasks[id].process_state != -1)  /* bound */
				draw_bound_state(id);
		}
	break;
	default :
	break;
	}
}

check_value(addr,type)
int addr, type;
{
/*******************************************
 * check_value takes an address and a type 
 * (1=lock,0=event) and returns with the 
 * value that has already been assigned to
 * that lock or event, or a new value. 
 * This is meant to provide the user with
 * a more comprehensive display - containing
 * labels for locks, versus numbers.
 *******************************************/
	int i;

	if (type == 2)		  /* is a barrier */
	{
		for (i=0; (barriers[i] != -1) && (i < MAXVALUES);i++)
		{
			if (barriers[i] == addr)
			{
				return(i);
			}
		}
		/* did not find the address, therefore add it in */
		barriers[i] = addr;
		return(i);
	} else if (type == 1)		/* is a lock */
	{
		for (i=0; (locks[i] != -1) && (i < MAXVALUES);i++)
		{
			if (locks[i] == addr)
			{
				return(i);
			}
		}
		/* did not find the address, therefore add it in */
		locks[i] = addr;
		return(i);
	} else	  /* is an event */
	{
		for (i=0; (events[i] != -1) && (i < MAXVALUES);i++)
		{
			if (events[i] == addr)
			{
				return(i);
			}
		}
		/* did not find the address, therefore add it in */
		events[i] = addr;
		return(i);
	}
}
	    
void
draw_timestamp(x,y)
int x,y;
{
	char str[40];
	double dummy;

	dummy = (program_clock - initial_clock);
	sprintf(str,"%-.0f", dummy);

	XClearArea(canvas_display,can_win,
		x+CENTER,y+2,100,13,True);
	XDrawString(canvas_display,can_win,canvas_gc,x+CENTER,
			y+NODEHEIGHT- 4, str,strlen(str));
}


Pixmap CreatePixmap(dpy,bits,width,height)
Display *dpy; char *bits; int width; int height;
{
	Pixmap pixmap;

	pixmap = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),
					bits, width, height);
/*
	pixmap = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),
					bits, width, height, black, white, depth);
*/
	return(pixmap);
}
#endif
E 1
