h07431
s 00485/00000/00000
d D 1.1 90/10/16 11:04:04 werner 1 0
c date and time created 90/10/16 11:04:04 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef X11
#include <math.h>
#include "externvars.h"
#include "xexterns.h"

/**********************************************************************
 * This routine displayes a message in the textsw window for the users
 * edification.
 **********************************************************************/


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern double update_time;

#include "xicons/zero.icon"
#include "xicons/one.icon"
#include "xicons/none.icon"
#include "xicons/two.icon"
#include "xicons/ntwo.icon"
#include "xicons/three.icon"
#include "xicons/nthree.icon"
#include "xicons/nfour.icon"
#include "xicons/four.icon"
#include "xicons/five.icon"
#include "xicons/nfive.icon"
#include "xicons/six.icon"
#include "xicons/nsix.icon"
#include "xicons/seven.icon"
#include "xicons/nseven.icon"

extern GC canvas_gc;
extern Window can_win;
extern Display *canvas_display, *display_control;
extern Widget message_widget, frame;


XtTextPosition spos = 0;
XtTextPosition epos = BUFFER_LENGTH;
display_message(s)
char *s;
{
/*********************************************
 * Display a message in the text subwindow 
 **********************************************/ 
	XtTextBlock *TextBlockPtr;
	XtTextBlock text;

	if( spos > (BUFFER_LENGTH-80) )
	{
		text.firstPos = 0;
		text.ptr = "";
		text.length = 0;
		spos = 0;
#ifdef X11R3
		XtTextReplace( message_widget, spos, epos, &text);
#else
		XawTextReplace(message_widget, spos, epos, &text);
		XawTextSetInsertionPoint(message_widget,epos);
#endif
	}
	text.firstPos = 0;
	text.ptr = s;
	text.length = strlen(text.ptr);
#ifdef X11R3
	XtTextReplace( message_widget, spos, spos, &text);
#else
	XawTextReplace(message_widget, spos, epos, &text);
	XawTextSetInsertionPoint(message_widget,epos);
#endif
	spos = spos + text.length;
}

display_task_id()
{
/*********************************************
 * Function to print out the task id line on the
 * the screen.
 *********************************************/
	int x,id,i,y;
	char str[5];

	y = ypos + NODEHEIGHT - 2;
	for (i=0;i < MAXCOLUMNS;i++)
	{
		id = screen[i].taskid; 
		if ( id != 0)
		{
			x = tasks[id].x + (COLUMNWIDTH/2) - 10;
			sprintf(str,"%d",id);
			XDrawString(canvas_display,can_win,canvas_gc,x,y,
					str,strlen(str));
		}
	}
	ypos += NODEHEIGHT;
}

static int display_FLAG = 0;
static Widget display_shell, display_widget;
void display_values(widget, client_data, event)
Widget widget;
caddr_t client_data;
XEvent *event;
{
/**********************************************
 * display_values displays the values assigned 
 * to the various locks, events, or barriers.
 ********************************************/	 
	char str[40];
	int i;
	Arg args[10];
	Display *table_display;
	Window table_window;
	int x;
	int y;


	if( event->xbutton.button != 2 && event->xbutton.button != 3 )
	{
		return;
	}

	if( display_FLAG == 0 )
	{
		XtSetArg(args[0],XtNx, 250);
		XtSetArg(args[1],XtNy, 200);
		display_shell = XtCreatePopupShell("",overrideShellWidgetClass,
					frame, args, 2);
		
		XtSetArg(args[0],XtNwidth,200);
		XtSetArg(args[1],XtNheight,400);
		display_widget = XtCreateManagedWidget("tables", boxWidgetClass,
						display_shell, args, 2);
		XtPopup(display_shell,XtGrabNone);
		display_FLAG = 1;

		table_display = XtDisplay(display_widget);
		table_window = XtWindow(display_widget);
		x = 30;
		y = 40;
	} else
	{
		XtPopdown(display_shell);
		XtDestroyWidget(display_shell);
		display_FLAG = 0;
		return;
	}

	switch (display_type)
	{
	case 0 :   /* locks */
		if (locks[0] == -1)
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"No Locks",8);
		} else
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"Values of the Locks", 19);
			XDrawString(table_display,table_window,canvas_gc,30,30,
				"-------------------", 19);
		for (i= 0;(i < MAXVALUES) && (locks[i] != -1);i++)
		{
			sprintf(str,"Value: %d	Address: %d", 
				i, locks[i]);
			XDrawString(table_display,table_window,canvas_gc,x,y,
				str, strlen(str));
			y += 12;
		} 
	}
	break;
	case 1 :   /* events */
		if (events[0] == -1)
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"No Events",9);
		} else
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"Values of the Events",20);
			XDrawString(table_display,table_window,canvas_gc,30,30,
				"--------------------",20);
		for (i= 0;(i < MAXVALUES) && (events[i] != -1);i++)
		{
			sprintf(str,"Value: %d	Address: %d", 
				i, events[i]);
			XDrawString(table_display,table_window,canvas_gc,x,y,
				str,strlen(str));
			y += 12;
		} 
	}
	break;
	case 2 :
		if (barriers[0] == -1)
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"No Barriers", 11);
		} else
		{
			XDrawString(table_display,table_window,canvas_gc,30,20,
				"Values of the Barriers",22);
			XDrawString(table_display,table_window,canvas_gc,30,30,
				"----------------------",22);
		for (i= 0;(i < MAXVALUES) && (barriers[i] != -1);i++)
		{
			sprintf(str,"Value: %d	Address: %d", 
				i, barriers[i]);
			XDrawString(table_display,table_window,canvas_gc,x,y,
				str,strlen(str));  
			y += 12;
		} 
	}
	break;
	}
}


display_time_warp(clock_difference)
double clock_difference;
{
/**************************************************
* Display the correlation between Cray/Alliant time 
* and real time.  Will be reported as a power 
* of ten: 1 (s) Cray/Alliant = 10^X (s) Timeline Time.
***************************************************/
	double logpower;
	double warpfactor;
	int tenpower;
	char str[20];

	if (clock_difference == 0 )
	{
		logpower = 0.0;
	} else
	{
		warpfactor = (update_time)/(clock_cycle*clock_difference);
		logpower = (log10(warpfactor));
		if (logpower < 0)			/* Round ... */
			logpower = logpower - 0.5;
		else
			logpower = logpower + 0.5;
	}
	tenpower = (int)logpower;			/* ... and truncate  */

	switch (tenpower)
	{
	case -7:
		put_speedometer(-7);
		break;
	case -6:
		put_speedometer(-6);
		break;
	case -5:
		put_speedometer(-5);
		break;
	case -4:
		put_speedometer(-4);
		break;
	case -3:
		put_speedometer(-3);
		break;
	case -2:
		put_speedometer(-2);
		break;
	case -1:
		put_speedometer(-1);
		break;
	case 0:
		put_speedometer(0);
		break;
	case 1:
		put_speedometer(1);
		break;
	case 2:
		put_speedometer(2);
		break;
	case 3:
		put_speedometer(3);
		break;
	case 4:
		put_speedometer(4);
		break;
	case 5:
		put_speedometer(5);
		break;
	case 6:
		put_speedometer(6);
		break;
	case 7:
		put_speedometer(7);
		break;
	}
}

XImage *speed_image[15];
put_speedometer(bits)
int bits;
{
	Arg args[1];
	bits = bits+7;

/*
	XtSetArg(args[0],XtNbackgroundPixmap,speed_image[bits]);
	XtSetValues(speedometer_label,args,1);
*/
	XPutImage(display_control,control_win,control_gc,speed_image[bits],
		0,0,300,75,64,64);
	XFlush(control_display);
}

init_speed()
{
	int width = 64;
	int height = 64;
	Pixmap tpixmap, pixmap;

	tpixmap = CreatePixmap(display_control,nseven_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[0] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,six_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[1] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,nfive_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[2] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,nfour_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[3] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,nthree_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[4] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,ntwo_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[5] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,none_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[6] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,zero_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[7] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,one_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[8] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,two_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[9] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,three_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[10] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,four_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[11] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,five_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[12] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,six_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[13] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	tpixmap = CreatePixmap(display_control,seven_bits,
		width,height);
	pixmap = XCreatePixmap(display_control,DefaultRootWindow(display_control),
		width,height,depth);
	/* copy exactly one plane from pointer to pixmap */
	XCopyPlane(display_control,tpixmap,pixmap,canvas_gc,0,0,
		width, height, 0,0,1);
	speed_image[14] = XGetImage(display_control,pixmap,0,0,width,height,
		AllPlanes, XYPixmap);

	return(0);
}
#endif
E 1
