h06750
s 00083/00000/00000
d D 1.1 90/10/16 11:03:49 werner 1 0
c date and time created 90/10/16 11:03:49 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifndef STDERR
/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#include <stdio.h>
#include <nl_types.h>

void
msghan(message_number,fatal_flag,optional_string)
int     message_number;
int     fatal_flag;
char    *optional_string;
{
        nl_catd mcfd;  /* catalog descriptor */
        char    the_message[201];
        char    *result;
        char    *severity;
        char    final_message[2001];
        char    intermediate_message[1001];
        char    *the_output;

        if (fatal_flag) {
                severity = "UNRECOVERABLE";
        } else {
                severity = "WARNING";
        }

        /* get error text from error message system */

        mcfd = catopen("time",0);
        if (mcfd == -1) {
                strcpy(the_message,"(UNABLE TO LOAD ERROR MESSAGE CONTENTS)");
        } else {
                the_message[0] = '\0';
                result = catgetmsg(mcfd,NL_MSGSET,message_number,the_message,200);
        }

        /* at this point, the_message contains the message text, as
         * read from the message database
         *
         * if the optional_string is not NULL, we will insert its
         * contents into the message, using the message as a sprintf
         * format descriptor
         */

        if (optional_string == NULL) {
                /* just point to the_message */
                result = the_message;
        } else {
                sprintf(intermediate_message,the_message,optional_string);
                result = intermediate_message;
        }

        the_output = catmsgfmt("time","time",message_number,severity,
                result,final_message,2000);

        /* write messages to error_message, which may be stdout or stderr,
         * depending on some flags.  we don't care which, we just write.
         */

        fprintf(stderr,final_message);


        if (fatal_flag)
                exit(1);
        catclose(mcfd);
}
#endif 
E 1
