h18159
s 00786/00000/00000
d D 1.1 90/10/16 11:03:28 werner 1 0
c date and time created 90/10/16 11:03:28 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";

#include "externvars.h"

/***********************************************************
 * This file contains the routines to handle the checking
 * of the various event actions of the log for consistency
 *		see RULES below
 *
 **********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/



#define MAXATASKS	50	/* maximum active tasks */
#define MAXFRAYS	16	/* maximum active frays */
#define MAX_TASK_RULES	15	/* maximum number of rules for tasks */
#define MAX_PROC_RULES	2	/*  maximum number of rules for processes */
#define MAX_FRAY_RULES	3	/*  maximum number of rules for frays*/
#define MAX_OTHER_RULES 4	/* Maximum number other rules (lock,barrier,event) */
#define TLOCK 280
#define TBARRIER 281
#define TEVENT 282
#define TCS 283
#define CSDONE 284

extern void display_message();
extern void lookup();
extern void err_message();
extern void err2_message();

/* -----------------------------------------------------------------------
			RULES

t  = task; o = fray owner; p = process; l = lock; b = barrier; e = event;
t' = task waited for; n = guard #, q = control structure #
-----------------------------------------------------------------------*/



/*

			TASK rules

1.(CTSSTRACE)		START(t)	...	COMPLETED(t)

2.(CTSSTRACE)		COMPLETED(t)	...	RECOVER(t)

3.			[BIND(t,p)| LIGHT(p)]	...	UNBIND(t,p)


4.			TWAIT(t,t')	...	TRESUME(t,t')

5.	TLOCK(t,l)    = LWAIT(t,l)	...	LRESUME(t,l)  | LNWAIT(t,l)

6.	TBARRIER(t,b) = BWAIT(t,b)	...	BRESUME(t,b)
	
7.	TEVENT(t,e)   = EWAIT(t,e)	...	ERESUME(t,e)

8.	TCS(t,o)      = CSWAIT(t,o)	...	CSRESUME(t,o)

9.			MSTARTF(t)	...	[CSNWAIT(t,t) | TCS(t,t)]* 
			...	MWAITF(t)	...	MRESUMEF(t)

10.			[SSTARTF(t,o)	...	[CSNWAIT(t,o) | TCS(t,o)]* ]* 
			...	SWAITW(t)
	 
11.			GNWAIT(t,n)	...	GNRESUME(t,n)

12.			GWAIT(t)	...	GRESUME(t)


			PROCESS rules

1.			ACQUIRE(p)	...	[BIND(p) | SUSPEND(p)]
			REACQUIRE(p)	...	[BIND(p) | SUSPEND(p)]
			UNBIND(p)	...	BIND(p)	 |
			COMPLETED(p)	...	BIND(p)
1.(CRAYTRACE)	|	COMPLETED(p) ...UNBIND(p) ...BIND(p)

2.			SUSPEND(p)	...	REACQUIRE(p)



			LOCK, BARRIER, EVENT rules

1.  LASSIGN(l) ... [LNWAIT(l)|TLOCK(?,l)|LTEST(l)|LCLEAR(l)]* ... LRELEASE(l)

2.  BASSIGN(b) ... [BNWAIT(b) | TBARRIER(?,b)]* ... BRELEASE(b)

3.  EASSIGN(e) ... [ENWAIT(e)|TEVENT(?,e)|EPOST(e)}|ECLEAR(e)|ETEST(e)]* 
	       ...	ERELEASE(e)

4.  LNWAIT(l)	|    LRESUME(l)	  ...	LCLEAR(l)


			FRAY rules

1.			MSTARTF(o)	...	[SSTARTF(?,o)]* ...   MRESUMEF(o)

2.	CSDONE(o)  =	[CSWAIT(?,o)]q	... CSNWAIT(?,o) 
			where q >= 0

3.			MSTARTF(o)	...	[CSDONE(o)]*	...   MRESUMEF(o)



*/

/* ----------------------------------------------------------------------- */

char tstr[80];

int errflg; /* local flag for setting error condition */


int check_action()
{
/*  saved variables */
	static int slot[MAXATASKS], ts[MAX_TASK_RULES][MAXATASKS][4];
	static int ps[MAX_PROC_RULES][MAXPROCS][3];
	static int fs[MAX_FRAY_RULES][MAXFRAYS][4], fslot[MAXFRAYS];
	static int os[MAX_OTHER_RULES][MAXVALUES][3];

/* temporary variables */
	int s; /* slot number*/
	int f;/* fray slot number*/
	int lev; /* level in rule stack */
	int e,l,b,o;
	int i,j;

/* initialize slots and levels */
	errflg = 0;

	if (initflag == 0) {
		initflag=1;
		for (i=0;i<MAXFRAYS;i++) {
			fslot[i] = -1;
			for (j=0;j < MAX_FRAY_RULES;j++)
				fs[j][i][0] = 0;
				fs[j][i][3] = 0; /* cs number */
		}
		for (i=0;i<MAXATASKS;i++) {
			slot[i] = -1;
			for (j=0;j < MAX_TASK_RULES;j++)
				ts[j][i][0] = 0;
		}
		for (i=0;i<MAXPROCS;i++) {
			for (j=0;j < MAX_PROC_RULES;j++)
				ps[j][i][0] = 0;
		}
		for (i=0;i<MAXVALUES;i++) {
			for (j=0;j < MAX_OTHER_RULES;j++)
				os[j][i][0] = 0;
		}
	}

/* get an active slot for current task	*/
	s = 0;
	while (s < MAXATASKS  && slot[s] != curr_id) {
		s++;
	}
	i = 0;
	while (s >= MAXATASKS && i < MAXATASKS	 ) {
		if(slot[i] == -1 ) {
			slot[i] = curr_id ; 
			s = i; 
		}
		i++;
	}
	if (i >= MAXATASKS) {	
		display_message ("Too many active tasks for checking!!\n");
		return(errflg);
	}

/*	check appropiate rule for current action */
#ifdef CTSSTRACE
	if(curr_action < LIGHT) return(errflg);
#endif
	switch (curr_action) {
/* actions not checked */
		case IDLE:
		case TNWAIT:
		case TTEST:
		case SINIT:
		case SEXIT:
		case REQUEST:
			return(errflg);
		case LIGHT:
			lev = ts[2][s][0];
			if (lev !=0) {
				err_message(ts[2][s][lev],curr_action);
			}
			ts[2][s][0] = 1;
			ts[2][s][1] = curr_action;
			ts[2][s][3] = curr_process;
			break;

		case START:
#ifdef CTSSTRACE
			lev = ts[0][s][0];
			if (lev !=0 ) err_message(ts[0][s][lev],curr_action);
			ts[0][s][0] = 1;
			ts[0][s][1] = curr_action;
			ts[2][s][0] = 0;
#endif
#ifdef CRAYTRACE
			if(curr_id == 1) {
				ts[2][s][0] = 1;
				ts[2][s][1] = LIGHT;
			}
#endif
			break;

		case COMPLETED:
#ifdef CTSSTRACE
			lev = ts[0][s][0];
			if(lev == 0) err_message(0,curr_action);
			else ts[0][s][0] = 0;

			lev = ts[1][s][0];
			if (lev !=0) err_message(ts[1][s][lev],curr_action);
			ts[1][s][0] = 1;
			ts[1][s][1] = curr_action;
			lev = ps[0][curr_process][0];
			if(lev != 0) 
			    err_message(ps[0][curr_process][lev],curr_action);
			ps[0][curr_process][0] = 1;
			ps[0][curr_process][1] = curr_action;

#endif
			break;

		case RECOVER:
			lev = ts[1][s][0];
			if(lev == 0) err_message(0,curr_action);
			else ts[1][s][0] = 0;
			slot[s] = -1;
			break;

		case BIND:
			lev = ts[2][s][0];
			if (lev !=0) err_message(ts[2][s][lev],curr_action);
			ts[2][s][0] = 1;
			ts[2][s][1] = curr_action;
			ts[2][s][3] = curr_process;
#ifdef CTSSTRACE
			lev = ps[0][curr_process][0];
			if(lev == 0) err_message(0,curr_action);
			else ps[0][curr_process][0] = 0;
#endif
#ifdef CRAYTRACE
			ps[0][curr_process][0] = 0;
#endif

			break;

		case UNBIND:
			lev = ts[2][s][0];
			if(lev == 0) err_message(0,curr_action);
			else if (ts[2][s][3] != curr_process){
				err_message(ts[2][s][lev],curr_action);
				err2_message(ts[2][s][3],curr_process);
			}
#ifdef CRAYTRACE
			if(ts[2][s][lev] == COMPLETED) slot[s] = -1;
#endif

			ts[2][s][0] = 0;

			lev = ps[0][curr_process][0];
#ifdef CTSSTRACE
			if(lev !=0) err_message(ps[0][curr_process][lev],curr_action);
#endif
#ifdef CRAYTRACE
			if(lev !=0 && ps[0][curr_process][lev] != COMPLETED) 
			  err_message(ps[0][curr_process][lev],curr_action);
#endif
			ps[0][curr_process][0] = 1;
			ps[0][curr_process][1] = curr_action;


			break;

		case ACQUIRE:
			lev = ps[0][curr_process][0];
			if(lev !=0) err_message(ps[0][curr_process][lev],curr_action);
			ps[0][curr_process][0] = 1;
			ps[0][curr_process][1] = curr_action;

			break;

		case SUSPEND:
			ps[0][curr_process][0] = 0;
#ifdef CTSSTRACE
			lev = ps[1][curr_process][0];
			if(lev !=0) err_message(ps[1][curr_process][lev],curr_action);
#endif
			ps[1][curr_process][0] = 1;
			ps[1][curr_process][1] = curr_action;
			break;

		case REACQUIRE:
			lev = ps[0][curr_process][0];
			if(lev !=0) err_message(ps[0][curr_process][lev],curr_action);
			ps[0][curr_process][0] = 1;
			ps[0][curr_process][1] = curr_action;

			lev = ps[1][curr_process][0];
			if(lev == 0 && curr_id > 0) err_message(0,curr_action);
			ps[1][curr_process][0] = 0;
			break;

		case TWAIT:
			lev = ts[3][s][0];
			if (lev !=0) err_message(ts[3][s][lev],curr_action);
			ts[3][s][0] = 1;
			ts[3][s][1] = curr_action;
			ts[3][s][3] = (int) aux_data[0];	/* save t' */
			break;
			
		case LWAIT:
			lev = ts[4][s][0];
			l = (int)check_value((int) aux_data[0],1);
			if (lev !=0) err_message(ts[4][s][lev],curr_action);
			ts[4][s][0] = 1;
			ts[4][s][1] = curr_action;
			ts[4][s][3] = l ;		/* save l */
			break;

		case EWAIT:
			lev = ts[6][s][0];
			e = (int)check_value((int) aux_data[0],0);
			if (lev !=0) err_message(ts[6][s][lev],curr_action);
			ts[6][s][0] = 1;
			ts[6][s][1] = curr_action;
			ts[6][s][3] = e;		/* save e */
			break;

		case LNWAIT:
			lev = ts[4][s][0];
			l = (int)check_value((int) aux_data[0],1);
			if (lev !=0) err_message(ts[4][s][lev],curr_action);

			lev = os[0][l][0];
			if(lev == 0) err_message(0,curr_action);
			os[0][l][0] = 2;
			os[0][l][2] = curr_action;
			lev = os[3][l][0];
			if(lev != 0) err_message(os[3][l][lev],curr_action);
			os[3][l][0] = 1;    /* someone has the lock */

			break;

		case ENWAIT:
			e = (int)check_value((int) aux_data[0],0);
			lev = os[2][e][0];
			if(lev == 0) err_message(0,curr_action);
			os[2][e][0] = 2;
			os[2][e][2] = curr_action;
			break;

		case TRESUME:
			lev = ts[3][s][0];
			if(lev == 0) err_message(0,curr_action);
			else if (ts[3][s][3] != (int)aux_data[0]){
				err_message(ts[3][s][lev],curr_action);
				err2_message(ts[3][s][3],(int)aux_data[0]);
			}
			ts[3][s][0] = 0;	
			break;

		case LRESUME:
			lev = ts[4][s][0];
			l = (int)check_value((int)aux_data[0],1);
			if(lev == 0) err_message(0,curr_action);
			else if (ts[4][s][3] != l) {
				err_message(ts[4][s][lev],curr_action);
				err2_message(ts[4][s][3],l);
			}
			else {
				lev = os[0][l][0];
				if(lev == 0) err_message(0,(int)TLOCK);
				os[0][l][2] = TLOCK;
				os[0][l][0] = 2;
			}
			ts[4][s][0] = 0;
			lev = os[3][l][0];
			if(lev != 0) err_message(os[3][l][lev],curr_action);
			os[3][l][0] = 1;    /* someone has the lock */
			break;

		case ERESUME:
			lev = ts[6][s][0];
			e = (int)check_value((int)aux_data[0],0);
			if(lev == 0) err_message(0,curr_action);
			else if (ts[6][s][3] != e) {
				err_message(ts[6][s][lev],curr_action);
				err2_message(ts[6][s][3],e);
			}
			else {
				lev = os[2][e][0];
				if(lev == 0) err_message(0,(int)TEVENT);
				os[2][e][2] = TEVENT;
				os[2][e][0] = 2;
			}
			ts[6][s][0] = 0;	
			break;

		case LCLEAR:
			l = (int)check_value((int) aux_data[0],1);
			os[3][l][0] = 0;    /* someone is clearing the lock */

			ts[4][s][0] = 0;	
		case LTEST:
			l = (int)check_value((int)aux_data[0],1);
			lev = os[0][l][0];
			if(lev == 0) err_message(0,curr_action);
			os[0][l][2] = curr_action;
			os[0][l][0] = 2;
			break;

		case ECLEAR:
			ts[6][s][0] = 0;	
		case ETEST:
		case EPOST:
			e = (int)check_value((int)aux_data[0],0);
			lev = os[2][e][0];
			if(lev == 0) err_message(0,curr_action);
			os[2][e][2] = curr_action;
			os[2][e][0] = 2;
			break;

		case LASSIGN:
			l = (int)check_value((int)aux_data[0],1);
			lev = os[0][l][0];
			if (lev !=0) err_message(os[0][l][lev],curr_action);
			os[0][l][1] = curr_action;
			os[0][l][0] = 1;
			break;

		case EASSIGN:
			e = (int)check_value((int)aux_data[0],0);
			lev = os[2][e][0];
			if (lev !=0) err_message(os[2][e][lev],curr_action);
			os[2][e][1] = curr_action;
			os[2][e][0] = 1;
			break;

		case LRELEASE:
			l = (int)check_value((int)aux_data[0],1);
			lev = os[0][l][0];
			if (lev == 0) err_message(0,curr_action);
			else os[0][l][0] = 0;
			break;

		case ERELEASE:
			e = (int)check_value((int)aux_data[0],0);
			lev = os[2][e][0];
			if (lev == 0) err_message(0,curr_action);
			else os[2][e][0] = 0;
			break;

		case BASSIGN:
			b = (int)check_value((int)aux_data[0],2);
			lev = os[1][b][0];
			if (lev !=0) err_message(os[1][b][lev],curr_action);
			os[1][b][1] = curr_action;
			os[1][b][0] = 1;
			break;

		case BRELEASE:
			b = (int)check_value((int)aux_data[0],2);
			lev = os[1][b][0];
			if (lev == 0) err_message(0,curr_action);
			else os[1][b][0] = 0;
			break;

		case BWAIT:
			lev = ts[5][s][0];
			b = (int)check_value((int) aux_data[0],2);
			if (lev !=0) err_message(ts[5][s][lev],curr_action);
			ts[5][s][0] = 1;
			ts[5][s][1] = curr_action;
			ts[5][s][3] = b;		/* save b */
			break;

		case BNWAIT:
			b = (int)check_value((int) aux_data[0],2);
			lev = os[1][b][0];
			if(lev == 0) err_message(0,curr_action);
			os[1][b][0] = 2;
			os[1][b][2] = curr_action;
			break;

		case BRESUME:
			lev = ts[5][s][0];
			b = (int)check_value((int)aux_data[0],2);
			if(lev == 0) err_message(0,curr_action);
			else if (ts[5][s][3] != b){
				err_message(ts[5][s][lev],curr_action);
				err2_message(ts[5][s][3],b);
			}
			else {
				lev = os[1][b][0];
				if(lev == 0) err_message(0,(int)TBARRIER);
				os[1][b][2] = TBARRIER;
				os[1][b][0] = 2;
			}
			ts[5][s][0] = 0;	
			break;


		case GNWAIT:
			lev = ts[10][s][0];
			if (lev !=0) err_message(ts[10][s][lev],curr_action);
			ts[10][s][0] = 1;
			ts[10][s][1] = curr_action;
			ts[10][s][3] = (int) aux_data[0];	/* save n */
			break;


		case GNRESUME:
			lev = ts[10][s][0];
			if(lev == 0) err_message(0,curr_action);
			else if (ts[10][s][3] != (int)aux_data[0]){
				err_message(ts[10][s][lev],curr_action);
				err2_message(ts[10][s][3],(int)aux_data[0]);

			}
			ts[10][s][0] = 0;	
			break;	

		case GWAIT:
			lev = ts[11][s][0];
			if (lev !=0) err_message(ts[11][s][lev],curr_action);
			ts[11][s][0] = 1;
			ts[11][s][1] = curr_action;
			break;

		case GRESUME:
			lev = ts[11][s][0];
			if(lev == 0) err_message(0,curr_action);
			else ts[11][s][0] = 0;	
			break;


		default:	/* Must be microtasking */

			if(curr_action < GNWAIT) break; /* user */


/* get an active slot for current fray	*/
			f = 0;
			if(curr_action == MSTARTF) o=curr_id;
			else o = curr_owner;
			while (f < MAXFRAYS && fslot[f] != o) {
				f++;
			}
			i = 0;
			while (f  >= MAXFRAYS  && i < MAXFRAYS	) {
				if(fslot[i] == -1 ) {
					fslot[i]  = o; 
					f = i;
				}
				i++;
			}
			if (i >= MAXFRAYS) {
				display_message 
				("Too many active frays for checking!!\n");
				return(errflg);
			}
			break;		
	}

	switch (curr_action) {	/* check microtasking actions */

		case MSTARTF:
			lev = ts[8][s][0];
			if (lev !=0) err_message(ts[8][s][lev],curr_action);
			ts[8][s][0] = 1;
			ts[8][s][1] = curr_action;

			lev = fs[0][f][0];
			if (lev !=0) err_message(fs[0][f][lev],curr_action);
			fs[0][f][0] = 1;
			fs[0][f][1] = curr_action;
			fs[1][f][3] = 0; /* initialize cswait count (q) to 0 */
			lev = fs[2][f][0];
			if (lev !=0) err_message(fs[2][f][lev],curr_action);
			fs[2][f][0] = 1;
			fs[2][f][1] = curr_action;
			break;

		case MWAITF:
			lev = ts[8][s][0];
			if (lev == 0) err_message(0,curr_action);
			ts[8][s][0] = 2;
			ts[8][s][2] = curr_action;
			break;

		case MRESUMEF:
			lev = ts[8][s][0];
			if (lev < 2 || ts[8][s][2] != MWAITF) 
				err_message(ts[8][s][lev],curr_action);
			ts[8][s][0] = 0;

			lev = fs[0][f][0];
			if (lev == 0) err_message(0,curr_action);
			fs[0][f][0] = 0;

			lev = fs[2][f][0];
			if (lev == 0) err_message(0,curr_action);
			fs[2][f][0] = 0;


			lev = fs[1][f][0];
			if (lev !=0) {
				err_message((int)CSNWAIT,(int)CSWAIT);
				fs[1][f][0] = 0;
			}

			fslot[f] = -1;
			break;

		case CSWAIT:
			lev = ts[7][s][0];
			if (lev !=0) err_message(ts[7][s][lev],curr_action);
			ts[7][s][0] = 1;
			ts[7][s][1] = curr_action;
			ts[7][s][3] = o;

			lev = fs[1][f][0];
			if(fs[1][f][3] == 0) fs[1][f][3] = curr_cs;
			if (fs[1][f][3] != curr_cs){
				err_message(fs[1][f][lev],curr_action);
				err2_message(fs[1][f][3],curr_cs);
			}

			if (lev > 1 )  err_message(fs[1][f][lev],curr_action);
			fs[1][f][0] = 1;
			fs[1][f][1] = curr_action;
			break;

		case CSNWAIT:
			if (o == curr_id) { /* master */
				lev = ts[8][s][0];
				if (lev == 0) err_message(0,curr_action);
				else if (lev > 1  && ts[8][s][lev] == MWAITF)
					err_message(ts[8][s][lev],curr_action);
				ts[8][s][0] = 2;
				ts[8][s][2] = curr_action;
			}	
			else {	/* slave */
				lev = ts[9][s][0];
				if (lev == 0) err_message(0,curr_action);
				else if (lev > 1  && ts[9][s][lev] == SWAITW)
					err_message(ts[9][s][lev],curr_action);
				else if (ts[9][s][3] != o){
					err_message(ts[9][s][lev],curr_action);
					err2_message(ts[9][s][3],o);
				}
				ts[9][s][0] = 2;
				ts[9][s][2] = curr_action;
				ts[9][s][3] = o;
			}
			lev = fs[1][f][0];
			if ( fs[1][f][3] == 0) fs[1][f][3] = -(curr_cs+1);
			if (fs[1][f][3] != -(curr_cs+1)){
				err_message(fs[1][f][lev],curr_action);
				err2_message(fs[1][f][3],-(curr_cs+1));
			}
			lev = fs[2][f][0];
			if(lev == 0) err_message(0,curr_action);
			fs[2][f][0] = 2;
			fs[2][f][2] = CSDONE;
			
			fs[1][f][0] = 0;
			fs[1][f][3] = 0;
			break;

		case CSRESUME:
			lev = ts[7][s][0];
			if(lev == 0) err_message(0,curr_action);
		/*	else if (ts[7][s][3] != o && o > 0){
				err_message(ts[7][s][lev],curr_action);
				err2_message(ts[7][s][3],o);
			}  Can't check owner,may have changed while out of cpu*/
			ts[7][s][0] = 0;	
				
			if (o == curr_id) { /* master */
				lev = ts[8][s][0];
				if (lev == 0) err_message(0,curr_action);
				else if (lev > 1  && ts[8][s][lev] == MWAITF)
					err_message(ts[8][s][lev],curr_action);
				ts[8][s][0] = 2;
				ts[8][s][2] = TCS;
			}	
			else {	/* slave */
				lev = ts[9][s][0];
				if (lev == 0) err_message(0,curr_action);
				else if (lev > 1  && ts[9][s][lev] == SWAITW)
					err_message(ts[9][s][lev],curr_action);
			/*	else if (ts[9][s][3] != o && o >= 0 ) {
					err_message(ts[9][s][lev],curr_action);
					err2_message(ts[9][s][3],o);
				}  Can't check owner,may have changed while out of cpu*/
				ts[9][s][0] = 2;
				ts[9][s][2] = TCS;
				ts[9][s][3] = o;
			}
			break;

		case SWAITW:
			ts[9][s][0] = 0;
			break;

		case SSTARTF:
			lev = ts[9][s][0];
			if (lev !=0) err_message(ts[9][s][lev],curr_action);
			ts[9][s][0] = 1;
			ts[9][s][1] = curr_action;
			ts[9][s][3] = o;

			lev = fs[0][f][0];
			if (lev == 0) err_message(0,curr_action);
			fs[0][f][0] = 2;
			fs[0][f][2] = curr_action;

			break;
	}
	return(errflg);
}


void err_message(last_action, next_action)
	int last_action, next_action;
{
	static char lastname[17];
	static char nextname[17];
	lookup(last_action,lastname);
	lookup(next_action,nextname);
	error_count++;

	/* error_action = 1 */

	sprintf(tstr,"%d:  %s...%s \n",error_count,lastname,nextname);

	display_message (tstr);
	sprintf(tstr,"--- event#%d   process=%d;  task=%d\n",
		curr_events,curr_process,curr_id);
	display_message (tstr);
	errflg = 1;
}


void err2_message(last_value, next_value)
	int last_value, next_value;
{
	sprintf(tstr,"Was  %d  ---  Should be  %d \n",last_value,next_value);

	display_message (tstr);
}

E 1
