static char USMID[] = "@(#)loads.c	1.2 10/22/90 13:26:29 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif

#ifdef X11
#include "xexterns.h"
#ifdef X11R3
#include <X11/List.h>
#else
#include <X11/Xaw/List.h>
#endif

Widget file_command;
extern XFontStruct *font_info2;
Widget dir_command;
unsigned long event_mask;
extern void popdummy();
#endif

#if sun
#include <sys/dir.h>
#endif
#if CRAY2 || CRAY
#include <dirent.h>
#endif
#include <sys/stat.h>
#include "externvars.h"

/**********************************************************************
 * This file contains the routines to load the directory table
 * (load_directory_table)  and to load the file table (load_file_
 * table).  Both tables are displayed on the panel of the tool,
 * in menus that appear when the mouse button is pressed while
 * at the directory or file prompt.  The file menu will contain
 * those files in the current directory that begin with "trace".
 * These routines were used in the Argonne Schedule Tracing Facility.
 * 
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
void file_notify_proc();
void directory_notify_proc();
#endif

load_file_table(s)
char *s;
{
#ifdef X11
	Arg args[maxArgs];
	int columns = 1;
	static Widget file_header;
#endif

#if CRAY2 || CRAY
	struct dirent *d;
#endif
	struct stat stbuf;
	static char str[150];
#if sun
	struct direct *d;
#endif
	DIR *dp;
	int i, i2;
#ifdef sunview
	extern Panel panel;
	extern Panel_item file_choice;
#endif

	i=0;
	/* reinitialize the table */
	while (file_table[i] != NULL)
	{
		file_table[i] = NULL;
		free(file_table[i]);
#ifdef sunview
		panel_set(file_choice,PANEL_CHOICE_STRING, i,"", 0);
#endif
		i++;
	}
    
	i = 0;
	if ((dp = opendir(s)) == NULL)
	{
		display_message("ERROR: Cannot open directory .\n");
#ifndef STDERR
		msghan(7,1,NULL);
#endif
		exit();
	}
	/* load the file table */
	while ((d = readdir(dp)) != NULL && i < 127)
	{
#if sun
		if (d->d_namlen > 4 &&
#endif
#if CRAY2 || CRAY
		if (d->d_reclen > 4 &&
#endif
		    d->d_name[0] == 't' &&
		    d->d_name[1] == 'r' &&
		    d->d_name[2] == 'a' &&
		    d->d_name[3] == 'c' &&
		    d->d_name[4] == 'e') 
		{
			if (stat(d->d_name,&stbuf) == -1)
			{
				sprintf(str,"WARNING: Stat() failed on %s\n",d->d_name);
				display_message(str);
				continue;
			}
			if ((stbuf.st_mode & S_IFMT) == S_IFREG)
			{
				strcpy(str,d->d_name);
				file_table[i] = (char *) malloc(strlen(str)+1);
				if (file_table[i] == NULL)
				{
					display_message("ERROR: No memory for directory\n");
#ifndef STDERR
					msghan(6,1,"error creating directory table");
#endif
					exit();
				}
				strcpy(file_table[i],str);
			} else
			{
				continue;
			}
		} else
		{
			continue;
		}
#ifdef sunview
/* break at 32.  So all the menu fits on a screen. */
		if (((++i+1) % 32) == 0 )
		{
			file_table[i] = (char *) malloc(16);
			strcpy(file_table[i],"....more\n");
			i++;
		}
#endif
#ifdef X11
		i++;
#endif
	}
	closedir(dp);
    
#ifdef X11
	if (i == 127)
	{
		display_message("WARNING: Too many file entries\n");
	}
#endif
	file_table[i] = NULL;
    
#ifdef sunview
	/* destroy the only entry and create a new.  This is were the sunview
	* core dump occurs.   It's way down deep in the bowels of sunview. */
	panel_free(file_choice);
	file_choice = panel_create_item(panel, PANEL_CHOICE,
				    PANEL_ITEM_X,	10,
				    PANEL_ITEM_Y,	40,
				    PANEL_LABEL_X,	10,
				    PANEL_LABEL_Y,	40,
				    PANEL_CHOICE_Y,     0, 40,
				    PANEL_CHOICE_STRINGS, "", 0,
				    PANEL_LABEL_STRING,	"Trace file: ",
				    PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
				    PANEL_NOTIFY_PROC,	file_notify_proc,
				    0);
#endif
#ifdef X11
	/* here's where X11 destroys it's menu and then recreates it. */
	XtDestroyWidget(file_shell);
	XtDestroyWidget(file_choice);

	/* Create file menu popup button. */
	XtSetArg(args[0],XtNfromHoriz,trace_label);
	XtSetArg(args[1],XtNhorizDistance,0);
	XtSetArg(args[2],XtNfromVert,NULL);
	XtSetArg(args[3],XtNvertDistance,55);
	XtSetArg(args[4],XtNlabel,"                                           ");
	XtSetArg(args[5],XtNjustify,XtJustifyLeft);
	XtSetArg(args[6],XtNborderWidth,0);
	XtSetArg(args[7],XtNfont, font_info2);
	file_choice = XtCreateManagedWidget(NULL, commandWidgetClass,
						control_widget, args, 8);
	XtAddCallback(file_choice,XtNcallback,fileMenu);

	file_shell = XtCreatePopupShell("file",overrideShellWidgetClass,
    				     	frame, NULL, (Cardinal) 0);
	file_pop = XtCreateManagedWidget("menu",boxWidgetClass,file_shell,
                                    	NULL,(Cardinal) 0);



/*     This keeps button presses from being delivered to the root window */
	event_mask = ButtonPressMask;
	XtAddEventHandler(file_pop,event_mask,NULL,popdummy,NULL);



	XtSetArg(args[0],XtNborderWidth,0);
	XtSetArg(args[1],XtNlabel,"Trace Files:");
	XtSetArg(args[2],XtNforeground,white);
	XtSetArg(args[3],XtNbackground,black);
	XtSetArg(args[4],XtNfont, font_info2);
	file_header = XtCreateManagedWidget(NULL,
    		  	labelWidgetClass, file_pop, args,5);

	if( i > 32 )
		columns = 6;
	else 
		columns = 1;

	XtSetArg(args[0],XtNlist,file_table);
	XtSetArg(args[1],XtNdefaultColumns,columns);
	XtSetArg(args[2],XtNforceColumns,True);
	XtSetArg(args[3],XtNborderWidth,0);
	XtSetArg(args[4],XtNfont, font_info2);
	file_command = XtCreateManagedWidget("traces", listWidgetClass, file_pop,
		args,  5);
	XtAddCallback(file_command,XtNcallback,file_notify_proc);
	XtSetArg(args[0],XtNlabel,file_table[0]);
	XtSetValues(file_choice,args,1);
#endif

#ifdef sunview
	if (file_table[0] == NULL)
	{
		panel_set(file_choice,PANEL_CHOICE_STRING,
		  		0,"",
	  	  		PANEL_CHOICE_Y,     0, 40,
		  		PANEL_LABEL_Y,	40,
		  		0);
	} else
	{
		if ( ft_val != 31 || (ft_index == 127 ))
		{
			ft_index = 0;
		} else
		{
			ft_index = ft_index+ft_val+1;
			ft_val = 0;
		}
		for(i=0, i2=ft_index; (file_table[i2] != NULL) && (i < 32);
		    i++, i2++)
		{
			panel_set(file_choice,PANEL_CHOICE_STRING,
		  			i,file_table[i2],
		  			PANEL_CHOICE_Y,          i,40,
		  			PANEL_LABEL_Y,	40,
		  			0);
		}
	}
#endif sunview
}

#define MAXDIRLEN 80
load_directory_table()
{
#ifdef X11
	Widget directory_header;
	Arg args[10];
	int columns = 1;
#endif
#if sun
	struct direct *d;
#endif
#if CRAY2 || CRAY
	struct dirent *d;
#endif
	DIR *dp;
	int i, i2;
	struct stat stbuf;
	static char current_dir[150];
#ifdef sunview
	extern Panel_item directory_choice;
	extern Panel panel;
#endif
	static char str[150];

	ft_val = 0;		/* initialize the file table offset value
                                 * whenever you change directories. */
	i = 0;

	while (directory_table[i] != NULL)
	{
		directory_table[i] = NULL;
		free(directory_table[i]);
		i++;
	}      
    
	i = 0;
	if ((dp = opendir(".")) == NULL)
	{
		display_message("ERROR: Cannot open directory .\n");
#ifndef STDERR
		msghan(7,1,NULL);
#endif
		exit();
	}
	while ((d = readdir(dp)) != NULL && i < 127)
	{
		if (stat(d->d_name,&stbuf) == -1)
		{
			sprintf(str,"WARNING: Stat() failed on %s\n",d->d_name);
			display_message(str);
			continue;
		}
		if ((stbuf.st_mode & S_IFMT) == S_IFDIR)
		{
			strcpy(str,d->d_name);
#ifndef sunview
			if( i == 0 )
			{ 
				strcat(str, " (no change)");
			} else if( i == 1 )
			{
				strcat(str, " (parent directory)");
			}
#endif
			directory_table[i] = (char *) malloc(strlen(str)+1);
			if (directory_table[i] == NULL)
			{
				display_message("ERROR: No memory for directory\n");
#ifndef STDERR
				msghan(6,1,"allocating space for directory");
#endif
				exit();
			}
			strcpy(directory_table[i],str);
		} else
		{
			continue;
		}
#ifdef sunview
		if (((++i+1) % 32) == 0)
		{
			directory_table[i] = (char *)malloc(16);
			strcpy(directory_table[i],"...more\n");
			i++;
		}
#endif sunview
#ifdef X11
		i++;
#endif X11
	}
	closedir(dp);

	if (i >= 127)
	{
		display_message ("WARNING: Too many directory entries\n");
	}
	directory_table[i] = NULL;
    

#ifdef sunview
	strcpy(current_dir,"Directory: ");
	getwd(current_dir + 11);
	strncpy(str,current_dir,MAXDIRLEN);
	strncat(str,"                              ",MAXDIRLEN-strlen(str));
#endif

#ifdef sunview
	panel_free(directory_choice);
	directory_choice = panel_create_item(panel, PANEL_CHOICE,
					 PANEL_ITEM_X,	10,
					 PANEL_ITEM_Y,  20,
					 PANEL_CHOICE_STRINGS, "", 0,
					 PANEL_LABEL_STRING,	str,
					 PANEL_DISPLAY_LEVEL,	PANEL_NONE,
					 PANEL_NOTIFY_PROC,	directory_notify_proc,
					 0);
#endif
    
#ifdef X11
	getcwd(current_dir,150);
	XtDestroyWidget(dir_shell); 
	XtDestroyWidget(directory_choice);

	/* Create directory command button to cd around. */
	XtSetArg(args[0],XtNfromHoriz,dir_label);
	XtSetArg(args[1],XtNhorizDistance,0);
	XtSetArg(args[2],XtNfromVert,NULL);
	XtSetArg(args[3],XtNvertDistance,35);
	XtSetArg(args[4],XtNlabel,current_dir);
	XtSetArg(args[5],XtNjustify,XtJustifyLeft);
	XtSetArg(args[6],XtNborderWidth,0);
	XtSetArg(args[7],XtNfont, font_info2);
	directory_choice = XtCreateManagedWidget("label", commandWidgetClass,
					     control_widget, args, 8);
	XtAddCallback(directory_choice,XtNcallback,dirMenu);

	XtSetArg(args[0],XtNx,100);
	XtSetArg(args[1],XtNy,100);
	dir_shell = XtCreatePopupShell("directory",overrideShellWidgetClass,
			    panel,args, 2);
	dir_pop = XtCreateManagedWidget("menu",boxWidgetClass,dir_shell,
				   NULL,(Cardinal) 0);




/*     This keeps button presses from being delivered to the root window */
	event_mask = ButtonPressMask;
	XtAddEventHandler(dir_pop,event_mask,NULL,popdummy,NULL);


	XtSetArg(args[0],XtNwidth,200);
	XtSetArg(args[1],XtNlabel,"Directory Choices:");
	XtSetArg(args[2],XtNbackground,black);
	XtSetArg(args[3],XtNforeground,white);
	XtSetArg(args[4],XtNfont, font_info2);
	directory_header = XtCreateManagedWidget("Label",
		       labelWidgetClass, dir_pop, args, 5);

	if( i > 32 )
		columns = 6;
	else
		columns = 1;

	XtSetArg(args[0],XtNlist,directory_table);
	XtSetArg(args[1],XtNdefaultColumns,columns);
	XtSetArg(args[2],XtNforceColumns,True);
	XtSetArg(args[3],XtNborderWidth,0);
	XtSetArg(args[4],XtNfont, font_info2);
	dir_command = XtCreateManagedWidget("directories", listWidgetClass,
		dir_pop, args,  5);
	XtAddCallback(dir_command,XtNcallback,directory_notify_proc);
#endif

#ifdef sunview
	if (((dt_index+1) % 32) || (dt_index == 127))
	{
		dt_index = 0;
	} else
	{
		dt_index++;
	}
	for( i=0, i2=dt_index; (directory_table[i2] != NULL) && (i<32);i++,i2++)
	{
		panel_set(directory_choice,PANEL_CHOICE_STRING,
				i,directory_table[i2],
				0);
	}
#endif sunview

	load_file_table(".");
}
