static char USMID[] = "@(#)draw.c	1.1 10/16/90 11:11:28 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "externvars.h"

/***********************************************************
 * This file contains the routines to handle the drawing
 * of the various nodes of the graph, the process icons,
 * and the view box. 
 * Various types of nodes exist:
 *     solid node - task is ready to run
 *     WT node - task is waiting on a task
 *     WE node - task is waiting on an event
 *     WL node - task is waiting on a lock
 *     WB node - task is waiting on a barrier
 *     WF node - task is a master waiting on a fray
 *     CS node - task is waiting on a control structure
 *     GN node - task is waiting on guard N
 *     G  node - task is waiting on a guard
 *     ringed node - task is a master
 *     hollow node - task is completed and recovered
 * In addition, when a process is assigned to a task - that
 * task node will appear in reverse-video.
 *
 * The five types of nodes were defined in the Icon Editor 
 * as 64x64 pixrects.  The hex files were then trimmed 
 * down to 32x32.  Nodes are displayed via the raster 
 * operations from a pixrect to a pixwin.
 *
 * Five types of process icons exist:
 *	B process icon - Bound process
 * 	U process icon - Unbound process
 * 	I process icon - Idle process
 * 	S process icon - Suspended process
 * 	R process icon - Reacquired process
 * The process icons were defined in the Icon Editor as
 * 64x64 pixrects.  The visible portion of the icon is
 * 48x48.  Icons are displayed via the raster operations
 * from a pixrect to a pixwin.
 *
 * The view box is stored in a hex file as 112 pixels by
 * 60 pixels - when drawn, the visible portion of the box
 * is approximately 111 by 60.
 *
 **********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern Pixwin *pw,*pwf,*stpw;
extern int subtree;

/* read the images into the pixrect structures */
    
short im_box[] = {
#include "icons/view.box"
};    
mpr_static(box,BOXWIDTH,BOXHEIGHT,1,im_box);
short im_hollow[] = {
#include "icons/hollow.node"
};   /* task ready */
mpr_static(hollow,NODEDIM,NODEDIM,1,im_hollow);
short im_solid[] = {
#include "icons/solid.node"
};    /* completed task */
mpr_static(solid,NODEDIM,NODEDIM,1,im_solid);
short im_wait_t[] = {
#include "icons/waitt.node"
};   /* task waiting on a task */
mpr_static(wait_t,NODEDIM,NODEDIM,1,im_wait_t);
short im_wait_e[] = {
#include "icons/waite.node"
};   /* task waiting on an event */
mpr_static(wait_e,NODEDIM,NODEDIM,1,im_wait_e);
short im_wait_l[] = {
#include "icons/waitl.node"
};   /* task waiting on a lock */
mpr_static(wait_l,NODEDIM,NODEDIM,1,im_wait_l);
short im_wait_b[] = {
#include "icons/waitb.node"
};
mpr_static(wait_b,NODEDIM,NODEDIM,1,im_wait_b);
short im_wait_f[] = {
#include "icons/waitf.node"
};
mpr_static(wait_f,NODEDIM,NODEDIM,1,im_wait_f);
short im_wait_gn[] = {
#include "icons/waitgn.node"
};
mpr_static(wait_gn,NODEDIM,NODEDIM,1,im_wait_gn);
short im_wait_g[] = {
#include "icons/waitg.node"
};
mpr_static(wait_g,NODEDIM,NODEDIM,1,im_wait_g);
short im_wait_cs[] = {
#include "icons/waitcs.node"
};
mpr_static(wait_cs,NODEDIM,NODEDIM,1,im_wait_cs);
short im_master[] = {
#include "icons/master.node"
};
mpr_static(master,NODEDIM,NODEDIM,1,im_master);
short im_waitgn[] = {
#include "icons/wait_gn.tri"
};
mpr_static(waitgn,NODEDIM,NODEDIM,1,im_waitgn);
short im_waitg[] = {
#include "icons/wait_g.tri"
};
mpr_static(waitg,NODEDIM,NODEDIM,1,im_waitg);
short im_wait_w[] = {
#include "icons/wait_w.tri"
};
mpr_static(wait_w,NODEDIM,NODEDIM,1,im_wait_w);
short im_waitcs[] = {
#include "icons/wait_cs.tri"
};
mpr_static(waitcs,NODEDIM,NODEDIM,1,im_waitcs);
short im_infray[] = {
#include "icons/infray.tri"
};
mpr_static(infray,NODEDIM,NODEDIM,1,im_infray);
short im_punbind[] = {
#include "icons/punbind.icon"
};
mpr_static(punbind,PROCDIM,PROCDIM,1,im_punbind);
short im_pidle[] = {
#include "icons/pidle.icon"
};
mpr_static(pidle,PROCDIM,PROCDIM,1,im_pidle);
short im_psuspend[] = {
#include "icons/psuspnd.icon"
};
mpr_static(psuspend,PROCDIM,PROCDIM,1,im_psuspend);
short im_preacq[] = {
#include "icons/preacq.icon"
};
mpr_static(preacq,PROCDIM,PROCDIM,1,im_preacq);
short im_pbind[] = {
#include "icons/pbind.icon"
};
mpr_static(pbind,PROCDIM,PROCDIM,1,im_pbind);
short im_ch1[] = {
#include "icons/one.node"
};
mpr_static(ch1,NODEDIM,NODEDIM,1,im_ch1);
short im_ch2[] = {
#include "icons/two.node"
};
mpr_static(ch2,NODEDIM,NODEDIM,1,im_ch2);
short im_ch3[] = {
#include "icons/three.node"
};
mpr_static(ch3,NODEDIM,NODEDIM,1,im_ch3);
short im_ch4[] = {
#include "icons/four.node"
};
mpr_static(ch4,NODEDIM,NODEDIM,1,im_ch4);
short im_ch5[] = {
#include "icons/five.node"
};
mpr_static(ch5,NODEDIM,NODEDIM,1,im_ch5);
short im_bar[] = {
#include "icons/barrier.node"
};
mpr_static(bar,NODEDIM,NODEDIM,1,im_bar);

draw_view_box(x,y)
int x,y;
{
/************************************
 * draw_view_box draws the view box
 * with its center at the given x,y
 * coordinates, and erases the old
 * view box.
 ***********************************/
    int cornerx,cornery;

    if (first_box) {
	clearscreen(pwf,OVX,OVY);
	first_box = 0;
    }
    else
      pw_rop(pwf,oldx,oldy,BOXWIDTH,BOXHEIGHT,
	     PIX_SRC ^ PIX_DST,&box,0,0);

    if (x <= 55) {
	cornerx = 0;
    } else if (x >= (384 - 50)) {
	cornerx = 384 - 100;
    } else {
	cornerx = (x - 55);
    }
    if (y <= 30) {
	cornery = 0;
    } else if (y >= (283 - 30)) {
	cornery = 283 - 60;
    } else {
	cornery = (y - 30);
    }
    pw_rop(pwf,cornerx,cornery,BOXWIDTH,BOXHEIGHT,
	   PIX_SRC ^ PIX_DST,&box,0,0);
    oldx = cornerx;
    oldy = cornery;
}


show_process()
{
/**********************************
 * show_process indicates that a 
 * process has been assigned to the
 * task by displaying the node in
 * reverse-video.  
 **********************************/

    int x,y;  /* the x and y coords of
             the task in the primary canvas*/
    int ovx, ovy; /* coords in the overview */
    int sx,sy;	  /* coords in the subtree canvas */

    x = tasks[curr_id]->x;
    y = tasks[curr_id]->y;
    ovx = (int)(x * SCALEDOWN);
    ovy = (int)(y * SCALEDOWN);
    sx = tasks[curr_id]->stx;
    sy = tasks[curr_id]->sty;

    pw_rop(pw, x, y, REVDIM, REVDIM, PIX_NOT(PIX_DST),NULL,0,0);
    pw_rop(pwf, ovx, ovy, OVSQUARE, OVSQUARE, PIX_NOT(PIX_DST),NULL,0,0);
    if INSUBTREE
      pw_rop(stpw,sx,sy,REVDIM,REVDIM,PIX_NOT(PIX_DST),NULL,0,0);
}


draw_task()
{
/***************************************
 * draw_task draws the node for the task
 * using the appropriate node depending
 * on the state of the task.
 **************************************/

    int x, y;		/* coordinates in the primary canvas */
    int ovx, ovy;	/* coordinates in the overview canvas */
    int sx,sy;		/* coordinates in the subtree canvas */
    char str[10];
#ifdef CANDEBUG
    Notify_error notify_errno=NOTIFY_OK; /* sunview global errno */
#endif

    x = tasks[curr_id]->x;
    y = tasks[curr_id]->y;
    ovx = (int)(x * SCALEDOWN);
    ovy = (int)(y * SCALEDOWN);
    sx = tasks[curr_id]->stx;
    sy = tasks[curr_id]->sty;
    pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);
    pw_rop(pwf,ovx+1,ovy+1,3,3,PIX_SET,NULL,0,0);
    switch (tasks[curr_id]->state) {
      case 0 :   /* has resumed - now ready to run */
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&solid,0,0);
#ifdef CANDEBUG
	printf("notify_errno = %d\n", notify_errno);
	if( notify_errno != NOTIFY_OK )
		notify_perror();
#endif
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&solid,0,0);
	break;
      case TWAIT : 
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_t,0,0);
	if INSUBTREE  
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_t,0,0);
	break;
      case EWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_e,0,0);
	if INSUBTREE  
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_e,0,0);
	break;
      case LWAIT : 
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_l,0,0);
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_l,0,0);
	break;
      case BWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_b,0,0);
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_b,0,0);
	break;
      case GWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_g,0,0);
	if INSUBTREE  
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_g,0,0);
	break;
      case GNWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_gn,0,0);
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_gn,0,0);
	break;
      case CSWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_cs,0,0);
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_cs,0,0);
	break;
      case -1:
      case RECOVER : 
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&hollow,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&hollow,0,0);
	break;
      case MSTARTF :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&solid,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&solid,0,0);
	break;
      case MWAITF :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_f,0,0);
	if INSUBTREE 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_f,0,0);
	break;
    }
    if (tasks[curr_id]->slave == -1)   { /* is a master */
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC | PIX_DST,&master,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC | PIX_DST,&master,0,0);
    }
    if (tasks[curr_id]->process != -1)      /* is bound */
      show_process();
    sprintf(str,"%d",curr_id);
    pw_text(pw,x+32,y+20,PIX_SRC,0,str);
    if INSUBTREE
      pw_text(stpw,sx+32,sy+20,PIX_SRC,0,str);
}

draw_slave()
{
/******************************************
 * draw_slave draws the node for the slave
 * using the appropriate node depending
 * on the state of the slave.
 *****************************************/

    int x, y;		/* coordinates in the primary canvas */
    int ovx, ovy;	/* coordinates in the overview canvas */
    int sx,sy;		/* coordinates in the subtree canvas */
    char str[10];

    x = tasks[curr_id]->x;
    y = tasks[curr_id]->y;
    ovx = (int)(x * SCALEDOWN);
    ovy = (int)(y * SCALEDOWN);
    sx = tasks[curr_id]->stx;
    sy = tasks[curr_id]->sty;
    pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);
    pw_rop(pwf,ovx+1,ovy+1,3,3,PIX_SET,NULL,0,0);
    switch (tasks[curr_id]->state) {
      case 0 : /* is ready to run */
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	break;
      case GNWAIT :  
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&waitgn,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitgn,0,0);
	break;
      case GWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&waitg,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitg,0,0);
	break;
      case CSWAIT :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&waitcs,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitcs,0,0);
	break;
      case SSTARTF  :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	break;
      case SWAITW :
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&wait_w,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_w,0,0);
	break;
      default:
	break;
    }
    if (tasks[curr_id]->process != -1)      /* is bound */
      show_process();
    sprintf(str,"%d",curr_id);
    pw_text(pw,x+32,y+20,PIX_SRC,0,str);
    if INSUBTREE
      pw_text(stpw,sx+32,sy+20,PIX_SRC,0,str);
}

	  
check_ud()
{
/***********************************************
 * check_ud checks to see if the action number 
 * corresponds to one of the user-defined
 * significant action number. This is done 
 * separately because the argument to case 
 * must be a constant and the user-defined
 * significant action numbers are not constants.
 ***********************************************/
    int x,y,sx,sy;

    x = tasks[curr_id]->x;
    y = tasks[curr_id]->y;
    sx = tasks[curr_id]->stx;
    sy = tasks[curr_id]->sty;

    if (tasks[curr_id]->state == choice[1]) {
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&ch1,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch1,0,0);
    }
    else if (tasks[curr_id]->state == choice[2]) {
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&ch2,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch2,0,0);
    }
    else if (tasks[curr_id]->state == choice[3]) {
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&ch3,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch3,0,0);
    }
    else if (tasks[curr_id]->state == choice[4]) {
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&ch4,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch4,0,0);
    }
    else if (tasks[curr_id]->state == choice[5]) {
	pw_rop(pw,x,y,NODEDIM,NODEDIM,PIX_SRC,&ch5,0,0);
	if INSUBTREE
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch5,0,0);
    }
}
	      
connect_tasks()
{
/****************************************
 * connect-tasks connects current  parent
 * task to current child task.
 ***************************************/

    int px,py,cx,cy;  
    int spx,spy,sx,sy;
    int parent;

    parent = tasks[curr_id]->parent;
    if (tasks[parent] == NULL) return(1);
    spx = tasks[parent]->stx;
    spy = tasks[parent]->sty;
    sx = tasks[curr_id]->stx;
    sy = tasks[curr_id]->sty;
    if INSUBTREE
      pw_vector(stpw,spx + XOFFSET, spy + BOTOFFSET,
		sx + XOFFSET, sy + TOPOFFSET,PIX_SET,1);
    px = tasks[parent]->x + XOFFSET;
    py = tasks[parent]->y + BOTOFFSET;
    cx = tasks[curr_id]->x + XOFFSET;
    cy = tasks[curr_id]->y + TOPOFFSET;
    pw_vector(pw,px,py,cx,cy,PIX_SET,1);
    return(0);
}


draw_process()
{
/*****************************************
 * draw_process draws or updates the 
 * process icon for the current process.
 * Process icons are displayed only in
 * the Primary Canvas - and always on 
 * the first row.
 ****************************************/

    int x,y,ovx,ovy;
    char str[10];

    x = procs[curr_process].x;
    y = procs[curr_process].y;
    ovx = (x * SCALEDOWN);
    ovy = (y * SCALEDOWN);  /* always zero */
      
    switch(procs[curr_process].state)  {
      case 0 :  /* process is idle */
	pw_rop(pw,x,y,PROCDIM+36,NODEDIM,PIX_CLR,NULL,0,0);     /* clear old task id */
	pw_rop(pw,x,y,PROCDIM,PROCDIM,PIX_SRC,&pidle,0,0);
	pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);  /* clear area */
	pw_rop(pwf,ovx+2,ovy,2,OVSQUARE,PIX_SET,NULL,0,0);       /* draw vertical line */
	break;
      case 1 : /* process is suspended */
	pw_rop(pw,x,y,PROCDIM+36,NODEDIM,PIX_CLR,NULL,0,0);     /* clear old task id */
	pw_rop(pw,x,y,PROCDIM,PROCDIM,PIX_SRC,&psuspend,0,0);
	pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);  /* clear area */
	pw_rop(pwf,ovx+2,ovy,2,OVSQUARE,PIX_SET,NULL,0,0);       /* draw vertical line */
	break;
      case 2 : /* process is reaquired */
	pw_rop(pw,x,y,PROCDIM+36,NODEDIM,PIX_CLR,NULL,0,0);     /* clear old task id */
	pw_rop(pw,x,y,PROCDIM,PROCDIM,PIX_SRC,&preacq,0,0);
	pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);  /* clear area */
	pw_rop(pwf,ovx+2,ovy,2,OVSQUARE,PIX_SET,NULL,0,0);       /* draw vertical line */
	break;
      case 3 : /* process is bound */
	pw_rop(pw,x,y,PROCDIM+36,NODEDIM,PIX_CLR,NULL,0,0);     /* clear old task id */
	pw_rop(pw,x,y,PROCDIM,PROCDIM,PIX_SRC,&pbind,0,0);
	pw_rop(pw,x,y,48,48,PIX_NOT(PIX_DST),NULL,0,0);
	sprintf(str,"<-- %d",curr_id);
	pw_text(pw,x+50,y+24,PIX_SCR,0,str);
	pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_SET,NULL,0,0);  /* fill area */
	pw_rop(pwf,ovx+2,ovy,2,OVSQUARE,PIX_CLR,NULL,0,0);       /* draw vertical line */
	break;
      case 4 : /* process is unbound */
	pw_rop(pw,x,y,PROCDIM+36,NODEDIM,PIX_CLR,NULL,0,0);     /* clear old task id */
	pw_rop(pw,x,y,PROCDIM,PROCDIM,PIX_SRC,&punbind,0,0);
	pw_rop(pwf,ovx,ovy,OVSQUARE,OVSQUARE,PIX_CLR,NULL,0,0);  /* clear area */
	pw_rop(pwf,ovx+2,ovy,2,OVSQUARE,PIX_SET,NULL,0,0);       /* draw vertical line */
	break;
      default : display_message("Unknown process state\n");
    }
#ifdef CTSSTRACE
    sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
    sprintf(str,"proc %d",procs[curr_process].pid);
#endif
    pw_text(pw,x,y+60,PIX_SCR,0,str);
}


/* 
   Designed to draw all the state children given the x,y coordinate of 
   a selected root node.
*/

subtree_init()
{
    int child,i,j;

    clearscreen(stpw, 3800, 2800);

    for(i=0; i < 74; i++) {
	for(j=0; j < 54; j++) {
	  subtree_screen[i][j].children.x = 0;
	  subtree_screen[i][j].children.y = 0;
	  subtree_screen[i][j].position.x = 0;
	  subtree_screen[i][j].position.y = 0;
	  subtree_screen[i][j].id = 0;
	  subtree_screen[i][j].pass = 0;
	  subtree_screen[i][j].constraint = 0;
	  subtree_screen[i][j].working = 0;
      }
    }

    subtree_screen[37][0].id = leftid;
    subtree_screen[37][0].constraint = 5;
    subtree_draw(leftid);
    subtree_draw_children(leftid,tasks[leftid]->children);
}

subtree_draw_children(parent_id,pointer_to)
     int parent_id;
     struct child_struct *pointer_to;
{
    int nil,child;
    struct child_struct *next_child;

    if (pointer_to == NULL)
      return(0);
    else {
	child = pointer_to->child_id;
	next_child = pointer_to->next;
	
	subtree_draw(child);
	nil = subtree_draw_children(child, tasks[child]->children);
	return(subtree_draw_children(parent_id,next_child));
    }
}

subtree_draw(task_id)
     int task_id;
{
    subtree_curr_id = task_id;

    subtree_assign_xy(); /* put the calculated subscreen x,y in structure in stx, sty */
    subtree_draw_task(); /* draw the task on the subscreen */
    subtree_connect();   /* connect the the parent/child */
}    

subtree_draw_task()
{
/***************************************
 * subtree_draw_task draws the node for 
 * the task using the appropriate node
 * type depending on the state of the 
 * task.
 **************************************/

    int sx,sy;		/* coordinates in the subtree canvas */
    char str[10];

    sx = tasks[subtree_curr_id]->stx;
    sy = tasks[subtree_curr_id]->sty;
    switch (tasks[subtree_curr_id]->state) {
      case 0 :
	if (tasks[subtree_curr_id]->slave >= 0)
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	else
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&solid,0,0);
	break;
      case TWAIT : 
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_t,0,0);
	break;
      case EWAIT :
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_e,0,0);
	break;
      case LWAIT : 
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_l,0,0);
	break;
      case BWAIT : 
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_b,0,0);
	break;
      case MWAITF :
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_f,0,0);
	break;
      case MRESUMEF :
      case RECOVER : 
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&hollow,0,0);
	break;
      case GNWAIT :  
	if (tasks[subtree_curr_id]->slave >= 0) 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitgn,0,0);
	else 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_gn,0,0);
	break;
      case GWAIT :
	if (tasks[subtree_curr_id]->slave >= 0) 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitg,0,0);
	else 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_g,0,0);
	break;
      case CSWAIT :
	if (tasks[subtree_curr_id]->slave >= 0) 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&waitcs,0,0);
	else 
	  pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_cs,0,0);
	break;
      case SWAITW :
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&wait_w,0,0);
	break;
      case SSTARTF  :
	pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&infray,0,0);
	break;
      default :
	subtree_check_ud();  
	break;
    }
    if (tasks[subtree_curr_id]->slave == -1)  /* is a master */
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC | PIX_DST,&master,0,0);
    if (tasks[subtree_curr_id]->process != -1)      /* is bound */
      subtree_show_process();
    sprintf(str,"%d",subtree_curr_id);
    pw_text(stpw,sx+32,sy+20,PIX_SRC,0,str);
}    

subtree_check_ud()
{
/******************************************
 * subtree_check_ud checks to see if the 
 * state corresponds to a user-defined
 * significant action number
 *****************************************/
    int ch, sx, sy;

    ch = tasks[subtree_curr_id]->state;
    sx = tasks[subtree_curr_id]->stx;
    sy = tasks[subtree_curr_id]->sty;

    if (ch == choice[1]) 
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch1,0,0);
    if (ch == choice[2])
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch2,0,0);
    if (ch == choice[3])
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch3,0,0);
    if (ch == choice[4])
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch4,0,0);
    if (ch == choice[5])
      pw_rop(stpw,sx,sy,NODEDIM,NODEDIM,PIX_SRC,&ch5,0,0);
}




subtree_show_process()
{
/****************************************
 * subtree_show_process indicates that a 
 * process has been assigned to the
 * task by displaying the node in
 * reverse-video on the subtree canvas.
 ***************************************/
    int sx,sy;	  /* coords in the subtree canvas */

    sx = tasks[subtree_curr_id]->stx;
    sy = tasks[subtree_curr_id]->sty;

    pw_rop(stpw,sx,sy,REVDIM,REVDIM,PIX_NOT(PIX_DST),NULL,0,0);

}

	      
subtree_connect()
{
/********************************************
 * subtree_connect connects current parent
 * task to current child task in the subtree
 * canvas.
 *******************************************/
    int spx,spy,sx,sy;
    int parent_id;

    parent_id = tasks[subtree_curr_id]->parent;
    if (subtree_curr_id == leftid) return(1);
    spx = tasks[parent_id]->stx;
    spy = tasks[parent_id]->sty;
    sx = tasks[subtree_curr_id]->stx;
    sy = tasks[subtree_curr_id]->sty;
    pw_vector(stpw,spx + XOFFSET, spy + BOTOFFSET,
	      sx + XOFFSET, sy + TOPOFFSET,PIX_SET,1);
    return(0);
}
#endif
