static char USMID[] = "@(#)dotask.c	1.1 10/16/90 11:11:26 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>
#endif
#ifdef X11
#include "xexterns.h"
#endif
#include "externvars.h"
#include "log_entry.h"

/**********************************************************
 * This file contains the routines to allocate space for 
 * a task and process the task.
 *
 *********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Panel_item process_count,task_count;
extern Scrollbar pch_bar, pcv_bar;
#endif

#ifdef X11
extern caddr_t process_count, task_count;
#endif
extern int subtree;
extern first_time;


add_task()
{
/************************************************************
 * add_task adds the current task to the task structures.  
 * the task information is drawn from the global variables 
 * where they were placed upon input.
 ***********************************************************/
    struct child_struct *temp;
    int parent;
    char str[20];

    tasks[curr_id] = (struct task_struct *)malloc(sizeof(struct task_struct));
#ifdef CTSSTRACE
    parent = aux_data[0];
    tasks[curr_id]->parent = aux_data[0];
#endif
#ifdef CRAYTRACE
    parent = log_entry.lo_user;
    tasks[curr_id]->parent = log_entry.lo_user;
#endif
    tasks[curr_id]->state = 0;
    tasks[curr_id]->process = -1;  /* initially not bound */
    tasks[curr_id]->aux_item = 0;
    /* put in first action number, set actions and last */
    tasks[curr_id]->slave = -2;   
    tasks[curr_id]->actions = (struct act_struct *)malloc(sizeof(struct act_struct));
    tasks[curr_id]->actions->action = START;
    tasks[curr_id]->act_length = 1;
    tasks[curr_id]->last = tasks[curr_id]->actions;
    tasks[curr_id]->actions->next = NULL;
    tasks[curr_id]->children = NULL;

    assign_xy();

    tasks[curr_id]->stx = 0;  /* set subtree coords to zero */
    tasks[curr_id]->sty = 0;
    if (curr_id == 1) return(0);  /* task 1 has no parent */
    /* subtree can't be selected for the first task already */

    if ((subtree) && ((tasks[parent]->stx != 0) || (tasks[parent]->sty != 0))) {
	/* then we are doing a subtree and this task is a descendant */
	subtree_curr_id = curr_id;
	subtree_assign_xy();   /* assign subtree coordinates */
    }

    if (tasks[parent] != NULL) {
	/* add child to front of parent's linked list of children */
	temp = (struct child_struct *)malloc(sizeof(struct child_struct));
	temp->child_id = curr_id;
	temp->next = tasks[parent]->children;
	tasks[parent]->children = temp;
    }
    else  { /* parent does not exist */
      tasks[curr_id]->parent = -1;
      sprintf(str,"task %d has an unknown parent",curr_id);
      display_message(str);
    }
    return(0);
}

add_first()
{
/************************************************************
 * add_first adds the first task to the task structures.  
 ***********************************************************/
    struct child_struct *temp;
    char str[20];

    tasks[1] = (struct task_struct *)malloc(sizeof(struct task_struct));
    tasks[1]->state = 0;
    tasks[1]->process = -1;  /* initially not bound */
    tasks[1]->parent = 0;    /* set to dummy 0 */
    tasks[1]->aux_item = 0;
    /* put in first action number, set actions and last */
    tasks[1]->slave = -2;   
    tasks[1]->actions = (struct act_struct *)malloc(sizeof(struct act_struct));
#ifdef CTSSTRACE
    tasks[1]->actions->action = LIGHT;
#endif
#ifdef CRAYTRACE
    tasks[1]->actions->action = 0;
#endif
    tasks[1]->act_length = 1;
    tasks[1]->last = tasks[1]->actions;
    tasks[1]->actions->next = NULL;
    tasks[1]->children = NULL;
    tasks[1]->x = 1875;
    tasks[1]->y = 50;
    tasks[1]->process = 0;
#ifdef sunview
    /* I didn't port this to X11.  Since I reposition everything during 
     * initialization. */
    scrollbar_scroll_to(pch_bar,1400);
    scrollbar_scroll_to(pcv_bar,0);
#endif
    tasks[1]->stx = 0;  /* set subtree coords to zero */
    tasks[1]->sty = 0;

    tasks[0] = (struct task_struct *)malloc(sizeof(struct task_struct));
    tasks[0]->state = 0;
    tasks[0]->process = -1;  /* initially not bound */
    tasks[0]->parent = 0;    /* set to dummy 0 */
    tasks[0]->aux_item = 0;
    /* put in first action number, set actions and last */
    tasks[0]->slave = -2;   
    tasks[0]->actions = NULL;
    tasks[0]->act_length = 0;
    tasks[0]->last = NULL;
    tasks[0]->children = NULL;
    tasks[0]->x = 0;
    tasks[0]->y = 0;
    tasks[0]->process = 0;
    tasks[0]->stx = 0;  /* set subtree coords to zero */
    tasks[0]->sty = 0;
    return(0); 
}

add_action()
{
/****************************************************
 * add_action adds the action number to the linked
 * list of action numbers for the appropriate task.
 * If the list already contains five action numbers,
 * the four most-recent are kept and the new number
 * is added.
 ***************************************************/
    struct act_struct *temp1, *temp2;
    
    temp1 = (struct act_struct *)malloc(sizeof(struct act_struct));
    temp1->action = curr_action;
    temp1->next = NULL;
    tasks[curr_id]->last->next = temp1;
    tasks[curr_id]->last = temp1;
    if (tasks[curr_id]->act_length < SAVEACTIONS)  /* not yet full length */
      tasks[curr_id]->act_length++;
    else {    
	temp2 = tasks[curr_id]->actions;
	tasks[curr_id]->actions = tasks[curr_id]->actions->next;
	free(temp2);
    }
}

process_task()
{
/**************************************************************
 * process_task is called after the information is read off 
 * of the socket.  The relevant information has been placed in
 * global variables and will be used appropriately.  The funtion
 * returns 0 if the action was significant - else returns 1.
 *************************************************************/
    char str[30];

    if ( curr_id != 0 )
    	if (tasks[curr_id] != NULL)
		add_action();
    switch (curr_action) {
    case LIGHT: 	case START:
    case COMPLETED: 	case RECOVER:
    case BIND: 		case UNBIND:
	task_actions_switch();
	break;
    case REQUEST:
    case ACQUIRE:
    case IDLE:
    case SUSPEND:
    case RELEASE:
    case REACQUIRE:
#ifdef CRAYTRACE
    case REQUEST_NA:
    case SUSPEND_NA:
    case RELEASE_NA:
#endif
	process_switch();
	break;
    case TWAIT: 	case LWAIT:
    case EWAIT: 	case TNWAIT:
    case LNWAIT: 	case ENWAIT:
    case TRESUME: 	case LRESUME:
    case ERESUME: 	case BRELEASE:
    case BWAIT: 	case BNWAIT:
	wait_switch();
	break;
    case GNWAIT: 	case GNRESUME:
    case GWAIT: 	case GRESUME:
    case SINIT: 	case MSTARTF:
    case MWAITF: 	case MRESUMEF:
    case CSWAIT: 	case CSNWAIT:
    case CSRESUME: 	case SWAITW:
    case SSTARTF: 	case SEXIT:
	micro_task_switch();
	break;
#ifdef CTSSTRACE
    case LOST:
	display_message("Logged events lost - view is invalid\n");
#endif
    default:	/* check if user-defined */
      if ((curr_action == choice[1]) ||
	  (curr_action == choice[2]) ||
	  (curr_action == choice[3]) ||
	  (curr_action == choice[4]) ||
	  (curr_action == choice[5]))  {
	  tasks[curr_id]->state = curr_action;
	  draw_task();
      }
    }
    return(0);
}

#ifdef X11
int bind_FLG = 1;		/* this has no bearing for sunview but ... */
#endif X11
	
task_actions_switch()
{
/*******************************************
 * task_actions_switch handles task actions
 * such as Light, Start, Complete, Recover,
 ******************************************/
    char str[30];

    switch (curr_action) {
      case LIGHT :
	curr_id = 1;
	add_first();
	draw_task();
	procs[0].task = 1;
	procs[0].state = 3;	/* First process is bound to first task */
	draw_process();
	curr_tasks++;
	sprintf(str,"Number of  Tasks: %d",curr_tasks);
#ifdef sunview
	panel_set(task_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	XClearArea(control_display,control_win,
		TASKSX+100,TASKSY-10,200,12,True);
	XDrawString(control_display,control_win,control_gc,TASKSX,TASKSY,
		str, strlen(str));
#endif
	curr_procs++;
	sprintf(str,"Active Processes: %d",curr_procs);
#ifdef sunview
	panel_set(process_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	XClearArea(control_display,control_win,
		ACTIVEX+100,ACTIVEY-10,200,12,True);
	XDrawString(control_display,control_win,control_gc,ACTIVEX,ACTIVEY,
		str, strlen(str));
#endif
	break;
      case START : 
#ifdef CRAYTRACE
	/*
	 * for CRAY traces, we have no LIGHT function, but there should
	 * be a dummy START on task 0 which will contain its proc #.
	 */
	if (first_time) {
		first_time = 0;
		curr_id = 1;
		curr_process = 0;
		add_first();
		draw_task();
		procs[0].task = 1;
		procs[0].state = 3;
		procs[0].pid = log_entry.lo_user;
		draw_process();
		curr_tasks = 1;
		sprintf(str,"Number of  Tasks: %d",curr_tasks);
#ifdef sunview
		panel_set(task_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
		XClearArea(control_display,control_win,
			TASKSX+100,TASKSY-10,200,12,True);
		XDrawString(control_display,control_win,control_gc,
			TASKSX,TASKSY, str, strlen(str));
#endif
		curr_procs = 1;
		sprintf(str,"Active Processes: %d",curr_procs);
#ifdef sunview
		panel_set(process_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
		XClearArea(control_display,control_win,
			ACTIVEX+100,ACTIVEY-10,200,12,True);
		XDrawString(control_display,control_win,control_gc,
			ACTIVEX,ACTIVEY, str, strlen(str));
#endif
		break;
	}
#endif
	if (add_task() == -1) {
		break;
	}
	draw_task();
	connect_tasks();
	curr_tasks++;
	sprintf(str,"Number of  Tasks: %d",curr_tasks);
#ifdef sunview
	panel_set(task_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	XClearArea(control_display,control_win,
		TASKSX+100,TASKSY-10,200,12,True);
	XDrawString(control_display,control_win,control_gc,TASKSX,TASKSY,
		str, strlen(str));
#endif
	break;
      case BIND :
	if (tasks[curr_id] == NULL) return(1);
	curr_procs++;
	tasks[curr_id]->process = curr_process;
#ifdef X11
	bind_FLG = 1;
#endif X11
	show_process();
	procs[curr_process].task = curr_id;
	procs[curr_process].state = 3;
	draw_process();
	break;
      case UNBIND :
	if (tasks[curr_id] == NULL) return(1);
	curr_procs--;
	tasks[curr_id]->process = -1;
#ifdef X11
	bind_FLG = 0;
#endif X11
	show_process();
	procs[curr_process].task = -1;   /* now no task id */
	procs[curr_process].state = 4;
	draw_process();
	break;
     case COMPLETED :
#ifdef CTSSTRACE
	curr_id = procs[curr_process].task;
#endif
	curr_procs--;
	tasks[curr_id]->process = -1;
	tasks[curr_id]->state = -1;
#ifdef X11
	bind_FLG = 0;
#endif X11
	show_process();
	procs[curr_process].task = -1;   /* now no task id */
	procs[curr_process].state = 4;
	draw_process();
#ifdef CTSSTRACE
	break;
#endif
	/* note the fall-thru of the COMPLETED case into the RECOVER
	 * case for CRAY traces */
      case RECOVER : 
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = RECOVER;
	draw_task();
	break;
    }
}

process_switch()
{
/*********************************************************
 * process_switch handles the process actions such as
 * Acquire, Idle, Suspend, Reacquire, Bind, and Unbind.
 ********************************************************/

    switch (curr_action) {
      case ACQUIRE :
	procs[curr_process].state = 4;   /* now acquired but unbound */
	draw_process();
	break;
      case IDLE :
	procs[curr_process].state = 0;
	draw_process();
	break;
      case SUSPEND :
	procs[curr_process].state = 1;
	draw_process();
	break;
      case REACQUIRE :
	procs[curr_process].state = 2;
	draw_process();
	break;
      default:
	break;    /* bind and unbind are in task_actions */
    }
}

wait_switch()
{
/***************************************************************
 * wait_switch handles waiting events such as Wait on a
 * Task/Lock/Event/Barrier, No Wait on a Task/Lock/Event/Barrier
 * and Resume after a Task/Lock/Event/Barrier.
 **************************************************************/

    switch (curr_action) {
      case TWAIT :
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = TWAIT;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	draw_task();
	break;
      case EWAIT :
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = EWAIT;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	draw_task();
	break;
      case LWAIT :
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = LWAIT;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	draw_task();
	break;
      case BWAIT :
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = BWAIT;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	draw_task();
	break;
      case TNWAIT :
      case ENWAIT :
      case LNWAIT :
      case BNWAIT :
	if (tasks[curr_id] == NULL) return (1);
	break;
      case TRESUME :
      case ERESUME :
      case LRESUME :
      case BRESUME :
	if (tasks[curr_id] == NULL) return(1);
	tasks[curr_id]->state = 0; 	/* to indicate resume */
	tasks[curr_id]->aux_item = 0;
	draw_task();
	break;
    }
}

micro_task_switch()
{
/**********************************************************
 * micro_task_switch handles the significant micro-tasking
 * events.
 *********************************************************/

    switch (curr_action) {
      case GNWAIT :
	tasks[curr_id]->state = GNWAIT;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	if (tasks[curr_id]->slave >= 0)  /* is slave */
	  draw_slave();
	else 
	  draw_task();
	break;
      case GNRESUME :
	tasks[curr_id]->state = 0;
	tasks[curr_id]->aux_item = (int)aux_data[0];
	if (tasks[curr_id]->slave >= 0)  /* is slave */
	  draw_slave();
	else 
	  draw_task();
	break;
      case GWAIT :
	tasks[curr_id]->state = GWAIT;
	if (tasks[curr_id]->slave >= 0)  /* is slave */
	  draw_slave();
	else 
	  draw_task();
	break;
      case GRESUME :
	tasks[curr_id]->state = 0;
	if (tasks[curr_id]->slave >= 0)  /* is slave */
	  draw_slave();
	else 
	  draw_task();
	break;
      case MSTARTF :
	tasks[curr_id]->state = MSTARTF;
	tasks[curr_id]->slave = -1;
	draw_task();
	break;
      case MWAITF :
	tasks[curr_id]->state = MWAITF;
	tasks[curr_id]->slave = -1;
	draw_task();
	break;
      case MRESUMEF :
	tasks[curr_id]->state = 0;
	tasks[curr_id]->slave = -2;
	draw_task();
	break;
      case CSWAIT :
	tasks[curr_id]->state = CSWAIT;
	if (tasks[curr_id]->slave >= 0 ) {
	    tasks[curr_id]->slave = (int)aux_data[0];
	    draw_slave();
	}
	else 
	  draw_task();
	break;
      case CSRESUME :
	tasks[curr_id]->state = 0;
	if (tasks[curr_id]->slave >= 0 ) {
	    tasks[curr_id]->slave = (int)aux_data[0];
	    draw_slave();
	}
	else 
	  draw_task();
	break;
      case SWAITW :   /* now you know that it is a slave */
	tasks[curr_id]->state = SWAITW;
	tasks[curr_id]->slave = 0;
	tasks[curr_id]->slave = (int)aux_data[0];
	draw_slave();
	break;
      case SSTARTF :
	tasks[curr_id]->state = SSTARTF;
	tasks[curr_id]->slave = 0;
	tasks[curr_id]->slave = (int)aux_data[0];
	draw_slave();
	break;
      default :
	break;
    }
}
