h34199
s 00707/00000/00000
d D 1.1 90/10/16 11:11:17 werner 1 0
c date and time created 90/10/16 11:11:17 by werner
e
u
U
t
T
I 1

static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/scrollbar.h>
#endif
#ifdef X11
#include "xexterns.h"
#endif
#include "externvars.h"

/************************************************************
 * This file contains the routines to determine the position
 * of a new task in the primary canvas (assign_xy) and in 
 * the subtree canvas (subtree_assign_xy).
 * The coordinates for the overview
 * canvas are calculated from the coordinates for the 
 * primary canvas.
 *
 ***********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Scrollbar pch_bar, pcv_bar, stv_bar, sth_bar;
#endif
 
assign_xy()
{
/***************************************
 * This routine calculates the x,y 
 * coords of the current task, based on
 * the x,y coords of the parent task
 **************************************/
    
	int parentid;
	int x,y;   /* x,y coords of parent */
	int newx, newy, realtoworkx(), realtoworky();
	struct x_y *original, *typezero(), *typeone();

	parentid = tasks[curr_id]->parent;
	x = tasks[parentid]->x;
	y = tasks[parentid]->y;
	newx = realtoworkx(x);
	newy = realtoworky(y);
	if (newx == 0)
	{
		original = typezero(&(screen[makepos(newx)][newy]));
	} else
	{
		original = typeone (&(screen[makepos(newx)][newy]));
	}
	translate(original);   /* translate to pixels and assign */
}


int realtoworkx(sunx)		/* Translate from sun to rows,columns */
int sunx;
{
	int x;

	x = (sunx - 1875) / PCSQUARE;
	return(x);
}

int realtoworky(suny)		/* Translate from sun to rows,columns */
int suny;
{
	int y;

	y = (suny / PCSQUARE) - 1;	/* Offset by one row to allow room
				   	for process icons. */
	return(y);
}

struct x_y *typeone(parent)	/* Handle off center case  */
struct status *parent;
{
	struct x_y *temp;
	int child, xc, yc, x, y, newx, newy, tkn;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	xc = (parent->children).x;
	yc = (parent->children).y;
	x  = (parent->position).x;
	y  = (parent->position).y;
      

	if (child = ischildren(parent))  /* if children, offset by child  */
	{
		if ( x < 0)
		{
			newx = xc - 1;
		} else
		{
			newx = xc + 1;
		}
		newy = yc;
	} else 			/* if none, offset by position */
	{
		newx = x;
		newy = y + 1;
	}

	tkn = taken(newx,newy);

	while (tkn == 1)
	{
		newy = newy + 1;
		tkn = taken(newx, newy);
	}

	updateparent(x,y,newx,newy);     /* position, children */
	updatestatus(newx,newy,0,0,0);  /* position children constraint */

	temp->x = newx;
	temp->y = newy;

	return(temp);
}

updatestatus(x,y,xc,yc,cons) /* Update a screen position */
int x,y,xc,yc,cons;
{
	int realx;

	realx = makepos(x);

	(((screen[realx][y]).children).x) = xc;
	(((screen[realx][y]).children).y) = yc;
    
	(((screen[realx][y]).position).x) = x;
	(((screen[realx][y]).position).y) = y;

	screen[realx][y].id = curr_id;
	((screen[realx][y]).constraint) = cons;

	return;
} 
     


updateparent(x,y,xc,yc)		/* update a parent with child */
int x,y,xc,yc;
{
	x = makepos(x);

	(((screen[x][y]).children).x) = xc;
	(((screen[x][y]).children).y) = yc;

	return;
}
      
int makepos(x)			/* translate r,c to array */
int x;
{
	return(x + 37);
}


translate(temp)
struct x_y *temp;
{
	/* translate from r,c to pixels and store in structure  */
	   int x, y, sunx, suny;

	x = temp->x;
	y = temp->y;

	sunx = (x * 50) + 1875;
	suny = y * 50 + 50;

	tasks[curr_id]->x = sunx;
	tasks[curr_id]->y = suny;
}


struct x_y *typezero(parent)	/* Handle center case */
     struct status *parent;
{
	int ischildren(), child, tkn, x, y, newy, constraint;
	struct x_y *temp, *constrainthandle();

	temp = (struct x_y *)malloc(sizeof(struct x_y));
    
	child = ischildren(parent);
	tkn = 1;
	y = (parent->position).y;
	x = (parent->position).x;
	newy = y;

    
	if (child) 		/* if children, use constraints */
	{
		parent->working = parent->constraint;	
		temp = constrainthandle(parent);
	} else 			/* if none offset down off position */
	{
		while (tkn == 1)
		{
			newy = newy + 1;
			tkn = taken(0, newy);
		}
		temp->x = 0;
		temp->y = newy;
	}

	updateparent(0,y,temp->x,temp->y);
	constraint = parent->constraint - 1;
	updatestatus(temp->x,temp->y, 0,0 ,constraint,1);

	return(temp);
}

struct x_y *constrainthandle(parent) /* figure next position off constraint */
struct status *parent;
{
	int working, pass;
	struct x_y *temp, *inconstraint(), *outconstraint();

	pass = parent->pass;
	working = parent->working;

	if (pass == 2)
	{
		temp = outconstraint(parent);
	} else
	{
		temp = inconstraint(parent);
	}

	return(temp);
}

struct x_y *inconstraint(parent) /* skip two, odd and even */
struct status *parent;
{
	int tkn, wrkg,newx, y, constraint,pass;
	struct x_y *temp;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	y = (parent->children).y;

	wrkg = parent->working;
	pass = parent->pass;
    
	tkn = taken(wrkg,y);
	newx = wrkg;
	temp->y = y;
	temp->x = wrkg;

	while (tkn == 1) 		/* skip by two until a free positon */
	{
		if (newx > 0) 
		{
			newx = -1 * wrkg;
			temp->x = newx;
		} else
		{
			wrkg = wrkg - 2;
			newx = wrkg;
			temp->x = newx;
		}
		if (wrkg < 1) 		/* if neccesary, update and call again */
		{
			parent->pass = pass + 1;
			parent->working = parent->constraint + 1;
			parent->constraint = parent->constraint + 1;
			temp =(constrainthandle(parent));
			newx = temp->x;
		}
		tkn = taken(newx,y);
	}
	return(temp);
}
	


struct x_y *outconstraint(parent) /* increment, flipping pos/neg  */
struct status *parent;
{
	int x, y, tkn, newx;
	struct x_y *temp;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	x = (parent->children).x;
	y = (parent->children).y;
	tkn = 1;
	newx = x;

	while (tkn == 1) 		/* flip/inc until free */
	{
		if (newx > 0)
		{
			newx = -1 * newx;
		} else
		{
			newx = -1 * newx;
			newx = newx + 1;
		}
		tkn = taken(newx,y);
	}
    
	temp->x = newx;
	temp->y = y;

	return(temp);
}


int taken(x,y)			/* check if position is taken */
int x,y;
{
	struct status checkposition;

	x = makepos(x);
	checkposition = screen[x][y];

	if ( checkposition.position.y == 0)
	{
		return(0);
	} else
	{
		return(1);
	}
}

int ischildren(parent)		/* check if parent has children */
struct status *parent;
{
	int xchild,ychild,temp;

	xchild = (parent->children).x;
	ychild = (parent->children).y;

	if ( (xchild==0) && (ychild==0) )
	{
		temp = 0;
	} else 
	{
		temp = 1;
	}

	return(temp);
}


printstatus(x,y)		/* print status (debugging) */
int x,y;
{
	x = makepos(x);

	printf("     Position %d, %d\n", (((screen[x][y]).position).x),
	                             	(((screen[x][y]).position).y));
	printf("     Child    %d, %d\n", (((screen[x][y]).children).x), 
	                             	(((screen[x][y]).children).y));
	printf("     Cnstrnt  %d\n", ((screen[x][y]).constraint));
	printf("     Pass     %d\n", ((screen[x][y]).pass));
	printf("     Screen   %d\n", ((screen[x][y]).working));
	printf("\n\n");
}

subtree_assign_xy()
{
/*****************************************
 * Assigns the current task coordinate in
 * the subtree canvas, based on the 
 * coordinates of its parent.
 *****************************************/

	int parentid;
	int x,y;   /* x,y coords of parent */
	int newx, newy;
	struct x_y *original, *subtree_typezero(), *subtree_typeone();

	if (subtree_screen[37][0].id == subtree_curr_id)
	{
		tasks[subtree_curr_id]->stx = 1875;
		tasks[subtree_curr_id]->sty = 50;
#ifdef sunview
		scrollbar_scroll_to(sth_bar,1400);
		scrollbar_scroll_to(stv_bar,0);
#endif
#ifdef X11
		XtMoveWidget(inner_canvas,-1400,0);
#endif
	} else
	{
		parentid = tasks[subtree_curr_id]->parent;
		x = tasks[parentid]->stx;
		y = tasks[parentid]->sty;
		newx = realtoworkx(x);
		newy = realtoworky(y);
		if (newx == 0)
		{
			original = subtree_typezero(&(subtree_screen[makepos(newx)][newy]));
		} else
		{
			original = subtree_typeone(&(subtree_screen[makepos(newx)][newy]));
		}
		subtree_translate(original);   /* translate to pixels and assign */
	} /* end else */
}

struct x_y *subtree_typeone(parent)	/* Handle off center case  */
struct status *parent;
{
	struct x_y *temp;
	int child, xc, yc, x, y, newx, newy, tkn;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	xc = (parent->children).x;
	yc = (parent->children).y;
	x  = (parent->position).x;
	y  = (parent->position).y;

	/* if children, offset by child  */
	if (child = subtree_ischildren(parent)) 
	{
		if ( x < 0)
		{
			newx = xc - 1;
		} else
		{
			newx = xc + 1;
		}
		newy = yc;
	} else 			/* if none, offset by position */
	{
		newx = x;
		newy = y + 1;
	}

	tkn = subtree_taken(newx,newy);

	while (tkn == 1)
	{
		newy = newy + 1;
		tkn = subtree_taken(newx, newy);
	}

	subtree_updateparent(x,y,newx,newy);     /* position, children */
	subtree_updatestatus(newx,newy,0,0,0); /* position children constraint*/

	temp->x = newx;
	temp->y = newy;

	return(temp);
} 


subtree_updatestatus(x,y,xc,yc,cons) /* Update a subtree_screen position */
int x,y,xc,yc,cons;
{
	int realx;

	realx = makepos(x);

	(((subtree_screen[realx][y]).children).x) = xc;
	(((subtree_screen[realx][y]).children).y) = yc;
    
	(((subtree_screen[realx][y]).position).x) = x;
	(((subtree_screen[realx][y]).position).y) = y;

	subtree_screen[realx][y].id = subtree_curr_id;
	((subtree_screen[realx][y]).constraint) = cons;

	return;
} 
     


subtree_updateparent(x,y,xc,yc)		/* update a parent with child */
int x,y,xc,yc;
{
	x = makepos(x);

	(((subtree_screen[x][y]).children).x) = xc;
	(((subtree_screen[x][y]).children).y) = yc;

	return;
}
      


subtree_translate(temp)
struct x_y *temp;
{
	/* translate from r,c to pixels and store in subtree structure  */
	   int x, y, sunx, suny;

	x = temp->x;
	y = temp->y;

	sunx = (x * 50) + 1875;
	suny = y * 50 + 50;

	tasks[subtree_curr_id]->stx = sunx;
	tasks[subtree_curr_id]->sty = suny;
}


struct x_y *subtree_typezero(parent)	/* Handle center case */
struct status *parent;
{
	int subtree_ischildren(), child, tkn, x, y, newy, constraint;
	struct x_y *temp, *subtree_constrainthandle();

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	child = subtree_ischildren(parent);
	tkn = 1;
	y = (parent->position).y;
	x = (parent->position).x;
	newy = y;

    
	if (child) 		/* if children, use constraints */
	{
		parent->working = parent->constraint;	
		temp = subtree_constrainthandle(parent);
	} else 			/* if none offet down off position */
	{
		while (tkn == 1)
		{
			newy = newy + 1;
			tkn = subtree_taken(0, newy);
		}
		temp->x = 0;
		temp->y = newy;
	}

	subtree_updateparent(0,y,temp->x,temp->y);
	constraint = parent->constraint - 1;
	subtree_updatestatus(temp->x,temp->y, 0,0 ,constraint,1);

	return(temp);
}

struct x_y *subtree_constrainthandle(parent) /* figure next position off constraint */
struct status *parent;
{
	int working, pass;
	struct x_y *temp, *subtree_inconstraint(), *subtree_outconstraint();

	pass = parent->pass;
	working = parent->working;

	if (pass == 2)
		temp = subtree_outconstraint(parent);
	else
		temp = subtree_inconstraint(parent);

	return(temp);
}

struct x_y *subtree_inconstraint(parent) /* skip two, odd and even */
struct status *parent;
{
	int tkn, wrkg,newx, y, constraint,pass;
	struct x_y *temp;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	y = (parent->children).y;

	wrkg = parent->working;
	pass = parent->pass;
    
	tkn = subtree_taken(wrkg,y);
	newx = wrkg;
	temp->y = y;
	temp->x = wrkg;

	while (tkn == 1) 		/* skip by two until a free positon */
	{
		if (newx > 0)
		{
			newx = -1 * wrkg;
			temp->x = newx;
		} else
		{
			wrkg = wrkg - 2;
			newx = wrkg;
			temp->x = newx;
		}
		if (wrkg < 1) 	/* if neccesary, update and call again */
		{
			parent->pass = pass + 1;
			parent->working = parent->constraint + 1;
			parent->constraint = parent->constraint + 1;
			temp =(subtree_constrainthandle(parent));
			newx = temp->x;
		}
		tkn = subtree_taken(newx,y);
	}
	return(temp);
}
	


struct x_y *subtree_outconstraint(parent) /* increment, flipping pos/neg  */
struct status *parent;
{
	int x, y, tkn, newx;
	struct x_y *temp;

	temp = (struct x_y *)malloc(sizeof(struct x_y));

	x = (parent->children).x;
	y = (parent->children).y;
	tkn = 1;
	newx = x;

	while (tkn == 1) 		/* flip/inc until free */
	{
		if (newx > 0)
		{
			newx = -1 * newx;
		} else
		{
			newx = -1 * newx;
			newx = newx + 1;
		}
		tkn = subtree_taken(newx,y);
	}
    
	temp->x = newx;
	temp->y = y;

	return(temp);
}


int subtree_taken(x,y)			/* check if position is taken */
int x,y;
{
	struct status checkposition;

	x = makepos(x);
	checkposition = subtree_screen[x][y];

	if ( checkposition.position.y == 0)
		return(0);
	else
		return(1);
}

int subtree_ischildren(parent)		/* check if parent has children */
struct status *parent;
{
	int xchild,ychild,temp;

	xchild = (parent->children).x;
	ychild = (parent->children).y;

	if ( (xchild==0) && (ychild==0) )
	{
		temp = 0;
	} else 
	{
		temp = 1;
	}

	return(temp);
}


subtree_printstatus(x,y)		/* print status (debugging) */
int x,y;
{
	x = makepos(x);

	printf("     Position %d, %d\n", (((subtree_screen[x][y]).position).x),
					(((subtree_screen[x][y]).position).y));
	printf("     Child    %d, %d\n", (((subtree_screen[x][y]).children).x), 
					(((subtree_screen[x][y]).children).y));
	printf("     Cnstrnt  %d\n", ((subtree_screen[x][y]).constraint));
	printf("     Pass     %d\n", ((subtree_screen[x][y]).pass));
	printf("     Screen   %d\n", ((subtree_screen[x][y]).working));
	printf("\n\n");
}
E 1
