#include "Bdef.h"


#if (INTFACE == C_CALL)
void Cdgesd2d(ConTxt, m, n, A, lda, rdest, cdest)
int  ConTxt;
int  m;
int  n;
double  *A;
int  lda;
int  rdest;
int  cdest;
#else
void dgesd2d_(ConTxt, m, n, A, lda, rdest, cdest)
int  *ConTxt;
int  *m;
int  *n;
double  *A;
int  *lda;
int  *rdest;
int  *cdest;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point-to-point general double precision send.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to double precision two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination process.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination process.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void mvcopy8();
   void Ssend2dID();
   char *getbuff();

   int length, tlda;
   char *buff;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_SD, __FILE__, 'a', 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rdest), Mpaddress(cdest));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);

   length = Mpval(m) * Mpval(n) * sizeof(double);
/*
 *  If no packing is required, do blocking send and return
 */
   if ( (Mpval(m) == tlda) || (Mpval(n) == 1) )
      Ssend2dID(ctxt, (char *) A, length, Mpval(rdest), Mpval(cdest));
/*
 * If buffer is not contiguous, get buffer, pack, and send
 */
   else
   {
      buff = getbuff(length);
      dmvcopy(Mpval(m), Mpval(n), A, tlda, buff);
      Ssend2dID(ctxt, buff, length, Mpval(rdest), Mpval(cdest));
   }
}  /* end of dgesd2d_ */
