#include "Bdef.h"
#if (INTFACE == C_CALL)
void Cblacs_get(ConTxt, what, val)
int  ConTxt;
int  what;
int  *val;
#else
void blacs_get_(ConTxt, what, val)
int  *ConTxt;
int  *what;
int  *val;
#endif
{
   BLACSCONTEXT *ctxt;
   extern int minID00, maxID00;

   switch( Mpval(what) )
   {
   case SGET_SYSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_MSGIDS:
      val[0] = minID00;
      val[1] = maxID00;
      break;
   case SGET_DEBUGLVL:
      *val = BlacsDebugLvl;
      break;
   case SGET_BLACSCONTXT:
      *val = NOTINCONTEXT;
      break;
   case SGET_NR_BS:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nr_bs;
      break;
   case SGET_NB_BS:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nb_bs - 1;
      break;
   case SGET_NR_CO:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nr_co;
      break;
   case SGET_NB_CO:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->Nb_co - 1;
      break;
   case SGET_TOPSREPEAT:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->TopsRepeat;
      break;
   case SGET_TOPSCOHRNT:
      MGetConTxt(Mpval(ConTxt), ctxt);
      *val = ctxt->TopsCohrnt;
      break;
   default:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__, "Unknown WHAT (%d)",
                Mpval(what));
   }
}
