#include "Bdef.h"

void mvcopy4(m, n, A, lda, buff)
int  m;
int  n;
int  *A;
int  lda;
int  *buff;
/*
 *  performs a 4 byte matrix to vector copy
 */
{
   void mvcopy8();
   int i, j;
   long iaddr;

   iaddr = (long) A;
/*
 * If address is on a 8 byte boundary, and lda and m are evenly divisible by 2,
 * can use double sized pointers for faster packing
 */
   if ( !(iaddr % 8) && !(lda % 2) && !(m % 2) )
      mvcopy8(m/2, n, (double *) A, lda/2, (double *) buff);
/*
 * Otherwise, must use 4 byte packing
 */
   else
   {
      if (m != 1)
      {
         for (j=0; j < n; j++)
         {
            for (i=0; i < m; i++) buff[i] = A[i];
            A += lda;
            buff += m;
         }
      }
      else
      {
         for (j=0; j < n; j++) buff[j] = A[j*lda];
      }
   }
}
