/* 
 * -- High Performance Computing Linpack Benchmark (HPL)                
 *    HPL - 2.2 - February 24, 2016                          
 *    Antoine P. Petitet                                                
 *    University of Tennessee, Knoxville                                
 *    Innovative Computing Laboratory                                 
 *    (C) Copyright 2000-2008 All Rights Reserved                       
 *                                                                      
 * -- Copyright notice and Licensing terms:                             
 *                                                                      
 * Redistribution  and  use in  source and binary forms, with or without
 * modification, are  permitted provided  that the following  conditions
 * are met:                                                             
 *                                                                      
 * 1. Redistributions  of  source  code  must retain the above copyright
 * notice, this list of conditions and the following disclaimer.        
 *                                                                      
 * 2. Redistributions in binary form must reproduce  the above copyright
 * notice, this list of conditions,  and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 *                                                                      
 * 3. All  advertising  materials  mentioning  features  or  use of this
 * software must display the following acknowledgement:                 
 * This  product  includes  software  developed  at  the  University  of
 * Tennessee, Knoxville, Innovative Computing Laboratory.             
 *                                                                      
 * 4. The name of the  University,  the name of the  Laboratory,  or the
 * names  of  its  contributors  may  not  be used to endorse or promote
 * products  derived   from   this  software  without  specific  written
 * permission.                                                          
 *                                                                      
 * -- Disclaimer:                                                       
 *                                                                      
 * THIS  SOFTWARE  IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,  INCLUDING,  BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY
 * OR  CONTRIBUTORS  BE  LIABLE FOR ANY  DIRECT,  INDIRECT,  INCIDENTAL,
 * SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES  (INCLUDING,  BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA OR PROFITS; OR BUSINESS INTERRUPTION)  HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT,  STRICT LIABILITY,  OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 * ---------------------------------------------------------------------
 */ 
/*
 * Include files
 */
#include "hpl.h"

#ifdef STDC_HEADERS
void HPL_dlaprnt
(
   const int                        M,
   const int                        N,
   double *                         A,
   const int                        IA,
   const int                        JA,
   const int                        LDA,
   const char *                     CMATNM
)
#else
void HPL_dlaprnt
( M, N, A, IA, JA, LDA, CMATNM )
   const int                        M;
   const int                        N;
   double *                         A;
   const int                        IA;
   const int                        JA;
   const int                        LDA;
   const char *                     CMATNM;
#endif
{
/* 
 * Purpose
 * =======
 *
 * HPL_dlaprnt prints to standard error an M-by-N matrix A.
 * 
 *
 * Arguments
 * =========
 *
 * M       (local input)                 const int
 *         On entry,  M  specifies the number of rows of A. M must be at
 *         least zero.
 *
 * N       (local input)                 const int
 *         On entry,  N  specifies the number of columns of A. N must be
 *         at least zero.
 *
 * A       (local input)                 double *
 *         On entry, A  points to an array of dimension (LDA,N).
 *
 * IA      (local input)                 const int
 *         On entry, IA specifies the starting row index to be printed.
 *
 * JA      (local input)                 const int
 *         On entry,  JA  specifies  the  starting  column index  to be
 *         printed.
 *
 * LDA     (local input)                 const int
 *         On entry, LDA specifies the leading dimension of the array A.
 *         LDA must be at least max(1,M).
 *
 * CMATNM  (local input)                 const char *
 *         On entry, CMATNM is the name of the matrix to be printed.
 *
 * ---------------------------------------------------------------------
 */ 
/*
 * .. Local Variables ..
 */
   int                        i, j;
/* ..
 * .. Executable Statements ..
 */
   for( j = 0; j < N; j++ )
   {
      for( i = 0; i < M; i++ )
      {
         HPL_fprintf( stderr, "%s(%6d,%6d)=%30.18f\n", CMATNM, IA+i,
                      JA+j, *(Mptr( A, i, j, LDA )) );
      }
   }
/*
 * End of HPL_dlaprnt
 */
}
