/*  List action numbers and the accompanying data */

#include <stdio.h>
#include <sys/file.h>
#define RMODE 0            /* read mode */
#define BUFSIZE 10         /* Maximum 32 bit words to buffer */

struct log_entry_templet {
    unsigned foo : 2;		/* Bits  0: 1 ignore */
    unsigned len : 4;		/* Bits  3: 6 number of words in the ADD */
    unsigned actno : 10;	/* Bits  7:16 Action Number */
    unsigned pid : 6;		/* Bits 17:22 Process ID */
    unsigned clock_hi : 10;	/* Bits 23:32 Hi 10 bits of real time clock */
    unsigned clock;		/* Bits  0:32 Lo word of RTC  */
    unsigned tdaddr;		/* Bits  0:32 MemLoc of task Ident */
    unsigned tid;		/* Bits  0:32 Task ID */
} log_entry;
      


main(argc, argv)
int argc;
char *argv[];
{
    int lesize, fd, cc, event;
    unsigned int buf[BUFSIZE];
    double data(), dat2(), real_time_clock();
    double rtc, prev_rtc = 0.0;

    if( argc != 2 ) {
	fprintf(stderr,"%s: usage: %s log_file\n",argv[0],argv[0]);
	exit( 1 );
    }

    fd = open(argv[1],O_RDONLY,RMODE);
    if( fd < 1 ) {
	fprintf(stderr,"%s: Error: Can't open file <%s>\n",argv[0],argv[1]);
	exit( 1 );
    }

    printf("\t\tChronological Multitasking History\n");
    printf("Event         Time  Pid Task Action  Len\tAction-Dependent-Data\n");
    printf("-----         ---- ---- ---- ------ ----\t---------------------\n");

    lesize = sizeof(log_entry);
    while( (cc=read(fd,&log_entry,lesize)) == lesize ) {
	int i, length, action, procid, tskaddr, taskid, aux_dat;

	/* Extract data from log_entry */
	length = log_entry.len;
	action = log_entry.actno;
	procid = log_entry.pid;
	rtc    = real_time_clock( log_entry.clock_hi,log_entry.clock);
	tskaddr= log_entry.tdaddr;
	taskid = log_entry.tid;
#ifdef DEBUG
	printf("action is %d\n", action );
	printf("length is %d\n", length);
	printf("procss is %d\n", procid );
	printf("clock  is %d\n", rtc );
	printf("tskadr is %d\n", tskaddr );
	printf("tsknmb is %d\n", taskid );
#endif
	/* Print the results. */
	printf("%5d %12.0f %4d %4d %6d %4d",++event,rtc,procid,taskid,action,length);
	if( rtc <= prev_rtc ) printf("<-");
	prev_rtc = rtc;

	/* Length = number of 64 bit words.  */
	aux_dat = 8*length - 16;            /* number of bit aux data    */
	cc = read( fd, buf, aux_dat );
	for(i = 0; i < aux_dat/8; ++i) {
	    unsigned int first = buf[2*i];	/* First 32 bit word*/
	    unsigned int secnd = buf[2*i+1];	/* Second 32 bit word */
	    printf("\t%14.0f", dat2(first, secnd));
	}
	
	printf("\n");
    }
}

double real_time_clock(hiwrd, lowrd)
unsigned int hiwrd, lowrd;
{
    double data, exponent;
    int i;
    unsigned int mask[32];

    /* Set up the mask */
    mask[0] = 0x1;
    for( i=1; i<32; i++ )
      mask[i] = mask[i-1] << 1;

    data = 0.0;
    exponent = 1.0;

    /* Look at the low 32 bits. */
    for(i=0; i<32; i++,	exponent *= 2.0 ) {
	/* Add in 2^i if bit i is turned on. */
	if( lowrd & mask[i] ) data += exponent;
    }

    /* Look at the high 10 bits, last bit should not be on. */
    for( i=0; i<10; i++, exponent *= 2.0 ) {
	/* Add in 2^(i+32) if bit i is turned on. */
	if( hiwrd & mask[i] ) data += exponent;
    }
    return( data );
}

#define POW 4294967296.0   /* 2^32 power, 32 bit shift */

double data(first,secnd)
unsigned int first, secnd;

{
    double data, lsb, msb, pow = POW;

    lsb = (double)secnd;                 /* Least signif. bit */

    msb = (double)first * pow;  /* shift by 32 bits */
    data = msb + lsb;

    return(data);
    
}
double dat2( hiwrd, lowrd)
unsigned int hiwrd, lowrd;
{
    double data, exponent;
    int i;
    unsigned int mask[32];

    /* Set up the mask */
    mask[0] = 0x1;
    for( i=1; i<32; i++ )
      mask[i] = mask[i-1] << 1;

    data = 0.0;
    exponent = 1.0;

    /* Look at the low 32 bits. */
    for(i=0; i<32; i++,	exponent *= 2.0 ) {
	/* Add in 2^i if bit i is turned on. */
	if( lowrd & mask[i] ) data += exponent;
    }

    /* Look at the high 31 bits, last bit should not be on. */
    for( i=0; i<31; i++, exponent *= 2.0 ) {
	/* Add in 2^(i+32) if bit i is turned on. */
	if( hiwrd & mask[i] ) data += exponent;
    }
    return( data );
}
