c                     CRAY COMPATABILITY LIBRARY
c         Routines that deal with the tasks.
c
c   (c) Copyright 1987 the Regents of the University of California,
c    Lawrence Livermore National Laboratory.  All Rights Reserved.
c $Locker:  $
c $Revision: 1.0 $
c $Log:	tasks.f,v $
c Revision 1.0  87/09/12  15:25:40  seager
c Initial Release
c 
c $Header: tasks.f,v 1.0 87/09/12 15:25:40 seager Rel $
c
      subroutine tskstart( usrtskarry, subtocall, arg1, arg2, arg3, 
     $     arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,
     $     arg14,arg15,arg16,arg17,arg18,arg19,arg20 )
c
      parameter(IPGSZ=4096)
      double precision urtc
      integer info(10)
      integer usrtskarry(3), pid, fork, lcl_ctr
      integer status, lib_attach_shared_region, getpid, gettid
      external subtocall, urtc, fork, lib_attach_shared_region
      external getpid, gettid
      save numcalls
      data numcalls /0/
c
      include 'tskcombgn.h'
      include 'tskcomend.h'
c
c         Check the incomming data.
      numargs = lib_number_of_arguments()
      if( numargs.lt.2 .or. numargs.gt.20 ) then
         write(0,1000) numargs
         call exit(1)
      endif
      if( usrtskarry(1).lt.2 .or. usrtskarry(1).gt.3 ) then
         write(0,1010) usrtskarry(1)
         call exit(2)
      endif
      numcalls = numcalls + 1
c
c         On the first call set only the root task is running.
c         Set up the task info for the root task.
c         Also set up the shared memory region.
c
      if( numcalls.eq.1 ) then
         rootpid = getpid()
         id = 99
         locbgn = loc(tskarry(1,1))
         isize  = ((loc(tskbufend(1)) - locbgn)/IPGSZ + 1)*IPGSZ
D         write(6,9000) id, locbgn, isize, locbgn+isize
D         write(6,9000) id, locbgn, isize, loc(tskbufend(1))
         status = lib_create_shared_region( id, tskarry, isize, 0 )
         if( status .ne. 0 ) then
            call perror(' Error CREATING shared region')
            call exit( status )
         endif
      endif
c
c         Now do the fork and get on to the user specified work routine.
c
      usrtskarry(2) = 0
      pid = fork()
      if( pid.lt.0 ) then
         call perror(' TSKSTART Error #3: Trouble FORKING new task')
         call exit( pid )
      endif
      if( pid.eq.0 ) then
c
c         Wait to make sure the parent process sets up my tskarry.
c         lcl_ctr counting up to 100000 is a 0.1368 sec delay.
c
         lcl_ctr = 0
         do while (usrtskarry(2).eq.0)
            lcl_ctr = lcl_ctr + 1
            if( lcl_ctr.gt.1000000 ) then
               write(0,1060) getpid()
               call exit( 1 )
            endif
         end do
         call subtocall( arg1, arg2, arg3, arg4,
     $        arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,
     $        arg15,arg16,arg17,arg18,arg19,arg20 )
c
c         Mark the tskarry so that others will know I'm complete.
c
         if( usrtskarry(2).lt.1 .or. usrtskarry(2).gt.16 ) then
            write(6,1040) getpid(), usrtskarry(2)
            call exit( 1 )
         endif
         tskarry(2,usrtskarry(2)) = -tskarry(2,usrtskarry(2))
         usrtskarry(2) = -usrtskarry(2)
c
c         Log the termination of this task/process.
c
         if( lgentryon ) then
            info(1) = -usrtskarry(2)
D            write(6,1030) info(1), getpid()
            call lgentry( 130, info, 0 )
            call lgentry( 131, info, 0 )
         endif
         call exit(0)
      endif
c
c         Or set up the tskarry for the child process...
c
      numtsk = numtsk + 1
      if( numtsk.lt.2 .or. numtsk.gt.100 ) then
         write(0,1020) numtsk
         call exit( 1 )
      endif
      tskarry(1,numtsk) = 3
      tskarry(2,numtsk) = numtsk
      tskarry(3,numtsk) = pid
D      write(6,1050) numtsk
      if( lgentryon ) then
c
c         Log the new task/process start.
c
         info(1) = numtsk
         info(2) = pid
         call lgentry( 129, info, 1 )
         info(1) = numtsk
         info(2) = pid
         call lgentry( 145, info, 1 )
         info(1) = numtsk
         info(2) = pid
         call lgentry( 132, info, 1 )
      endif
c
c         Release the new task to run.
c
      usrtskarry(2) = numtsk
D      write(0,*) ' NUMCALLS = ',numcalls,' Task ',pid,' created...'
      return
 1000 format(' TSKSTART Error #1: Incorrect number of arguments'/
     $     ' numargs = ',i10,' should be between 2 and 20')
 1010 format(' TSKSTART Error #2: Incorrect Task Array Length'/
     $     ' tskarry(1) = ',i10,' sould be between 2 and 3')
 1020 format(' TSKSTART Error #3: Garbled number of tasks ',i5)
D 1030 format(' TSKSTART logging the shut down of TID, PID ',2i6)
 1040 format(' TSKSTART: Internal error usrtskarry out of bounds'/
     $     ' PID = ',i10,' usrtskarry(2) = ',i10)
D 1050 format(' TSKSTART: Init task ',i4)
 1060 format(' TSKSTART: Aborting child task...waited too long. pid=',
     $     i5)
D 9000 format(' CREATING shared memory region ',i3/
D     $     ' locbeg, isize, locend = '3i10)
      end
      logical function tsktest( usr_tskarry )
      integer usr_tskarry(3)
c
c         This routine tests to see if a task exists.
c         It returns a .TRUE. if the task exists and .FALSE. otherwise.
c
      include 'tskcomend.h'
      integer tid
c
c         Check to see if somthing jives.
c
      tsktest = .FALSE.
      tid = usr_tskarry(2)
      do i = 1, numtsk
         tsktest = tsktest .or. (tid .eq. tskarry(2,i))
      enddo
      return
      end
      subroutine tsktune( arg1 )
c
c
c
      return
      end
      subroutine tskvalue( value )
      integer value
c
c         This routine returns the value of argument 3 of the tskarry for
c         this task.
c
      integer pid, getpid
      external getpid
      include 'tskcomend.h'
c
c         Get my pid.
c
      pid = getpid()
c
c         If i'm the ROOT task return 0.
      if(pid.eq.rootpid) then
         value = 0
         return
      endif
c
c         Look for a match of PID in the task discriptor.
c
      value = 0
      do i = 1, numtsk
         if( pid.eq.tskarry(3,i) ) then
            if( tskarry(1,i).eq.3 ) value = tskarry(3,i)
            return
         endif
      enddo
      return
      end
      subroutine tskwait( usrtskarry )
      integer usrtskarry(3)
      include 'tskcomend.h'
      integer getpid, tid, info(10)
      external getpid
c
      tid = usrtskarry(2)
c
c         Zero TID's denote tasks not yet activated.
D      write(6,1010) getpid(),tid, lgentryon
D 1010 format(' TSKWAIT: Process ',i5,' Waiting for Task ID ',i5,
D     $     ' lgentryon = ',i2)
      if( tid.eq.0 ) then
         write(0,1000)
         call exit(1)
      endif
c
c         If desired, log the waittask...
      if( lgentryon.eq.1 ) then
c         Log the fact that we are waiting for a task.
         info(1) = usrtskarry(2)
         if( info(1).gt.0 ) then
            call lgentry( 160, info, 1 )
         else
            info(1) = -info(1)
            call lgentry( 163, info, 1 )
         endif
      endif
c
c         Negative PID's denote child tasks that have been completed.
      if( tid.lt.0 ) then
         return
      endif
c
c         Wait until the tskarry goes negative.
      do while( usrtskarry(2).ge.0 ) 
         continue
      enddo
      if( lgentryon.eq.1 ) then
c         Log the fact that we are done waiting for a task.
         info(1) = -usrtskarry(2)
         call lgentry( 166, info, 1 )
      endif
      return
 1000 format(' TSKWAIT Error #1:',
     $     ' Task to wait upon is not an Alliant Task')
      end
      integer function gettid()
c
c         Determines the TID of this process.
c
      include 'tskcomend.h'
      integer pid, getpid, tid
      external getpid
c
      pid = getpid()
      do i = 1, numtsk
         if( tskarry(3,i).eq.pid ) then
            gettid = i
            tid = i
            goto 10
         endif
      enddo
c
c         If we get here things are mucked up.
c
      write(6,1000) pid, (tskarry(1,i),tskarry(2,i),
     $     tskarry(3,i),i=1,numtsk)
      call exit( 1 )
C
c         Everything AOK
c
 10   continue
D      write(6,1010) pid, tid, (tskarry(1,i),tskarry(2,i),
D     $     tskarry(3,i),i=1,numtsk)
      return
 1000 format(' GETTID: ERROR: Cant find tid for PID ',i5/
     $     (' TSKARRY= ',3i6))
D 1010 format(' GETTID: PID ',i5,' Found for TID ',i5/
D     $     (' TSKARRY= ',3i6))
      end
