\"	-*-Text-*-
.TH tsktest l "" "" "\fBCray Compatibility Library: libCRAY.a\fP" 
.SH NAME
tsktest \- Test for the existance of a task
.SH SYNOPSIS
.B logical tsktest, istat
.br
.B istat = tsktest( taskarry )
.SH ARGUMENTS
.B taskarry
.RS
Task control array for the task to be inspected.
Word 2 of this array is the unique identifier for the task (as
returned by \fItskstart\fR).
.RE
.SH RETURNS
.B istat
.RS
A Fortran logical .TRUE. if the indicated task exists.
A Fortran logical .FALSE. if the indicated task has completed
execution.
.RE
.SH DESCRIPTION
This routine test for the existance of the task indicated by
\fItaskarry\fR.
If the indicated task is complete, does not exist, or neve existed the
routine will return .FALSE. to the calling task.
If the indicated task exists and has not completed, the routine
returns .TRUE. to the calling task.
.PP
Care should be taken when using this routine in a multiprocessing job.
The value returned may be invalidated shortly after, or just before it
is returned.
That is to say the returned value is valid at the time the
\fItsktest\fR checks the appropriate data structure,
however since concurrent execution is possible, the status
may have changed by the time the routine returns the status.
.SH FILES
/usr/local/lib/libCRAY.a
.SH "SEE ALSO"
\fItskstart(l)\fR, \fItskwait(l)\fR, \fItsktune(l)\fR, \fItskvalue(l)\fR
.SH BUGS
This routine cannot differentiate between a dead or nonexistent task
and a bad task specification via a faulty taskarry argument.
