\"			-*-Text-*-
.TH lgopen l "" "" "\fBCray Compatibility Library: libCRAY.a\fP" 
.SH NAME
lgopen \- Open the MAT/GMAT history buffer with terminal file storage.
.SH SYNOPSIS
\fBcall lgopen( ibufr, length, nfile, icreate ) \fR
.br
\fBinteger ibufr(length), length, icreate\fR
.br
\fBcharacter* nfile\fR
.SH ARGUMENTS
.B ibufr
.RS
An integer array for the circular buffer (declared by the user in
shared memory) to store the logged information.
.RE
.B length
.RS
The integer length (in words) of the user supplied (shared memory)
buffer.
.RE
.B nfile
.RS
Character string holding the pathname of a file to dump out the trace
buffer information when lgclose is called.
.RE
.B icreate
.RS
An integer flag which signals the file creation policy.  Icreate = -1
will destroy an existing file.  Icreate = 0 will cause an error
message and program termination if the file exists.
.RE
.SH DESCRIPTION
This routine sets up the internal buffers fo the event logging
routines.  If a pathname is supplied the internal history buffer will
be dumped out to disk when the call to \fIlgclose\fR is made.  No disk
accesses are made during the logging process (this minimizes the
overhead).
.SH FILES
/usr/local/lib/libCRAY.a
.SH "SEE ALSO"
\fIlgon(l)\fR, \fIlgoff(l)\fR, \fIlgdsable(l)\fR, \fIlgenable(l)\fR
.SH BUGS
This routine cannot allocate it's own shared memory history buffer as
in the NLTSS/NSYSLIB Cray version.  There is also no way for the user
to determine how much buffer his application will need.  There is no
way for the tracing routines to let the user know that the buffer has
been filled up and is now wrapping upon itself.  Alliant's
implementation of shared memory does not allow shared pages to be
swapped out.  Hence, if you choose a huge buffer overall system
performance will degrade :-(.
