c                     CRAY COMPATABILITY LIBRARY
c         Routines that deal with BARRIERS.
c
c   (c) Copyright 1987 the Regents of the University of California,
c    Lawrence Livermore National Laboratory.  All Rights Reserved.
c $Locker:  $
c $Revision: 1.0 $
c $Log:	bars.f,v $
c Revision 1.0  87/09/12  15:25:35  seager
c Initial Release
c 
c $Header: bars.f,v 1.0 87/09/12 15:25:35 seager Rel $
c
      subroutine barasgn( bar_var, bar_count )
      integer bar_var, bar_count
c
c         This routine assignes barriers.
c
      include 'tskcomend.h'
      integer info(10)
c
c         Check the input.
c
      if( numbar.ge.20 ) then
         write(0,1000)
         call exit( 1 )
      endif
      if( bar_count.gt.16 .or. bar_count.lt.1 ) then
         write(0,1010) bar_count
         call exit( 1 )
      endif
      if( lgentryon.eq.1 ) then
         info(1) = loc(bar_var)
         call lgentry( 179, info, 1 )
      endif
c
c         Set up the addres of the barlocks and the number of tasks.
c
      do i = 1, 20
         if( barcount(i).eq.0 ) then
            numbar = numbar + 1
            bar_var = i
            barcount(i) = bar_count
D            write(6,1030) numbar, bar_var, barcount(i)
            return
         endif
      enddo
      write(0,1020) 
      call exit( 1 )
      return
 1000 format(' BARASGN Error #1: Trouble assigning BARRIER.',
     $     '  Too many barriers.')
 1010 format(' BARASGN Error #2: Cannot devine BARRIER for < 1 task',
     $     ' or > 16 tasks.  Bar_count = ',i10)
 1020 format(' BARASGN Error #1: Trouble assigning BARRIER.',
     $     '  No more room for barriers.')
D 1030 format(' BARASGN: numbar, index, bar_count = ',3i5)
      end
      subroutine barrel( bar_var )
      integer bar_var
c
c         This routine releases the resouces associated with the bar_var.
c
      include 'tskcomend.h'
      integer info(10)
c
c         Check the input.
c
      if( bar_var.eq.0 ) then
         write(0,1000) bar_var
         call exit( 1 )
      endif
      if( numbar.lt.1 ) then
         write(0,1010)
         call exit( 1 )
      endif
      if( lgentryon.eq.1 ) then
         info(1) = loc(bar_var)
         call lgentry( 180, info, 1 )
      endif
c
c         Try to release this barrier.
c
      if( bar_var.ge.1 .or. bar_var.le.20 ) then
         barcount(bar_var) = 0
         bar_var = 0
         numbar = numbar - 1
         return
      endif
      write(0,1000) bar_var
      call exit( 1 )
      return
 1000 format(' BARREL Error #1: Trouble releasing BARRIER.',
     $     '  Bar_var = ',i10)
 1010 format(' BARREL Error #1: Trouble releasing BARRIER.',
     $     '  No barriers to release.')
 1020 format(' BARREL Error #1: Trouble releasing BARRIER.',
     $     '  Barrier not assigned.')
      end
      subroutine barsync( bar_var )
      integer bar_var
c
c         This routine actualy does the barrier by calling a C routine
c
      include 'tskcomend.h'
      integer whoami
      integer info(10)
c
c         Get the address.
c
      if( bar_var.lt.1 .or. bar_var.gt.20 ) then
         write(0,1000) bar_var
         call exit( 1 )
      endif
c
c         Count the processes as the storm thru.
c
      call s_lockon( tsklok )
      whoami = barwhoami(bar_var)
      barwhoami(bar_var) = barwhoami(bar_var) + 1
      call s_lockoff( tsklok )
      if( lgentryon.eq.1 ) then
         info(1) = loc(bar_var)
         if( whoami.eq.barcount(bar_var)-1 ) then
            call lgentry( 182, info, 1 )
         else
            call lgentry( 181, info, 1 )
         endif
      endif
c
c         If were the last one thru reset the count.
c
      if( whoami.eq.barcount(bar_var)-1 ) barwhoami(bar_var) = 0
D      write(6,1010) whoami, bar_var, barcount(bar_var),
D     $     loc( barlok(1,1,bar_var))
      call tsk_bar( whoami, barcount(bar_var), barlok(1,1,bar_var) )
      if( lgentryon.eq.1 ) then
         info(1) = loc(bar_var)
         if( whoami.ne.barcount(bar_var)-1 ) then
            call lgentry( 183, info, 1 )
         endif
      endif
      return
 1000 format(' BARSYNC Error #1: Corrupted Bar_var = ',i10 )
D 1010 format(' BARSYNC: whoami, bar_var, barcount, barloc = ',3i5,i15)
      end

