/*******************************************************************************
    Copyright (c) 2015 NVidia Corporation

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to
    deal in the Software without restriction, including without limitation the
    rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
    sell copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

        The above copyright notice and this permission notice shall be
        included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*******************************************************************************/

#ifndef _NV_CPU_UUID_H_
#define _NV_CPU_UUID_H_

#define NV_UUID_LEN 16

typedef struct nv_uuid
{
    NvU8 uuid[NV_UUID_LEN];

} NvUuid;

typedef NvUuid NvSystemUuid;

typedef NvUuid NvProcessorUuid;

static const NvProcessorUuid NV_PROCESSOR_UUID_CPU_DEFAULT =
{
    {
       // Produced via uuidgen(1): 73772a14-2c41-4750-a27b-d4d74e0f5ea6:
       0xa6, 0x5e, 0x0f, 0x4e, 0xd7, 0xd4, 0x7b, 0xa2,
       0x50, 0x47, 0x41, 0x2c, 0x14, 0x2a, 0x77, 0x73
    }
};

#endif // _NV_CPU_UUID_H_
