; routine to read and decode a packet
; Receive a packet and parse
RPACK:	call	linput
	mov	dptr,#rcvbuf
	mov	b,#1
	call	strstr		; returns A with index
	mov	I,a
	jnz	L7100
	mov	TYP,#'Q'
	ret
;
L7100:	mov	Mrk,a
	inc	dptr
	movx	a,@dptr
	mov	Chk,a		; chk = asc(mid$(rcvbuf,i+1,1)
	unchar
	clr	c
	subb	a,#3
	mov	Len,a		; Len = chk - 32 - 3
	inc	dptr
	movx	a,@dptr
	mov	T,a		; T = asc(mid$(rcvbuf,i+2,1)
	unchar
	mov	Seq,a		; seq = T - 32
	mov	a,Chk
	add	a,T
	mov	Chk,a		; Chk = Chk + T
	inc	dptr
	movx	a,@dptr
	mov	TYP,a		; typ = mid$(rcvbuf,i+3,1)
	mov	a,Chk
	add	a,TYP
	mov	Chk,a		; Chk = Chk + asc(typ)
	clr	ctrl

L7200:	inc	dptr
	mov	r3,dpl		; rcvbuf pointer
	mov	r4,#0		; pktdat pointer
	mov	r5,Len		; length of packet data
	mov	Ptr,#0
	mov	a,Len
	jz	L7420		; no data, skip to checksum
;
L7210:	mov	dph,#high rcvbuf
	mov	dpl,r3
	movx	a,@dptr		; get a byte from rcvbuf
	mov	T,a
	add	a,Chk
	mov	Chk,a		; Chk = Chk + T
	mov	a,TYP
	cjne	a,#'S',L7250
	sjmp	L7300		; insert into pktdat
L7250:	mov	a,T		; get rcvbuf byte
	jb	ctrl,L7260
	cjne	a,CTL,L7260
	setb	ctrl		; set control flag
	jmp	L7400		; next char
L7260:	anl	a,#127
	mov	T7,a		; T7 = T and 127
	jnb	ctrl,L7300
	clr	ctrl
	clr	c
	subb	a,#62
	jz	L7300		; = 62
	jc	L7300		; < 62
	mov	a,T7
	clr	c
	subb	a,#96
	jz	L7300		; = 96
	jnc	L7300		; > 96
	mov	a,T
	xrl	a,#64
	mov	T,a		; T = T xor 64
;
L7300:	mov	a,T
	mov	dph,#high pktdat
	mov	dpl,r4
	movx	@dptr,a		; put a byte to pktdat
	inc	Ptr		; pktdat count
	inc	r4		; next pktdat cell
L7400:	inc	r3		; next rcvbuf cell
	djnz	r5,L7210
	mov	dph,#high pktdat
	mov	dpl,r4
	clr	a
	movx	@dptr,a		; terminate packet string
;
L7420:	mov	a,Chk
	call	blkchk
	mov	Chk,a
L7430:	mov	dph,#high rcvbuf
	mov	dpl,r3
	movx	a,@dptr
	unchar
L7450:	clr	c		; if chksum <> chk then typ = 'Q'
	subb	a,Chk		; = 0 if equal
	jz	L7460
	mov	TYP,#'Q'
L7460:	ret

