#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char uchar;

/* Parallel interface I/O ports */

#define DATA    0x378
#define STATUS  (DATA+1)
#define CONTROL (DATA+2)

/* Control Port Bit definitions */

#define CSTROBE 0x01
#define CBIO    0x02
#define CRESET  0x04
#define CRUN    0x08

/* Status Port Bit definitions */

#define SACK	0x40
#define SXF	0x80

/* Other constants */

#define MEMSIZE 1048

void main (int argc, char *argv[]);
void reset (void);
void putbyte (uchar byte);

void main (int argc, char *argv[]) {

    FILE *infile;

    int i, nbytes, l;
    uchar data[MEMSIZE];
    uchar status, control, bit;
    unsigned long word;
    char buffer[10], buffer2[10];

    if (argc != 2) {
       printf("Usage: loader <filename>\n");
       exit(1);
    }

    /* initialize */

    memset (data, 0, MEMSIZE);
    reset();

    /* HOLD the processor */

    outportb (CONTROL, inportb(CONTROL) & (~CBIO));  /* BIO = 0 */
    outportb (CONTROL, inportb(CONTROL) | CRUN);     /* -> LOAD = ~RUN */

    /* Wait for HOLD acknowledge */

    while (inportb (STATUS) & SACK)
       ;

    /* Load the object file */

    if ((infile = fopen(argv[1],"rb")) == NULL) {
       printf("ERROR: Can't open %s\n",argv[1]);
       exit(1);
    }
    nbytes = fread (data, 1, MEMSIZE, infile);
    printf ("%d bytes read from file %s\n",nbytes,argv[1]);

    for (i=0; i<nbytes; i+=2) {
      putbyte (data[i+1]);
      putbyte (data[i]);
    }
    printf ("%d words loaded into NVRAM\n",nbytes/2);

    /* reset & run the program */

    outportb (CONTROL, inportb(CONTROL) & (~CRUN));      /* -> RUN         */
    reset();

    /* read a byte from the TMS320 */

    word = 0;
    outportb (CONTROL, inportb(CONTROL) & (~CBIO));
    control = inportb(CONTROL);

    while (!bioskey(1)) {

       /* wait till XF goes high */
       while (!bioskey(1) && !(inportb(STATUS) & SXF))
          ;

       /* receive the word */

       word = 0;
       for (i=0; i<16; i++) {
          outportb(CONTROL, control | CBIO);    /* BIO high */
          outportb(CONTROL, control & (~CBIO)); /* BIO low */
          bit = !(!(inportb(STATUS) & SXF));
          word |= (bit << i);
       }
       outportb(CONTROL, control | CBIO);    /* BIO high */
       outportb(CONTROL, control & (~CBIO)); /* BIO low */

       sprintf(buffer,"%X",word);
       memset(buffer2,'0',4);
       strcpy(buffer2+(4-min(4,strlen(buffer))),buffer);
       cprintf("%s ",buffer2);

    }

    while (bioskey (1))	  	/* flush the buffer */
       bioskey (0);

}

/************************************************************************/

void putbyte (uchar byte) {

   /* output the specified byte */

   uchar value;

   outportb (DATA, byte);

   value = inportb (CONTROL);
   outportb (CONTROL, value | CSTROBE);

   delay (1);
   outportb (CONTROL, value & (~CSTROBE));

} /* putbyte */



/************************************************************************/

void reset (void) {

   /* generates a reset pulse */

   uchar value;

   value = inportb (CONTROL);

   outportb (CONTROL, value & (~CRESET));
   delay (100);
   outportb (CONTROL, value | CRESET);

} /* reset */

/*************************************************************************/