.MODULE LMS_main;

{----------------------------------------------------------------------------}
{             LMS noise reduction / Wiener autonotcher                       }
{                 Copyright (C) 1996, Johan Forrer                           }
{		       26553 Priceview Drive				     }
{                      Monroe, OR 97456			                     }
{                   							     }
{----------------------------------------------------------------------------}

.const taps=51;			{ delay line/filter size                     }
.const aut_taps=32;		{ delay line/filter size                     }
.const delay_taps=63;		{ Autonotch delay line                       }

.entry LMS_init, LMS;

.GLOBAL beta; 			{ beta factor for denoising                  }
.GLOBAL beta_aut;  		{ beta factor for autonotch                  }
.GLOBAL decay;			{ decay factor for denoiser                  }
.GLOBAL decay_aut;		{ decay factor for autonotcher               }
.GLOBAL Denoise_switch;		{ denoiser in/out }
.GLOBAL Autonotch_switch;	{ auto-notcher in/out }

{----------------------------------------------------------------------------}
{                     LMS working storage		                     }
{----------------------------------------------------------------------------}
.VAR/DM/RAM output;	{ FIR output                                 	     }
.VAR/DM/RAM sample; 	{ input sample                               	     }
.VAR/DM/RAM beta  ; 	{ beta factor for denoising                          }
.VAR/DM/RAM beta_aut;  	{ beta factor for autonotch                          }
.VAR/DM/RAM e_beta;
.VAR/DM/RAM e_beta1;	{ for autonotching                                   }
.VAR/DM/RAM decay ;	{ decay factor for denoiser                          }
.VAR/DM/RAM decay_aut;	{ decay factor for autonotcher                       }
.VAR/DM/RAM r_ar1 ;	{ pointer into coeff. array                  	     }
.VAR/DM/RAM gain  ;     { audio output gain setting                  	     }
.VAR/DM/RAM Error ;
.VAR/DM/RAM Autonotch_switch;   { Notch or no Notch                       	     }
.VAR/DM/RAM Denoise_switch;     { Denoise/ no de-noise                     	     }
.VAR/DM/RAM r_ar2;	{ pointer into coeff. array                  	     }

.var/dm/ram i1_ptr;
.var/dm/ram i2_ptr;
.var/dm/ram i3_ptr;

.var/dm/ram save_i2;
.var/dm/ram save_i3;

{----------------------------------------------------------------------------}
{                     LMS circular buffer storage		             }
{----------------------------------------------------------------------------}
.VAR/DM/RAM/CIRC data[aut_taps];	{ circular data delay line           }
.VAR/DM/RAM/CIRC data1[taps];		{ second delay line                  }
.VAR/DM/RAM/CIRC D[delay_taps];		{ input delay line                   }


{------------------- Initialization------------------------------------------}
LMS_init:

{ Beta values that works with 19kHz sample rate 4C00 - 1000                  }
{ values closer to 1000 works best for denoiser                              }

	AX0=0x31EB;		{ 0.039 Beta                                 }
	DM(beta) =AX0;
	AX0=0x747A;	  	{ 0.91  Decay                                }
	DM(decay)=AX0;

	AX0=0x0A3D;		{ 0.080 Beta                                 }
	DM(beta_aut)=AX0;
	AX0=0x7EB8;	  	{ 0.99  Decay                                }
	DM(decay_aut)=AX0;

	I0=^coeff1;		{ Denoising coefficient pointer }
	DM(r_ar1)=I0;

	I0=^coeff;		{ Denotching coefficient pointer }
	DM(r_ar2)=I0;


        I0=^data1;  		{ I1 }
	dm(i1_ptr)=i0;

        I0=^data; 		{ I2 }
	dm(i2_ptr)=i0;

	I0=^D; 			{ I3 }
	dm(i3_ptr)=i0;

	ax0=0; 			{ disable functions }
	dm(Denoise_switch)=ax0;
	dm(Autonotch_switch)=ax0;

	rts;

{----------------------------------------------------------------------------}
{                       Denoiser processing				     }
{        Input sample is in ax0, result goes back into ax0	    	     }
{----------------------------------------------------------------------------}
LMS:    	
	dm(sample)=ax0;			{ save input sample }

	dis m_mode;		{ select 2's compliment mode                 }

{ ------------- Denoise - in or out ? ---------------------------------------}
	ar=dm(Denoise_switch);
	none=pass ar;
	if EQ jump Autonotch;

	i1=dm(i1_ptr);			{ set up registers }
	l1=taps;

{-------------- Decay one coefficient only ----------------------------------}
{  NOTE: Upon reset, fractional arithmetic mode is enabled 		     }

	M5=1; M6=0;
	MY0=DM(decay); 			{ load decay value                   }
	  			        { to work must be circular!!!!!      }
	I4=DM(r_ar1); L4=taps;		{ load coefficient, length           }
	MX0=PM(I4,M6);			{ (M6=0)                             }
	MR=MX0*MY0(SS);    		{ decay * coeff                      }
	PM(I4,M5)=mr1;		  	{ (M5=1) save decayed coeff.         }
	DM(r_ar1)=I4;			{ save updated coeff. pointer        }

{------------- Tweak the coefficients ---------------------------------------}
	m1=1;
	I4=^coeff1; l4=taps;
	MY0=DM(e_beta);MX0=DM(I1,M1);
	CNTR=taps-1;
        DO tweak UNTIL CE;
       		MR=MX0*MY0(SS);		{ delay-line data * e_beta           }
		AY1=PM(I4,M6); 		{ (M6=0) next coeff.                 }
		MX0=DM(I1,M1);		{ next data                          }
		AR=MR1+AY1;
tweak:		PM(I4,M5)=AR; 		{ (M5=1) save coeff.                 }

{-------------- Execute the FIR filter code ---------------------------------}
        I4=^coeff1; L4=taps;		{ set up adresses                    }  

	CNTR=taps-1;
	MR=0, MX0=DM(I1,M1), MY0=PM(I4,M5);
        DO conv UNTIL CE;
conv:   	MR=MR+MX0*MY0(SS), MX0=DM(I1,M1), MY0=PM(I4,M5);
        MR=MR+MX0*MY0(RND);
        IF MV SAT MR;
					{ Assume denoise function            }
        DM(output) = mr1;              	{ save FIR output result}

{--------------	Compute Error ---------------------------------------------}

	AX0=mr1;
	AY0=DM(sample);
	AR=AY0-AX0;			{ Error	= D - Y }
	MY0=DM(beta);
	MR=AR*MY0(SS);			{ e_beta = Error * Beta }
	DM(e_beta)=MR1;			{ save new e_beta }

{------------- Wrap up and return -------------------------------------------}
{     Denoise uses only  a single tap delayed signal to be put into X array  }

	AR=DM(sample);	     
	DM(I1,M1)=AR;			{ (M1=1)                             }	

	AR=dm(output);			{ Daisy chain filters }
	DM(sample)=AR;
	ax0=AR;				{ in case we don't autonotch }

	dm(i1_ptr)=i1;			{ save registers }


{ ------------- Autonotch - in or out ? -------------------------------------}
Autonotch:
	dm(save_i2)=i2;			{ save i2/3 }
	dm(save_i3)=i3;

	ar=dm(Autonotch_switch);
	none=PASS ar;
	if EQ jump Auto1;

	i2=dm(i2_ptr);			{ set up registers }
	l2=aut_taps;
	i3=dm(i3_ptr);
	l3=delay_taps;

{-------------- Decay one coefficient only ----------------------------------}
{  NOTE: Upon reset, fractional arithmetic mode is enabled 		     }

	M5=1; M6=0;
	MY0=DM(decay_aut); 		{ load decay value                   }
	  			        { to work must be circular!!!!!      }
	I4=DM(r_ar2); L4=aut_taps;	{ load coefficient                   }
	MX0=PM(I4,M6);			{ (M6=0)                             }
	MR=MX0*MY0(SS);    		{ decay * coeff                      }
	PM(I4,M5)=MR1;		  	{ (M5=1) save decayed coeff.         }
	DM(r_ar2)=I4;			{ save updated coeff. pointer        }

{------------- Tweak the coefficients ---------------------------------------}
	m1=1;
	I4=^coeff; l4=aut_taps;
	MY0=DM(e_beta1);MX0=DM(I2,M1);
	CNTR=aut_taps-1;
        DO tweak1 UNTIL CE;
       		MR=MX0*MY0(SS);		{ delay-line data * e_beta           }
		AY1=PM(I4,M6); 		{ (M6=0) next coeff.                 }
		MX0=DM(I2,M1);		{ next data                          }
		AR=MR1+AY1;
tweak1:		PM(I4,M5)=AR; 		{ (M5=1) save coeff.                 }

{-------------- Execute the FIR filter code ---------------------------------}
        I4=^coeff; L4=aut_taps;		{ set up adresses                    }  

	CNTR=aut_taps-1;
	MR=0, MX0=DM(I2,M1), MY0=PM(I4,M5);
        DO conv1 UNTIL CE;
conv1:   	MR=MR+MX0*MY0(SS), MX0=DM(I2,M1), MY0=PM(I4,M5);
        MR=MR+MX0*MY0(RND);
        IF MV SAT MR;
        DM(output) = mr1;              	{ save FIR output result}
					{ Assume denoise function            }
{--------------	Compute Error ---------------------------------------------}

	AX0=mr1;
	AY0=DM(sample);
	AR=AY0-AX0;			{ Error	= D - Y }
        DM(Error) = ar;              	{ Save Error for notching }
	MY0=DM(beta_aut);
	MR=AR*MY0(SS);			{ e_beta = Error * Beta }
	DM(e_beta1)=MR1;		{ save new e_beta }

{------------- Wrap up and return -------------------------------------------}
{     Autonotch requires a 63 tap delayed     signal to be put into X array  }
{     Denoise uses only  a single tap delayed signal to be put into X array  }
	m2=0;

	AR=DM(sample);	     
	dm(I3,M1)=ar;	   		{ (M1=1) update 63 tap input delay   }

	ar=DM(I3,M2);	   		{ (M2=0) Auto notch                  }
	DM(I2,M1)=AR;			{ (M1=1)                             }	

	dm(i2_ptr)=i2;			{ save registers }
	dm(i3_ptr)=i3;

	i2=dm(save_i2);	  		{ restore i2/3 }
	i3=dm(save_i3);
	
	ax0=dm(Error);			{ output signal }	  

Auto1:
	rts;

{------------STORAGE FOR ADAPTIVE COEFFICIENTS-------------------------------}
.VAR/PM/CIRC coeff[aut_taps];
.VAR/PM/CIRC coeff1[taps];

{----------------------------------------------------------------------------}
.ENDMOD;

