.module/RAM       hilbert_txfm;
{----------------------------------------------------------------------------}
{									     }
{                 Adapted from Adrian Nash's work "TSRFIL"		     }
{                     By Johan B. Forrer, July 1996   			     }
{----------------------------------------------------------------------------}
.ENTRY digi_bfo, bfo_init;
.EXTERNAL sin;
.global bfo_freq;

.const HILBERT_SIZE=37;        { Hilbert Transformer size }

.var/dm/circ            hdat[HILBERT_SIZE];    { Hilbert filter delay line 1}
.var/dm/circ            hdelay[HILBERT_SIZE];  { Delay line for real data 1}

.var/dm                 hdelay_ptr;            { Hilbert transformer delay ptr 1}
.var/dm                 hdat_ptr;              { Hilbert transformer data ptr 1}
.var/dm                 bfo_freq;               { BFO frequency }
.var/dm                 acc_ph;                 { BFO accumulated phase }
.var/dm                 ovr,high,low;           { Temporary storage for MR }


{----------------------------------------------------------------------------}
bfo_init:

	l0=0;
	l1=0;

	cntr=HILBERT_SIZE;
	i0=^hdelay;
	dm(hdelay_ptr)=i0;
	i1=^hdat;
	dm(hdat_ptr)=i1;

	do clr_hilbert until ce;
	       dm(i0,m0)=0;
clr_hilbert:   dm(i1,m0)=0;

	ar=0;			{ start with no offset }
	dm(bfo_freq)=ar;
	ar=0;			{ start at zero phase }
	dm(acc_ph)=ar;
	
	rts;

{----------------------------------------------------------------------------}
{                          Digital BFO                                       }
{									     }
{ Takes input frequency in Hertz in ax0                                      }                                                
{ Returns result in ar                                                       }                                                
{----------------------------------------------------------------------------}
digi_bfo:
	i0=dm(hdelay_ptr);
	i1=dm(hdat_ptr);

	l4=0;
	m1=0;
	m2=2;
	m4=1;
	i4=^hilbert_coeffs;
	l0=HILBERT_SIZE;
	l1=HILBERT_SIZE;

{ Note that the data in the hdelay buffer (pointed by i0), is stepped       }
{ up in index TWICE, this way the lastest sample comes from a position      }
{ that is halfway down the buffer, i.e., N-1/2 .. a bit tricky but clever.  }                             }

	dm(i0,m0)=ax0;                  { Put sample into delay line }
	ax1=dm(i0,m0);                  { Get oldest sample from delay line }

	dm(i1,m0)=ax0;                  { Put sample into filter }
	mr=0,mx0=dm(i1,m0), my0=pm(i4,m4); { Do the hilbert filtering }
	cntr=HILBERT_SIZE-1;
	do hilbert until ce;
hilbert:   mr=mr+mx0*my0(ss),mx0=dm(i1,m0),my0=pm(i4,m4);
	mr=mr+mx0*my0(rnd);
	ay0=mr1;

{----------------------------------------------------------------------------}
{ Convert frequency (Hz) to an angle in radians (Q15 format) 		     }
{ The routine on page 53 of the Digital Signal Processing Applications,      }
{ Vol 1., uses a scheme where 360 degrees corresponds to FFFFh (65535).	     }
{ This represents a range of 0 - FFFF, 65536 representations.	             }
{ To convert any angle in degrees to the equivalent binary value using this  }
{ system, use the following formula:                                         }
{									     }
{									     }
{	   Binary equivalent = (Fx/Fs) * 65536	       		             }
{ ..... Where Fx= the given angle in degrees, 				     }
{             Fs= sampling rate (SPS)     				     }
{									     }
{ This for Fs=18.9 kSPS, the factor is (3.46751)			     }
{ One way to factor this is (1/18.9)*(1/1000)*2^16=(0.05291)*(0.001)*2^16    }
{ Or use Adrian's formula and multiply the final result by 0.42328 (362Eh)   }
{----------------------------------------------------------------------------}
	ar=dm(bfo_freq);
	ar=abs ar;
	si=ar;
	sr=ashift si by 3 (hi);         { Multiply Hz by 8 }
	my0=0x4189;                     { Multiply by 0.512 }
	mr=sr1*my0(rnd);                { Multiply by 2 }
	sr=ashift mr1 by 1 (hi);        { ie Hz * 8.192 }
	my0=0x362E;			{ 0.42328 }
	mr=sr1*my0(SS);

{ ----- Perform x(n) * exp(-jwn)                                  ------}
	ay1=dm(acc_ph);
	ar=mr1+ay1, my0=ay0;            { Get and update accum phase (use mr1) }
	ay1=0xffff;
	if ac ar=ar-ay1;
	dm(acc_ph)=ar;
	ax0=ar;
	call sin;                       { Generate sin(x) }
	mr=ar*my0(ss), my0=ax1;         { Xi(t)*Im[exp(-jwt)] }
	dm(ovr)=mr2;
	dm(high)=mr1;
	dm(low)=mr0;
	ay0=0x4000;                     { Xr(t)*Re[exp(-jwt)] }
	ar=ax0+ay0;
	ax0=ar;				{ Generate cos(x) }
	call sin;
	af=pass ar;                     { Switch sideband according to the }
	ar=dm(bfo_freq);                { sign of the BFO frequency offset. }
	ar=pass ar;                     { LSB for -ve offset, USB for +ve. }
	if ge jump upper_sideband;
	ar=-af;
	jump select_sideband;
upper_sideband:
	ar=pass af;
select_sideband:
	mr0=dm(low);
	mr1=dm(high);
	mr2=dm(ovr);
	mr=mr+ar*my0(rnd);              { Get real part Re[X(n)*exp(-jwn)] }
	ar=mr1;                         { BFO output returned in ar }

	dm(hdelay_ptr)=i0;
	dm(hdat_ptr)=i1;

	rts;


{ Coefficients for Hilbert filter }
.var/pm   hilbert_coeffs[HILBERT_SIZE];
.init24   hilbert_coeffs: 
     0x000000,
     0xfb3500,
     0x000000,
     0xfa9200,
     0x000000,
     0xf9bc00,
     0x000000,
     0xf89800,
     0x000000,
     0xf6f300,
     0x000000,
     0xf45c00,
     0x000000,
     0xefb400,
     0x000000,
     0xe4d700,
     0x000000,
     0xae8400,
     0x000000,
     0x517c00,
     0x000000,
     0x1b2900,
     0x000000,
     0x104c00,
     0x000000,
     0x0ba400,
     0x000000,
     0x090e00,
     0x000000,
     0x076800,
     0x000000,
     0x064500,
     0x000000,
     0x056f00,
     0x000000,
     0x04cb00,
     0x000000;

.ENDMOD;
