# diyhio.tcl
# file I/O routines for DIYHelp program
# HTML file version 
# by bitwrit software

proc ExtractFileDescription nextline {
 set linkbegin [ string first =\" $nextline ]
 if { $linkbegin >= 0 } {
  incr linkbegin 2
  set linkend [ string first \"> $nextline ]
  if { $linkend >= 0 } {
   incr linkend -1
   set fdbegin [ expr $linkend + 3 ]
   set fdend [ string first </ $nextline ]
   if { $fdend >= 0 } {
    incr fdend -1
    return [ list [ string range $nextline $linkbegin $linkend ]\
     [ string range $nextline $fdbegin $fdend ] ]
   }
  }
 }
 return [ list ]
}

proc ExtractConf nextline {
 set nextcnf [ split $nextline "=<" ]
 if { [ llength $nextcnf ] > 1 } {
  return [ lrange $nextcnf 0 1 ]
 }
 return ""
}

# ReadDIYHelpList
# Argument: path/filename of keyword/helpfiles list
# Return value: list containing:
#	0 - configuration information for this help file
#	1 -> end - current keywords/file descriptions read from file

proc ReadDIYHelpList diyhelpfile {
 global cnflist
 global diylist
 
 set keyword ""
 set cnflist [ list ]
 set diylist [ list ]
 set kwlist [ list ]
 set endcnf 0
 set filerror [ catch { set diyhstream [ open $diyhelpfile r ] } ]
 if { ! $filerror } {
  while { ! [ eof $diyhstream ] } {
   gets $diyhstream nextline
   # puts $nextline
   # check for a leading "<"
   if { ! [ string first < $nextline ] } {
    switch -exact [ string range $nextline 1 3 ] {
     /dl {
      lappend diylist [ list $keyword $kwlist ]
      set kwlist [ list ]
     }
     dl> {
      set keyword [ string range $nextline 4 end ]
     }
     dd> {
      set nextfd [ ExtractFileDescription $nextline ]
      if { [ llength $nextfd ] } {
       lappend kwlist $nextfd
      }
     }
     default {}
    }
   } else {
    if { [ string first = $nextline ] >= 0 } {
     set nextcnf [ ExtractConf $nextline ]
     if { [ llength $nextcnf ] } {
      lappend cnflist $nextcnf
     }
    }
   }
  }
  close $diyhstream
  return [ list $cnflist $diylist ]
 }
 return ""
}

proc ReadBrowserList browserfile {
 
 set browser ""
 set extlist [ list ]
 set browserlist [ list ]
 set endcnf 0
 set filerror [ catch { set browserstream [ open $browserfile r ] } ]
 if { ! $filerror } {
  while { ! [ eof $browserstream ] } {
   gets $browserstream nextline
   # check for a leading "<"
   if { ! [ string first < $nextline ] } {
    switch -exact [ string range $nextline 1 3 ] {
     /dl {
      lappend browserlist [ list $browser $extlist ]
      set extlist [ list ]
     }
     dl> {
      set browser [ string range $nextline 4 end ]
     }
     dd> {
      set endext [ string last < $nextline ]
      if { $endext > 5 } {
       incr endext -1
       set nextext [ string range $nextline 4 $endext ]
       lappend extlist $nextext
      }
     }
     default {}
    }
   }
  }
  close $browserstream
  return $browserlist
 }
 return ""
}

proc SaveDIYHelpQuery { helpfile cnflist diylist } {

 set savequery "Save $helpfile?"
 if { ! [ tk_dialog .savediy SaveDIY "Save new help list?" {} 0 Yes No Cancel ] } {
  return [ SaveDIYHelpList $helpfile $cnflist $diylist ]
 }
 return 1
}

proc SaveDIYHelpList { helpfile cnflist diylist } {

 if { ! [ catch { set diyhstream [ open $helpfile w ] } ] } {
  puts $diyhstream "<html>"
  puts $diyhstream\
   "<!- this is a generated file - if you edit it, adhere to this format!>"
  foreach item $cnflist {
   puts $diyhstream "[ lindex $item 0 ]=[ lindex $item 1 ]<br>"
  }
  set diylist [ lsort $diylist ]
  foreach kwlist $diylist {
   puts $diyhstream "<dl>[ lindex $kwlist 0 ]"
   foreach filedesc [ lindex $kwlist 1 ] {
    puts -nonewline $diyhstream "<dd><a href=\"[ lindex $filedesc 0 ]\">"
    puts $diyhstream "[ lindex $filedesc 1 ]</a></dd>"
   }
   puts $diyhstream "</dl>"
  }
  puts $diyhstream "</html>"
  close $diyhstream
  return 0
 }
 return 1
}
