#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

#LCA (Latent Class Analysis) - model klas ukrytych
#Estymacja modelu z wykorzystaniem pakietu poLCA
#Dane symulacyjne - wartoci nominalnych (dychotomicznych) zmiennych obserwowanych 1 lub 2, wartoci zmiennych towarzyszcych o rozkadzie normalnym
#Cel analizy: wybr liczby klas na podstawie kryteriw informacyjnych AIC i BIC
library(poLCA)
options(OutDec=",")
#Generowanie danych, 6 zmiennych obserwowanych dychotomicznych Y1-Y6,3 zmienne obserwowane politomiczne Y7-Y9, 6 zmiennych towarzyszcych X1-X6
set.seed(3210)
probs<-list(matrix(c(0.2,0.8,         0.8,0.2,         0.8,0.2         ),ncol=2,byrow=TRUE),
            matrix(c(0.2,0.8,         0.8,0.2,         0.8,0.2         ),ncol=2,byrow=TRUE),
            matrix(c(0.2,0.8,         0.8,0.2,         0.8,0.2         ),ncol=2,byrow=TRUE),
            matrix(c(0.3,0.6,0.1,     0.6,0.3,0.1,     0.3,0.6,0.1     ),ncol=3,byrow=TRUE),
            matrix(c(0.3,0.6,0.1,     0.6,0.3,0.1,     0.3,0.6,0.1     ),ncol=3,byrow=TRUE),
            matrix(c(0.3,0.6,0.1,     0.6,0.3,0.1,     0.3,0.6,0.1     ),ncol=3,byrow=TRUE),
            matrix(c(0.1,0.1,0.3,0.5, 0.5,0.3,0.1,0.1, 0.5,0.3,0.1,0.1 ),ncol=4,byrow=TRUE),
            matrix(c(0.1,0.1,0.3,0.5, 0.5,0.3,0.1,0.1, 0.5,0.3,0.1,0.1 ),ncol=4,byrow=TRUE),
            matrix(c(0.1,0.1,0.3,0.5, 0.5,0.3,0.1,0.1, 0.5,0.3,0.1,0.1 ),ncol=4,byrow=TRUE))
danesym1<-poLCA.simdata(N=1125,probs,ndv=9,niv=6,nclass=3)
dane<-danesym1$dat
print(dane[1:20,c(1:4,7:9,10:12,15)])
#Model 1 - zmienne obserwowane Y1-Y9, zmienne towarzyszce X1, X2, klasy 2, 3, 4
model<-cbind(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,Y9)~X1+X2
lk<-c(2:4)	#liczba klas
BIC<-numeric(3)
AIC<-numeric(3)
for(k in 2:4)
{
  lc<-poLCA(model,dane,nclass=k,nrep=3,graph=FALSE,verbose=FALSE)
  probs.start<-poLCA.reorder(lc$probs.start,order(lc$P,decreasing=FALSE))
  lc<-poLCA(model,dane,nclass=k,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
  BIC[k-1]<-lc$bic
  AIC[k-1]<-lc$aic
}
bicaic<-cbind(BIC,AIC)
print(bicaic)
windows(width=8,height=4,pointsize=7)	#okno graficzne
par(mfrow=c(1,2),las=1)				#2 wykresy
matplot(lk,bicaic,main="model<-cbind(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,Y9)~X1+X2",font.main=1,xlim=c(1,5),type="l",xlab="liczba klas",ylab="")
text(5,BIC[3],"BIC")
text(5,AIC[3],"AIC")
#Model 2 - zmienne obserwowane Y1-Y9, zmienne towarzyszce X2, X3, X6, klasy 2, 3, 4
model<-cbind(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,Y9)~X1+X2+X3+X4+X5+X6
for(k in 2:4)
{
  lc<-poLCA(model,dane,nclass=k,nrep=3,graph=FALSE,verbose=FALSE)
  probs.start<-poLCA.reorder(lc$probs.start,order(lc$P,decreasing=FALSE))
  lc<-poLCA(model,dane,nclass=k,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
  BIC[k-1]<-lc$bic
  AIC[k-1]<-lc$aic
}
bicaic<-cbind(BIC,AIC)
print(bicaic)
matplot(lk,bicaic,main="model<-cbind(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,Y9)~X1+X2+X3+X4+X5+X6",font.main=1,xlim=c(1,5),type="l",xlab="liczba klas",ylab="")
text(5,BIC[3],"BIC")
text(5,AIC[3],"AIC")
