/*
 * mangle.c
 *
 * This file is part of "locatedir"
 * by Alexander Kourakos <awk@vt.edu>
 *
 * Copyright (C) 1994 Alexander Kourakos
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice remains unchanged on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the author.
 *
 * There is no warranty or other guarantee of this software fitness
 * for any purpose. It is provided solely "as is".
 */

#include "locatedir.h"

/*
 * This function chops off the starting directory from a path, and
 * then reverses the elements.
 */

void
mangle (char *path)
{
  char    path_copy[MAX_PATH_LENGTH];
  char   *strp;

  strcpy (path_copy, path + strlen (startpath));

  TRUNC_LAST_CHAR (path_copy);
  path[0] = '\0';

  while ((strp = strrchr (path_copy, DIR_SEP_CHAR)) != NULL)
  {
    strcat (path, strp + 1);
    strcat (path, DIR_SEP);
    *strp = '\0';
  }

  /*
   * This is a most horrible hack.
   */

  if (!strcmp (startpath, DIR_SEP))
  {
    strcat (path, path_copy);
    strcat (path, DIR_SEP);
  }

  if (*path != '\0')
    path[strlen (path) - 1] = '\n';
}

/*
 * This function does the opposite of the above one.
 */

void
demangle (char *path)
{
  char    path_copy[MAX_PATH_LENGTH];
  char   *strp;

  strcpy (path_copy, path);
  TRUNC_LAST_CHAR (path_copy);

  if (strcmp (startpath, DIR_SEP))
    strcpy (path, startpath);
  else
    *path = '\0';

  while ((strp = strrchr (path_copy, DIR_SEP_CHAR)) != NULL)
  {
    strcat (path, strp);
    *strp = '\0';
  }
  strcat (path, DIR_SEP);
  strcat (path, path_copy);
}

/*
 * end of file 
 */
