/***
 *** parse_clock.h
 *** clock configuration parsing code for SVGATextMode
 *** (c) 1995 Koen Gadeyne (kmg@barco.be)
 ***/

#ifndef _PARSE_CLOCK_H
#define _PARSE_CLOCK_H

#include "setclock.h"

/* the different types of clock definitions possible. Some are mutually exclusive */
#define CK_NONE           0
#define CK_SET_OF_CLOCKS  (1<<0)
#define CK_CLOCKCHIP      (1<<1)
#define CK_CLOCKPROG      (1<<2)

/* the return structure. Only part of it will be used, depending on clock type */
typedef struct t_clockdef {
    int type;                        /* clock programming type (see above) */
    int num_clocks;                  /* number of clocks in clocks line, and thus in array below */
    float clocks[MAX_CLOCKS*2];      /* if used: array of clock values */
    int clockchiptype;               /* is used: ClockChip type */
    char ck_prog_path[1024];         /* is used: path to ClockProg */
    float maxclock;                  /* maximum allowed clock ("DacSpeed") */
} t_clockdef;

t_clockdef* parse_clock(FILE* configfile, int chipset, t_clockdef* clockdef);

#endif

