/***
 *** configuration defines SVGATextMode
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _CONFDEFS_H
#define _CONFDEFS_H


/*
 * Supported Chipsets
 */

#define NUM_CHIPSETS      14
#define CS_NONE       -1
#define CS_VGA        0
#define CS_S3         1
#define CS_CIRRUS     2
#define CS_ET4000     3
#define CS_TVGA8900   4
#define CS_TVGA9000   5
#define CS_PVGA1      6
#define CS_WDC90C0X   7
#define CS_WDC90C1X   8
#define CS_WDC90C2X   9
#define CS_WDC90C3X   10
#define CS_ATI        11
#define CS_ATIMACH32  12
#define CS_VIDEO7     13

#define CHIPSET_STRINGS   { "VGA",\
                            "S3" , "CLGD542x", "ET4000" , "TVGA8900" , "TVGA9000" ,\
                            "PVGA1" , "WDC90C0X" , "WDC90C1X" , "WDC90C2X" , "WDC90C3X" ,\
                            "ATI" , "ATIMACH32" , "VIDEO7" }
/*
 * Supported Options
 * These are single-bit values, allowing one option string to set multiple single options!
 */

#define NUM_OPTIONS      13

#define OPT_HIBIT_LOW      (1 << 0)
#define OPT_HIBIT_HIGH     (1 << 1)
#define OPT_ET4000_ALTCLK  (1 << 2)
#define OPT_SWAP_HIBIT     (1 << 3)
#define OPT_LEGEND         (1 << 4)
#define OPT_FAST_DRAM      (1 << 5)
#define OPT_MED_DRAM       (1 << 6)
#define OPT_SLOW_DRAM      (1 << 7)
#define OPT_XFAST_DRAM     (1 << 8)
#define OPT_LOADFONT       (1 << 9)
#define OPT_CLOCKDIV2      (1 << 10)
#define OPT_NUMBER_NINE    (1 << 11)
#define OPT_SPEA_MERCURY   (1 << 12)


/* option strings: same order as option numbers! */
#define OPTION_STRINGS   { "HIBIT_LOW" , "HIBIT_HIGH" , "ET4000_AltClockSel" , "SWAP_HIBIT" , "Legend" ,\
                           "Fast_DRAM" , "Med_DRAM" , "Slow_DRAM" , "XFast_DRAM" , "LoadFont" ,\
                           "ClockDiv2" , "Number_Nine" , "SPEA_Mercury" }

/* allowed options per chipset (in bit mask format) */
#define OPTIONS_ALLOWED   { OPT_LOADFONT | OPT_CLOCKDIV2,   /* VGA */\
                            OPT_LOADFONT | OPT_CLOCKDIV2 | OPT_NUMBER_NINE | OPT_LEGEND | OPT_SPEA_MERCURY,   /* S3 */\
                            OPT_LOADFONT | OPT_FAST_DRAM | OPT_MED_DRAM | OPT_SLOW_DRAM | OPT_XFAST_DRAM,   /* Cirrus */\
                            OPT_LOADFONT | OPT_CLOCKDIV2 | OPT_HIBIT_LOW | OPT_HIBIT_HIGH | OPT_ET4000_ALTCLK | OPT_LEGEND,\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* TVGA8900 */\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* TVGA9000 */\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* PAVGA1 */\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* WDC90C0X */\
                            OPT_LOADFONT | OPT_CLOCKDIV2 | OPT_SWAP_HIBIT,  /* WDC90C1X */\
                            OPT_LOADFONT | OPT_CLOCKDIV2 | OPT_SWAP_HIBIT,  /* WDC90C2X */\
                            OPT_LOADFONT | OPT_CLOCKDIV2 | OPT_SWAP_HIBIT,  /* WDC90C3X */\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* ATI */\
                            OPT_LOADFONT | OPT_CLOCKDIV2,   /* ATIMACH32 */\
                            OPT_LOADFONT | OPT_CLOCKDIV2    /* VIDEO7 */\
                          }


/*
 * Supported Register Sets
 */
 
#define RT_INDEX         1
#define RT_MEMMAP        2

#define NUM_REGSETS      8
enum t_regset            { REGSET_CRTC = 0 , REGSET_SEQ = 1 , REGSET_ATRCTL = 2, REGSET_GRCTL = 3, REGSET_MISC = 4,\
                           REGSET_DAC_STATUS, REGSET_DAC_MASK, REGSET_DAC };
#define REGSET_STRINGS   { "CRTC" , "SEQ" , "ATRCTL" , "GRCTL", "MISC" ,"DAC_STATUS", "DAC_MASK", "DAC" }
#define REGSET_TYPE      { RT_INDEX, RT_INDEX, RT_INDEX, RT_INDEX, RT_MEMMAP, RT_MEMMAP, RT_MEMMAP, RT_INDEX }



#endif

