/***
 *** clockprobe
 *** Copyright (c) 1995 by Koen Gadeyne (kmg@barco.be)
 ***
 *** Try to measure CURRENT pixel clock.
 *** Should work on ANY VGA card, since it only uses standard VGA registers
 ***
 *** - No need to disable interrupts to be able to measure! (the probe in the X-server does, because it doesn't use timers). 
 *** - Can give slightly inaccurate results on heavily loaded machines (but normally not VERY wrong)
 *** - Due to unexplained "glitches" in the vertical sync register, some timing attempts go wrong.
 ***   this is detected in the program, and it tries again.
 ***   Does anyone know WHY those glitches are there, and how to circumvent them?
 *** - has the tendency to over-estimate the clock rate by about 0.1 MHz. No real clue why... (or is it just on MY machine?)
 ***
 *** There should even be a possibility to measure H-frequencies using input status 1 bit 0 (0x3DA, bit 0).
 ***
 ***/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <asm/io.h>

#include "misc.h"
#include "vga_prg.h"
#include "confdefs.h"
#include "messages.h"
#include "probe.h"

char *CommandName;
int debug_messages=FALSE;


void usage()
{
     PMESSAGE(("version %s. (c) 1995 Koen Gadeyne.\n Usage: %s [options] \n\n\
     Options: -n  Don't program VGA hardware\n\
              -d  print debugging information\n\
              -h  print usage information\n",
     VERSION, CommandName));
}

/***********************************************************************************************************/
 
int main (int argc, char* argv[])
{
  int program_hardware=TRUE;
  char c;
  long totalh, totalv;
  float pclock;
  
  CommandName = argv[0];
 
 /*
  * command-line argument parsing
  */

  while ((c = getopt (argc, argv, "ndh")) != EOF)
    switch (c)
    {
      case 'n': program_hardware=FALSE;
                break;
      case 'd': debug_messages=TRUE;
                break;
      case 'h': usage();
                exit(0);
                break;
      case '?': usage();
                PERROR(("Bad option '-%c'\n",(char)optopt));
                exit(-1);
                break;
      default: PERROR(("getopt returned unknown token '%c'.",c));
    }

/*
 * get all relevant parameters
 */
 
 if (program_hardware)
  {
     get_VGA_io_perm(CS_VGA);
     unlock(CS_VGA); /* unlock standard VGA locked registers */
     totalv = Get_VERT_TOTAL();
     totalh = Get_HOR_TOTAL() * get_charwidth();
     PWARNING(("Please be patient. This may take a while (up to 1 minute)"));
     pclock = pixclock(totalh, totalv);
     PMESSAGE(("Estimated vertical scanrate = %1.3f Hz.", (pclock/totalh/totalv)*1000000));
     PMESSAGE(("Estimated horizontal scanrate = %1.3f kHz.", (pclock/totalh)*1000));
     PMESSAGE(("Estimated pixel clock = %1.2f MHz", pclock));
     if (Inb_SEQ(1) & 0x08) PMESSAGE(("NOTE: actual clock is %1.2f MHz, but it is divided by 2.", pclock*2));
  }
  return(0);
}
