/*----------------------------------------------------------------------
 *
 * Program: 	dcf77clock
 *
 * File:  	tcap.c		
 *
 * Edition	History:  
 *                                                                
 * #    Date        			Comments                   by  
 * -- --------  ----------------------------------------------    ---- 
 * 01 22/02/88	Created                                           wpsk
 * 02 10/06/93  Add code to get LI and CO from the 'winsize'
 *	        structure, defined by <sys/termios.h>.
 *		
 *
 * Last Edition:  8. May 1994
 *
 *----------------------------------------------------------------------*/
 
#include 	<stdio.h>
#include	<termios.h>
#include 	"clock.h"

extern char *tgoto();		/* termcap cursor position command */
extern char *tgetstr();		/* get string code from termcap */
extern int  tgetflag();		/* get boolian flag from termcap */
extern int  tgetnum();		/* get numeric code from termcap */
extern void tputs();		/* termcap put data command */
extern char *malloc(), *getenv();

void outc();
char *testnull();		/* Don't return NULL pointers! */


int	LI, CO, xmax, ymax;

char	*BC, *CL, *CM, *CD, *CE, *VI, *VE, *SO, *SE;
char	*US, *UE, *UP, *IS, *KS, *KE, *MD, *MB, *ME;

char	*C0, *C1, *C2, *C3, *C4, *C5, *C6, *C7;
char	*D0, *D1, *D2, *D3, *D4, *D5, *D6, *D7;

char	*GA, *GB, *GC, *GD, *GE, *GF, *GG, *GH, *GI, *GJ, *GK;
char	*GL, *GM, *GN, *GO, *GS, *GX;



char	*terminal,
	PC,
	*p;

short	ospeed;


/*
 *   Read termcap entry
 */

void inittcap()
{

char	*paddc,
	*tcapbuf,
	tcbuf[2024];


	if ((terminal = getenv("TERM")) == NULL) {
		puts("Environment TERM not defined!");
		exit(1);
	}

	/*
	 * Read the hole termcap string to tcbuf[]
	 */
	switch(tgetent(tcbuf, terminal)) {
		case -1:
			fprintf(stderr, "Can't open TERMCAP database\n");
			exit(1);
		case 0:
 			fprintf(stderr, "Terminal '%s' not known\n", terminal);
			exit(1);
		default:
			break;
        }
	if ((p = tcapbuf = malloc(2024)) == NULL) {
		fprintf(stderr,"out of space\n");
		exit(1);
	}

	PC  = (((paddc = tgetstr("pc", &p)) == NULL) ? 0 : *paddc);

        CL = tgetstr("cl", &p);		/* clear screen			*/
        CD = tgetstr("cd", &p);		/* clear end of screen 		*/
        CE = tgetstr("ce", &p);		/* clear end of line		*/
        CM = tgetstr("cm", &p);		/* cursor motion 		*/
	US = tgetstr("us", &p);		/* underscore on 		*/
	UE = tgetstr("ue", &p);		/* underscore off 		*/
	MD = tgetstr("md", &p);		/* bold character on		*/
	MB = tgetstr("mb", &p);		/* blinking on			*/
	ME = tgetstr("me", &p);		/* bold / blink / underscore off*/
	VI = tgetstr("vi", &p);		/* cursor off 			*/
	VE = tgetstr("ve", &p);		/* cursor on 			*/
	SO = tgetstr("so", &p);		/* invers on 			*/
	SE = tgetstr("se", &p);		/* invers off 			*/
	UP = tgetstr("up", &p);		/* cursor up			*/
	GA = tgetstr("ga", &p);		/* round  lower  left  corner 	*/
	GB = tgetstr("gb", &p);		/*   "    upper  left	"	*/
	GC = tgetstr("gc", &p);		/*   "    upper  right	"	*/
	GD = tgetstr("gd", &p);		/*   "    lower  right	"	*/
	GE = tgetstr("ge", &p);		/* normal lower  left	"	*/
	GF = tgetstr("gf", &p);		/*   "	  upper  left   "	*/
	GG = tgetstr("gg", &p);		/*   "	  upper  right  "	*/
	GH = tgetstr("gh", &p);		/*   "	  lower  right  "	*/
	GI = tgetstr("gi", &p);		/* crosspoint 			*/
	GJ = tgetstr("gj", &p);		/* vertical line 		*/
	GK = tgetstr("gk", &p);		/* horizontal line		*/
	GL = tgetstr("gl", &p);		/* vertical line left  branch	*/
	GM = tgetstr("gm", &p);		/* vertical line right branch	*/
	GN = tgetstr("gn", &p);		/* horizontal lower branch	*/
	GO = tgetstr("go", &p);		/* horizontal upper branch	*/
	GS = tgetstr("gs", &p);		/* change to graphic mode	*/
	GX = tgetstr("gx", &p);		/* return to normal  mode	*/

	C0 = tgetstr("c0", &p);		/* foreground color black	*/
	C1 = tgetstr("c1", &p);		/* foreground color red		*/
	C2 = tgetstr("c2", &p);		/* foreground color green	*/
	C3 = tgetstr("c3", &p);		/* foreground color yellow	*/
	C4 = tgetstr("c4", &p);		/* foreground color blue	*/
	C5 = tgetstr("c5", &p);		/* foreground color magenta	*/
	C6 = tgetstr("c6", &p);		/* foreground color cyan	*/
	C7 = tgetstr("c7", &p);		/* foreground color white	*/

	D0 = tgetstr("d0", &p);		/* background color black	*/
	D1 = tgetstr("d1", &p);		/* background color red		*/
	D2 = tgetstr("d2", &p);		/* background color green	*/
	D3 = tgetstr("d3", &p);		/* background color yellow	*/
	D4 = tgetstr("d4", &p);		/* background color blue	*/
	D5 = tgetstr("d5", &p);		/* background color magenta	*/
	D6 = tgetstr("d6", &p);		/* background color cyan	*/
	D7 = tgetstr("d7", &p);		/* background color white	*/


	get_win_size();
	
	if (CL == NULL || CM == NULL || UP == NULL) {
		puts("Incomplete termcap entry\n");
		exit(1);
	}
}


/*------  Return no NULL pointers! ----------*/

char *testnull(str)	
char *str;
{
	if(!str) return("");
	else	 return(str);
}

/*------ Execute termcap entry with tputs() ------*/	

setcapability(str)	
char  *str;
{
        if (str) tputs(str,0,outc);
}

/*--- invers on ---*/ 
invon()
{
	if (SO) tputs(SO, 0, outc);
}

/*--- invers off ---*/
invoff()
{
        if (SE) tputs(SE, 0, outc);
}

/*--- underscore on ---*/ 
underscore_on()
{
	if (US) tputs(US, 0, outc);
}

/*--- underscore off ---*/
underscore_off()
{
        if (UE) tputs(UE, 0, outc);
}

/*--- blinking on ---*/
blink_on()
{
	if (MB) tputs(MB, 0, outc);
}

/*--- blinking off ---*/
blink_off()
{
        if (ME) tputs(ME, 0, outc);
}

/*--- bold on ---*/


bold_on()
{
	if (MD && !X11_flg) tputs(MD, 0, outc);
}

/*--- bold off ---*/
bold_off()
{
        if (ME && !X11_flg) tputs(ME, 0, outc);
}


/*--- clear to end of screen ---*/

clearscreen()	
{
REG i;
	tputs (tgoto(CM, 0, 0), LI, outc);  
        if (CL) {	 
        	tputs(CL,0,outc);
		return TRUE;
	}
	else if (CD) {
		tputs(CD,0,outc);
		return TRUE;
	}
        else if (CE) {
        	for(i = 0; i <= LI; i++) {
			tputs (tgoto(CM, 0, i), 1, outc);  
			tputs(CE,0,outc);
        	}
		return TRUE;
	}
	return FALSE;
}

/*--- clear to end of line ---*/

clreol()
{
	if (CE) tputs(CE, 0, outc);
}

/*--- clear to end of screen ---*/

clreos()
{
	if (CD) tputs(CD, 0, outc);
}

/*--- goxy() : set cursor to position x colon and y line ---*/

goxy(x,y)
REG int  x, y;
{
	tputs(tgoto(CM, x, y), LI, outc);  
}   

/*------- write a char to stdout  ------*/ 

void  outc(c)
char c;
{
	write(1,&c,1);
}

/*--------------------------------------------------------------------------
 	graphic with second character fond
----------------------------------------------------------------------------*/

/*------ set lower left round corner --------*/
  g_llrc()	
{
	if (GA)	tputs(GA,0,outc);
	else	tputs("+",0,outc);	
}


/*------ set upper left round corner --------*/
  g_ulrc()	
{
	if (GB)	tputs(GB,0,outc);
	else	tputs("+",0,outc);
}


/*------ set upper right round corner --------*/
  g_urrc()	
{
	if (GC) tputs(GC,0,outc);
	else	tputs("+",0,outc);
}


/*------ set lower right round corner --------*/
  g_lrrc()	
{
	if (GD)	tputs(GD,0,outc);
	else	tputs("+",0,outc);
}


/*------ set lower left normal corner --------*/
  g_llnc()	
{
	if (GE)	tputs(GE,0,outc);
	else	tputs("+",0,outc);
}


/*------ set upper left normal corner --------*/
  g_ulnc()	
{
	if (GF)	tputs(GF,0,outc);
	else	tputs("+",0,outc);
}


/*------ set upper right normal corner --------*/
  g_urnc()	
{
	if (GG)	tputs(GG,0,outc);
	else	tputs("+",0,outc);
}


/*------ set lower right normal corner --------*/
  g_lrnc()	
{
	if (GH)	tputs(GH,0,outc);
	else	tputs("+",0,outc);
}


/*------ set crosspoint --------*/
  g_crosp()	
{
	if (GI)	tputs(GI,0,outc);
	else	tputs("+",0,outc);
}


/*------ set vertical line ------*/
  g_verline()	
{
	if (GJ)	tputs(GJ,0,outc);
	else	tputs("|",0,outc);
}


/*------ set horizontal line ------*/
  g_horline()	
{
	if (GK)	tputs(GK,0,outc);
	else	tputs("-",0,outc);
}


/*------ branch right horizontal  -|  ------*/
  g_brrhor()	
{
	if (GL)	tputs(GL,0,outc);
	else	tputs("+",0,outc);
}


/*------ branch left horizontal |-   ------*/
  g_brlhor()	
{
	if (GM)	tputs(GM,0,outc);
	else	tputs("+",0,outc);
}


/*------ branch upper vertical      -----     ----*/
/*                                    |           */  
  g_bruver()	
{
	if (GN)	tputs(GN,0,outc);
	else	tputs("+",0,outc);
}


/*------ branch lower vertical        |    -------*/
/*                                  ------        */  
  g_brlver()	
{
	if (GO)	tputs(GO,0,outc);
	else	tputs("+",0,outc);
}


/*------ switch graphic character set on ------*/
  g_on()	
{
	if (GS)	tputs(GS,0,outc);
}


/*------ switch graphic character set off ------*/
  g_off()	
{
	if (GX) tputs(GX,0,outc);
}

/*------ forground and background colors ------------*/

fgc(cn)
int cn;
{
	switch (cn) {
		case 0:	if (C0) tputs(C0,0,outc); break;
		case 1:	if (C1) tputs(C1,0,outc); break;
		case 2:	if (C2) tputs(C2,0,outc); break;
		case 3:	if (C3) tputs(C3,0,outc); break;
		case 4:	if (C4) tputs(C4,0,outc); break;
		case 5:	if (C5) tputs(C5,0,outc); break;
		case 6:	if (C6) tputs(C6,0,outc); break;		
		case 7:	if (C7) tputs(C7,0,outc); break;
		default: break;
	}
}

bgc(cn)
int cn;
{
	switch (cn) {
		case 0:	if (D0) tputs(D0,0,outc); break;
		case 1:	if (D1) tputs(D1,0,outc); break;
		case 2:	if (D2) tputs(D2,0,outc); break;
		case 3:	if (D3) tputs(D3,0,outc); break;
		case 4:	if (D4) tputs(D4,0,outc); break;
		case 5:	if (D5) tputs(D5,0,outc); break;
		case 6:	if (D6) tputs(D6,0,outc); break;		
		case 7:	if (D7) tputs(D7,0,outc); break;
		default: break;
	}
}

/*------ switch cursor on ------*/

cursor_on()
{
        if (VE) tputs(VE,0,outc);
}

/*------ switch cursor off ------*/

cursor_off()
{
	if (VI) tputs(VI,0,outc);
}



/*------ get window size from structur 'winsize' ------*/

struct winsize win;

get_win_size()
{
	if (ioctl(1, TIOCGWINSZ, &win) != -1 && win.ws_col > 0) {
		CO = win.ws_col;
		LI = win.ws_row;
	}
	else {
		CO = tgetnum("co");
		LI = tgetnum("li");
	}
	xmax = CO - 1;
	ymax = LI - 1;
}


