/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
/* Runtime support system header file */

/* all the include files you could wish for */
#include <ctype.h>
#include <malloc.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <values.h>

#include "../../versions.h"	/* where 'build' is found */
#include "../../configure.h"	/* where the setup locations are determined */

#include "parser.tab.h" 

/* marker where to insert number to call back */
#define MARKER		"$PHONE"

/* entries in line-dependent files */
typedef enum
{
	the_orgfile,
	the_cbfile,
	the_tmpfile,
	the_statefile,
	the_destfile,
	the_disfile,
	the_modemfile,
	sizeof_the_file_enum,
} THE_FILE_ENUM_;

typedef enum			    /* the callback modi */
{
    phone_mode,
    direct_mode,
    extra_mode,
} MODE_;

typedef enum
{
    log_off,
    log_default,
    log_on,
} LOG_TYPE_;

typedef enum
{
    mode_callback,
    mode_dialin,
} CB_MODE_;

typedef struct
{
    char
	*name;
    unsigned 
	*groups,		    /* group-index vector */
	ngroups;
} USER_;

typedef struct
{
    unsigned
	group,			    /* groupindex   */
	target;			    /* target-index */
    char
	*filename,		    /* filename if a special file */
	*modevalue;		    /* phone number if a callback */
    MODE_
	mode;			    /* callback mode for this group */
} DESTINATION_;

typedef struct
{
    char
	*target;		    /* targetname */
    unsigned
	usergroup;		    /* index of a user-selected group */
} TARGET_;

extern char
    s_callback[],
    s_disable[],
    s_enable[],
    s_state[],
    *base_path,
    *tmp_filename,
    *log_filename,
    *diallog_filename,
    *panic_filename,
    *login_program,
    *email_address,
    *modem_getty,
    *getty_path,
    **gvector,			    /* vector of group-id's */
    *expect,				/* used by the parser */
    *filename[],
    out_of_memory[],
    qq[],			    /* "??" */
    *tty_line,
    *progname,			    /* program name, used by, e.g., logv() */
    *version,			    /* program version */
    *yytext;

extern unsigned
    log_defaults,			/* cb-flag to log the defaults */
    call,				/* don't use call by default */
    kill_processes,			/* by default assume killing ok */
    ndestinations,
    nusers,
    ntargets,
    ngroups,
    show_destinations,			/* by default on */
    show_direct,       			/* by default off */
    show_extra,       			/* by default off */
    show_phonenumbers,			/* by default off */
    ntries,				/* retries for callback */
    parse_errors,
    yylineno;

extern CB_MODE_
    cb_mode;

extern LOG_TYPE_
    log_type;

extern USER_				/* array of users */
    *user;

extern DESTINATION_			/* array of destinations */
    *destination;

extern TARGET_				/* array of targets */
    *target;

extern FILE
    *yyin;

void	    addgroup(char *groupname);	    /* adds a group to a user */
char	    *append_line(char *filename, char *line);	/* make file.line */
void	    ask_extra_number(unsigned uid, unsigned tid); /* ask extra ph */
void	    checkdefaults();		    /* check the defaults */
void	    clear_targets(void);	    /* clear target selection */
unsigned    combine(int uid, char *where);  /* check uid/tid match  */
void	    copyfile(char *in, char *out);  /* copies a file */
void	    define_group(char *groupname);  /* defines a group */
void	    define_user(char *username);    /* defines a user */
void	    enable_state(void);		    /* define: enable/state 0 */
void	    error(char *fmt, ...);	    /* generic error function */
char	    *fgetline(FILE *inf);	    /* get a line from a file */
char	    *getbuf(char *buf, unsigned len); /* read stdin -> buffer[len] */
unsigned    group_index(char *group);	    /* return (and add) a groupname */
unsigned    lookuser(char *username);	    /* return index of user */
unsigned    lookgroup(char *groupname);	    /* return index of user */

/*  int	    finduser(char *uname); */

int 	    getstate(int *state, unsigned *userid); /* get the state info */
char	    *linename(char *file, char *line);	/* apped linename to a file */
void	    listdestinations(int uid, int all);	/* info about user */
void	    log(LOG_TYPE_ minimum, char *fmt, ...); /* generic log function */
void	    logv(char *fmt, va_list args);	/* va-list log function */

void	    makenewdef(int uid, int tid);   /* create new callback file */
int	    newgroup(char *group);	    /* check new group */
void	    parse_setupfile(void);	    /* parse the setupfile */
void	    progversion(char *argv0, char *progversion);
void	    reinit();			    /* reinitialize init */
void	    setcallback(int uid, int tid);  /* determine the callbackfile */
void	    set_file(char *filename);	    /* define a callback-filename */
void	    set_mode(MODE_ mode);	    /* define a mode for a group */
void	    set_phone(char *phone);	    /* define a callback phonenumber */
void	    set_target(char *computer);	    /* relate a computer to a group */
void	    tag_targets(void);		    /* tag the targets of a user */
unsigned    target_index(char *target);	    /* index of a target */
void	    tty_names(char *line);
void	    writestate(int st, unsigned uid);	    /* write the statefile */
FILE	    *xfopen(char *fname, char *mode);	    /* protected fopen() */
void	    *xmalloc(unsigned size);		    /* protected malloc() */
void	    *xstrdup(char *s);			    /* protected strdup () */
void	    *xrealloc(void *mem, unsigned size);    /* protected realloc() */
int	    yyerror(char *s);
int	    yyparse(void);			    /* the parser */
void	    yysemantic(char *s);		    /* semantic error */
int	    yywrap(void);
