/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "rss.h"

void checkdefaults()
{
    char
	*cp;

    if
    (
	(cp = strrchr(base_path, '/')) ?    /* '/' char found */
	    cp[1]			    /* append if '/' not last char */
	:
	    1				    /* otherwise append '/' anyway */
    )
    {
	base_path = xrealloc(base_path, strlen(base_path) + 2);
	strcat(base_path, "/");
    }

    if (log_defaults)
    {
	if (cb_mode == mode_callback)
	    log
	    (
		log_off,
		"\n"
		"\tmode:                        callback\n"
		"\tthe default modem-ttyline:   %s\n"
		"\tauxiliary callback files in: %s\n"
		"\tlogfilename:                 %s\n"
		"\tdial-logfilename:            %s\n"
		"\tpanic logfilename:           %s\n"
		"\tlog type:                    %s\n"
		"\tgetty configuration files:   %s.ttyS?\n"
		"\tcallback's scratch-file:     %s\n"
		"\tmodem-getty reached via:     %s.ttyS?\n"
		"\tlogin program:               %s\n"
		"\temail address:               %s\n"
		"\tnumber of callback retries:  %d\n"
		"\tusing 'cb %swho where' to call users.\n"
		"\tprocesses %s be killed.\n"
		"\t'cb list' %s show phonenumbers.\n"
		, tty_line
		, base_path
		, log_filename
		, diallog_filename
		, panic_filename
		,
		    log_type == log_default ?
			"default"
		    :
			log_type == log_on ?
			    "extensive"
			:
			    "only errors"
		, getty_path
		, tmp_filename
		, modem_getty
		, login_program
		, email_address ? email_address : "not used"
		, ntries
		, call ? "call " : ""
		, kill_processes ? "will" : "won't"
		, show_phonenumbers ? "will" : "won't"
	    );
	else
	    log
	    (
		log_off,
		"\n"
		"\tmode:                        dial-in\n"
		"\tthe default modem-ttyline:   %s\n"
		"\tauxiliary callback files in: %s\n"
		"\tlogfilename:                 %s\n"
		"\tpanic logfilename:           %s\n"
		"\tlog type:                    %s\n"
		"\tgetty configuration files:   %s.ttyS?\n"
		"\tcallback's scratch-file:     %s\n"
		"\tmodem-getty reached via:     %s.ttyS?\n"
		"\temail address:               %s\n"
		"\tprocesses %s be killed.\n"
		, tty_line
		, base_path
		, log_filename
		, panic_filename
		,
		    log_type == log_default ?
			"default"
		    :
			log_type == log_on ?
			    "extensive"
			:
			    "only errors"
		, getty_path
		, tmp_filename
		, modem_getty
		, email_address ? email_address : "not used"
		, kill_processes ? "will" : "won't"
	    );
    }

    if (!tty_line)
	error("default tty-line missing");
}
