/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "cbstat.h"

int main(int argc, char **argv)
{
    register int
    	avlen;

    progversion(argv[0], CB_VERSION);

    if (argc > 1 && (log_defaults = !strcmp(argv[1], "-l")))/* log requested */
    {
	argv[1] = argv[0];
	argc--;
	argv++;
    }

    if (argc == 1)
    	preusage ();                            /* parse_setupfile may exit */

    parse_setupfile();				/* parse the setupfile */

    if (argc == 1)                              /* parsing succeeded here */
    	usage ();

    avlen = strlen(argv [1]);
    get_ttyline(argv[2]);			/* determine the line, usually
						   in argv[2] */
    if (!strncmp(argv[1], s_enable, avlen))
	reload(the_orgfile);			/* enable the line(s) */
    else if (!strncmp(argv[1], s_disable, avlen))
	reload(the_disfile);			/* disable the line(s) */
    else if (!strncmp(argv[1], "file", avlen))
    	showfile(); 				/* show file */
    else if (!strncmp(argv[1], "init", avlen))
	killinit();				/* re-wake up getty */
    else if (cb_mode == mode_dialin)
	usage();				/* and done for dial-in*/
    else if (!strncmp(argv[1], s_state, avlen)) /* continue for callback mode */
    	showstat();				/* show state */
    else if (!strncmp(argv[1], "list", avlen))
    	list(argv[2]);				/* numbers are shown here */
    else if (argc == 3 || argc == 4)		/* implicit  call */
    {						/* call back to number */
	get_ttyline(argv[3]);			/* determine the line */
    	force(argv[1], argv[2]);		/* force callback */
    }
    else
    	usage();

    return(0);
}
    	
