/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "cbstat.h"

void usage()
{
    printf("\n"
    	   "%s by Frank B. Brokken, original 'cbstat' program by Karel Kubat.\n"
    	   "\n"
    	   "ICCE Callback Status Watcher  V %s.\n"
    	   "Copyright(c) ICCE " YEAR ". All rights reserved.\n"
    	   "\n"
    	   "Usage: %s [-l] action [line]\n"
	   "Where:\n"
	   "	-l: optional flag to log the defaults to '%s'.\n"
	   "\n"
	   "	action: Action to be taken. Select from:\n"
	   "	    disable	    : disables (uu)getty's dial-in\n"
    	   "	    enable	    : resets callback to waiting state (state 0)\n"
    	   "	    file	    : shows (uu)getty's definition file\n"
    	   "	    init	    : restarts init to reload (uu)getty\n"
	   "%s"
	   "%s"
	   , progname
	   , version
	   , progname
	   , log_filename
	   , cb_mode == mode_callback ?
		"	    list [who]	    : lists user-related information\n"
	    :
		""
	    , cb_mode == mode_callback ?
		"	    state	    : shows state of callback\n"
	    :
		""
    );

    if (cb_mode == mode_callback)
	printf
	(
    	   "	    %swho where%s  : forces callback to 'who' at 'where'\n"
	   , call ? "call " : ""
	   , call ? "" : "     "
	);

    printf(
    	   "\n"
           "	line: - the tty-line to use. Recognized lines are:\n"
	   "		ttyS1--ttyS9, 1--9, + (use all configured lines).\n"
	   "	      - If omitted, the default line is used.\n"
	   "	      - Ignored with 'init'%s.\n"
	   "\n"
	    , cb_mode == mode_callback ?
		    ", 'list', and 'who'"
		:
		    ""
	   );

    error
    (
	"%s: %s MODE\n"
	"Actions may be abbreviated, e.g., \"in\" is equivalent to "
    	  						" \"init\".\n"
	, progname
	, cb_mode == mode_callback ?
		"CALLBACK"
	    :
		"DIAL-IN"
    );
}
