#include "holecp.h"

/* copy the files */

int copyfiles (char const *inname, char const *outname)
{
    struct stat
	statbuf;

    /* input file must exist and must be ordinary file */
    if (stat (inname, &statbuf))
	return (message ("can't stat %s", inname));
    if (! (S_ISREG (statbuf.st_mode)) )
	return (message ("%s is not an ordinary file", inname));

    /* if outname doesn't exist: assume it's a filename */
    if (stat (outname, &statbuf))
	return (file2file (inname, outname));

    /* ok, so outname exists. If protected mode: may not overwrite */
    if (S_ISREG (statbuf.st_mode))
    {
	if (flags.dontoverwrite)
	    return (message ("output file %s exists, not overwritten",
			     outname));
	return (file2file (inname, outname));
    }

    /* now outname can only be a directory */
    if (S_ISDIR (statbuf.st_mode))
    {
	char
	    outbuf [1024];
	register char const
	    *slash;

	/* make output filename: directory part */
	strcpy (outbuf, outname);
	if (outbuf [strlen (outbuf) - 1] != '/')
	    strcat (outbuf, "/");

	/* append either full name of input file or beyond last slash */
	if ( (slash = strrchr (inname, '/')) && *(slash + 1) )
	    slash++;
	else
	    slash = inname;
	strcat (outbuf, slash);

	/* don't overwrite unless allowed to */
	if (flags.dontoverwrite && !stat (outbuf, &statbuf))
	    return (message ("output file %s exists, not overwritten",
			     outbuf));

	return (file2file (inname, outbuf));
    }

    /* failed all of the above */
    return (message ("output specification %s is neither a file nor "
		     "a directory", outname));
}
